/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.time.Duration;
import java.util.Map;
import org.neo4j.bolt.v1.runtime.TransactionStateMachine;
import org.neo4j.bolt.v1.runtime.cypher.CypherAdapterStream;
import org.neo4j.bolt.v1.runtime.spi.BoltResult;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.txtracking.TransactionIdTracker;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QuerySource;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

class TransactionStateMachineSPI
implements TransactionStateMachine.SPI {
    private final GraphDatabaseAPI db;
    private final ThreadToStatementContextBridge txBridge;
    private final QueryExecutionEngine queryExecutionEngine;
    private final TransactionIdTracker transactionIdTracker;
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private final TransactionalContextFactory contextFactory;
    private final GraphDatabaseQueryService queryService;
    private final Clock clock;

    TransactionStateMachineSPI(GraphDatabaseAPI db, ThreadToStatementContextBridge txBridge, QueryExecutionEngine queryExecutionEngine, AvailabilityGuard availabilityGuard, GraphDatabaseQueryService queryService, Clock clock) {
        this.db = db;
        this.txBridge = txBridge;
        this.queryExecutionEngine = queryExecutionEngine;
        this.transactionIdTracker = new TransactionIdTracker(db.getDependencyResolver().provideDependency(TransactionIdStore.class), availabilityGuard);
        this.contextFactory = Neo4jTransactionalContextFactory.create((GraphDatabaseQueryService)queryService, (PropertyContainerLocker)locker);
        this.queryService = queryService;
        this.clock = clock;
    }

    @Override
    public void awaitUpToDate(long oldestAcceptableTxId, Duration timeout) throws TransactionFailureException {
        this.transactionIdTracker.awaitUpToDate(oldestAcceptableTxId, timeout);
    }

    @Override
    public long newestEncounteredTxId() {
        return this.transactionIdTracker.newestEncounteredTxId();
    }

    @Override
    public KernelTransaction beginTransaction(SecurityContext securityContext) {
        this.db.beginTransaction(KernelTransaction.Type.explicit, securityContext);
        return this.txBridge.getKernelTransactionBoundToThisThread(false);
    }

    @Override
    public void bindTransactionToCurrentThread(KernelTransaction tx) {
        this.txBridge.bindTransactionToCurrentThread(tx);
    }

    @Override
    public void unbindTransactionFromCurrentThread() {
        this.txBridge.unbindTransactionFromCurrentThread();
    }

    @Override
    public boolean isPeriodicCommit(String query) {
        return this.queryExecutionEngine.isPeriodicCommit(query);
    }

    @Override
    public TransactionStateMachine.BoltResultHandle executeQuery(String querySource, SecurityContext securityContext, final String statement, final Map<String, Object> params, final ThrowingAction<KernelException> onFail) throws QueryExecutionKernelException {
        InternalTransaction internalTransaction = this.queryService.beginTransaction(KernelTransaction.Type.implicit, securityContext);
        QuerySource sourceDetails = new QuerySource(new String[]{"bolt-session", querySource});
        final TransactionalContext transactionalContext = this.contextFactory.newContext(sourceDetails, internalTransaction, statement, params);
        return new TransactionStateMachine.BoltResultHandle(){

            @Override
            public BoltResult start() throws KernelException {
                try {
                    Result run = TransactionStateMachineSPI.this.queryExecutionEngine.executeQuery(statement, params, transactionalContext);
                    return new CypherAdapterStream(run, TransactionStateMachineSPI.this.clock);
                }
                catch (KernelException e) {
                    throw new QueryExecutionKernelException((Throwable)e);
                }
                finally {
                    onFail.apply();
                }
            }

            @Override
            public void terminate() {
                transactionalContext.terminate();
            }
        };
    }
}

