/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.concurrent;

import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.neo4j.bolt.v1.runtime.BoltConnectionAuthFatality;
import org.neo4j.bolt.v1.runtime.BoltConnectionFatality;
import org.neo4j.bolt.v1.runtime.BoltProtocolBreachFatality;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.BoltWorker;
import org.neo4j.bolt.v1.runtime.Job;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;

class RunnableBoltWorker
implements Runnable,
BoltWorker {
    static final Job SHUTDOWN = session1 -> {};
    private static final int workQueueSize = Integer.getInteger("org.neo4j.bolt.workQueueSize", 100);
    private final ArrayBlockingQueue<Job> jobQueue = new ArrayBlockingQueue(workQueueSize);
    private final BoltStateMachine machine;
    private final Log log;
    private final Log userLog;
    private volatile boolean keepRunning = true;

    RunnableBoltWorker(BoltStateMachine machine, LogService logging) {
        this.machine = machine;
        this.log = logging.getInternalLog(this.getClass());
        this.userLog = logging.getUserLog(this.getClass());
    }

    @Override
    public void enqueue(Job job) {
        try {
            this.jobQueue.put(job);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Worker interrupted while queueing request, the session may have been forcibly closed, or the database may be shutting down.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<Job> batch = new ArrayList<Job>(workQueueSize);
        try {
            while (this.keepRunning) {
                Job job = this.jobQueue.poll(10L, TimeUnit.SECONDS);
                if (job == null) continue;
                this.execute(job);
                int jobCount = this.jobQueue.drainTo(batch);
                while (this.keepRunning && jobCount > 0) {
                    this.executeBatch(batch);
                    jobCount = this.jobQueue.drainTo(batch);
                }
            }
        }
        catch (BoltConnectionAuthFatality job) {
        }
        catch (BoltProtocolBreachFatality e) {
            this.log.error("Bolt protocol breach in session '" + this.machine.key() + "'", (Throwable)e);
        }
        catch (Throwable t) {
            this.userLog.error("Worker for session '" + this.machine.key() + "' crashed.", t);
        }
        finally {
            this.machine.close();
        }
    }

    private void executeBatch(ArrayList<Job> batch) throws BoltConnectionFatality {
        for (int i = 0; this.keepRunning && i < batch.size(); ++i) {
            this.execute(batch.get(i));
        }
        batch.clear();
    }

    private void execute(Job job) throws BoltConnectionFatality {
        if (job == SHUTDOWN) {
            this.keepRunning = false;
        } else {
            job.perform(this.machine);
        }
    }

    @Override
    public void interrupt() {
        this.machine.interrupt();
    }

    @Override
    public void halt() {
        try {
            this.machine.terminate();
        }
        finally {
            this.keepRunning = false;
        }
    }
}

