/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.concurrent;

import java.time.Clock;
import org.neo4j.bolt.v1.runtime.BoltFactory;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.BoltWorker;
import org.neo4j.bolt.v1.runtime.WorkerFactory;
import org.neo4j.bolt.v1.runtime.concurrent.RunnableBoltWorker;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.util.JobScheduler;

public class ThreadedWorkerFactory
implements WorkerFactory {
    private BoltFactory connector;
    private JobScheduler scheduler;
    private LogService logging;

    public ThreadedWorkerFactory(BoltFactory connector, JobScheduler scheduler, LogService logging) {
        this.connector = connector;
        this.scheduler = scheduler;
        this.logging = logging;
    }

    @Override
    public BoltWorker newWorker(String connectionDescriptor, Runnable onClose) {
        BoltStateMachine machine = this.connector.newMachine(connectionDescriptor, onClose, Clock.systemUTC());
        RunnableBoltWorker worker = new RunnableBoltWorker(machine, this.logging);
        this.scheduler.schedule(JobScheduler.Groups.sessionWorker, (Runnable)worker, MapUtil.stringMap((String[])new String[]{"thread-id", machine.key()}));
        return worker;
    }
}

