/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.bolt.transport.BoltProtocol;
import org.neo4j.bolt.v1.messaging.BoltMessageRouter;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.runtime.BoltWorker;
import org.neo4j.bolt.v1.transport.BoltV1Dechunker;
import org.neo4j.bolt.v1.transport.ChunkedOutput;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;

public class BoltProtocolV1
implements BoltProtocol {
    public static final int VERSION = 1;
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 8192;
    private final ChunkedOutput chunkedOutput;
    private final BoltResponseMessageWriter packer;
    private final BoltV1Dechunker dechunker;
    private final BoltWorker worker;
    private final AtomicInteger inFlight = new AtomicInteger(0);
    private final Log log;

    public BoltProtocolV1(BoltWorker worker, Channel outputChannel, LogService logging) {
        this.chunkedOutput = new ChunkedOutput(outputChannel, 8192);
        this.packer = new BoltResponseMessageWriter(new Neo4jPack.Packer(this.chunkedOutput), this.chunkedOutput);
        this.worker = worker;
        this.log = logging.getInternalLog(this.getClass());
        this.dechunker = this.createDechunker(this.packer, worker, this.log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(ChannelHandlerContext channelContext, ByteBuf data) throws IOException {
        try {
            this.dechunker.handle(data);
        }
        catch (Throwable t) {
            this.log.error("Failed to handle incoming Bolt message. Connection will be closed.", t);
            this.worker.halt();
        }
        finally {
            data.release();
        }
    }

    @Override
    public int version() {
        return 1;
    }

    @Override
    public synchronized void close() {
        this.dechunker.close();
        this.worker.halt();
        this.chunkedOutput.close();
    }

    private BoltV1Dechunker createDechunker(BoltResponseMessageWriter responseHandler, BoltWorker boltWorker, Log log) {
        BoltMessageRouter bridge = new BoltMessageRouter(log, boltWorker, responseHandler, this::onMessageDone);
        return new BoltV1Dechunker(bridge, this::onMessageStarted);
    }

    private void onMessageStarted() {
        this.inFlight.incrementAndGet();
    }

    private void onMessageDone() {
        if (this.inFlight.decrementAndGet() == 0 && !this.dechunker.isInMiddleOfAMessage()) {
            try {
                this.packer.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

