/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageHandler;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.transport.ChunkedInput;

public class BoltV1Dechunker {
    private final ChunkedInput input;
    private final BoltRequestMessageReader unpacker;
    private final BoltRequestMessageHandler<RuntimeException> onMessage;
    private final Runnable onMessageStarted;
    private State state = State.AWAITING_CHUNK;
    private int chunkSize = 0;

    public BoltV1Dechunker(BoltRequestMessageHandler<RuntimeException> messageHandler, Runnable onMessageStarted) {
        this.onMessage = messageHandler;
        this.onMessageStarted = onMessageStarted;
        this.input = new ChunkedInput();
        this.unpacker = new BoltRequestMessageReader(new Neo4jPack.Unpacker(this.input));
    }

    public boolean isInMiddleOfAMessage() {
        return this.chunkSize != 0;
    }

    public void handle(ByteBuf data) throws IOException {
        block6: while (data.readableBytes() > 0) {
            switch (this.state) {
                case AWAITING_CHUNK: {
                    if (data.readableBytes() >= 2) {
                        this.chunkSize = data.readUnsignedShort();
                        this.handleHeader();
                        continue block6;
                    }
                    this.chunkSize = data.readUnsignedByte() << 8;
                    this.state = State.IN_HEADER;
                    continue block6;
                }
                case IN_HEADER: {
                    this.chunkSize |= data.readUnsignedByte();
                    this.handleHeader();
                    continue block6;
                }
                case IN_CHUNK: {
                    if (this.chunkSize < data.readableBytes()) {
                        this.input.append(data.readSlice(this.chunkSize));
                        this.state = State.AWAITING_CHUNK;
                        continue block6;
                    }
                    if (this.chunkSize == data.readableBytes()) {
                        this.input.append(data);
                        this.state = State.AWAITING_CHUNK;
                        return;
                    }
                    this.chunkSize -= data.readableBytes();
                    this.input.append(data);
                    return;
                }
                case CLOSED: {
                    return;
                }
            }
            throw new IllegalStateException("Unknown state: " + (Object)((Object)this.state));
        }
    }

    public synchronized void close() {
        this.state = State.CLOSED;
        this.input.close();
    }

    private void handleHeader() throws IOException {
        if (this.chunkSize == 0) {
            try {
                this.onMessageStarted.run();
                this.unpacker.read(this.onMessage);
            }
            finally {
                this.input.clear();
            }
            this.state = State.AWAITING_CHUNK;
        } else {
            this.state = State.IN_CHUNK;
        }
    }

    public static enum State {
        AWAITING_CHUNK,
        IN_CHUNK,
        IN_HEADER,
        CLOSED;

    }
}

