/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.net.SocketAddress;
import org.neo4j.bolt.BoltConnectionDescriptor;
import org.neo4j.bolt.logging.BoltMessageLogger;

public class BoltChannel
implements AutoCloseable,
BoltConnectionDescriptor {
    private final ChannelHandlerContext channelHandlerContext;
    private final BoltMessageLogger messageLogger;

    public static BoltChannel open(ChannelHandlerContext channelHandlerContext, BoltMessageLogger messageLogger) {
        return new BoltChannel(channelHandlerContext, messageLogger);
    }

    private BoltChannel(ChannelHandlerContext channelHandlerContext, BoltMessageLogger messageLogger) {
        this.channelHandlerContext = channelHandlerContext;
        this.messageLogger = messageLogger;
        messageLogger.serverEvent("OPEN");
    }

    public ChannelHandlerContext channelHandlerContext() {
        return this.channelHandlerContext;
    }

    public Channel rawChannel() {
        return this.channelHandlerContext.channel();
    }

    public BoltMessageLogger log() {
        return this.messageLogger;
    }

    @Override
    public void close() {
        Channel rawChannel = this.rawChannel();
        if (rawChannel.isOpen()) {
            this.messageLogger.serverEvent("CLOSE");
            rawChannel.close().syncUninterruptibly();
        }
    }

    @Override
    public SocketAddress clientAddress() {
        return this.channelHandlerContext.channel().remoteAddress();
    }

    @Override
    public SocketAddress serverAddress() {
        return this.channelHandlerContext.channel().localAddress();
    }
}

