/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.logging;

import io.netty.channel.Channel;
import java.io.File;
import java.time.ZoneId;
import java.util.concurrent.Executor;
import org.neo4j.bolt.logging.BoltMessageLog;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.bolt.logging.BoltMessageLoggerImpl;
import org.neo4j.bolt.logging.NullBoltMessageLogger;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.scheduler.JobScheduler;

public class BoltMessageLogging {
    private final BoltMessageLog boltMessageLog;

    private BoltMessageLogging(BoltMessageLog boltMessageLog) {
        this.boltMessageLog = boltMessageLog;
    }

    public static BoltMessageLogging create(FileSystemAbstraction fs, JobScheduler scheduler, Config config, Log log) {
        return new BoltMessageLogging(BoltMessageLogging.createBoltMessageLog(fs, scheduler, config, log));
    }

    public static BoltMessageLogging none() {
        return new BoltMessageLogging(null);
    }

    public BoltMessageLogger newLogger(Channel channel) {
        return this.boltMessageLog == null ? NullBoltMessageLogger.getInstance() : new BoltMessageLoggerImpl(this.boltMessageLog, channel);
    }

    private static BoltMessageLog createBoltMessageLog(FileSystemAbstraction fs, JobScheduler scheduler, Config config, Log log) {
        if (((Boolean)config.get(GraphDatabaseSettings.bolt_logging_enabled)).booleanValue()) {
            try {
                File boltLogFile = (File)config.get(GraphDatabaseSettings.bolt_log_filename);
                Executor executor = scheduler.executor(JobScheduler.Groups.boltLogRotation);
                ZoneId logTimeZoneId = ((LogTimeZone)config.get(GraphDatabaseSettings.log_timezone)).getZoneId();
                return new BoltMessageLog(fs, logTimeZoneId, boltLogFile, executor);
            }
            catch (Throwable t) {
                log.warn("Unable to create bolt message log. It is thus disabled", t);
            }
        }
        return null;
    }
}

