/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.transport.BoltMessagingProtocolHandler;
import org.neo4j.bolt.transport.HandshakeOutcome;

public class BoltHandshakeProtocolHandler {
    public static final int BOLT_MAGIC_PREAMBLE = 1616949271;
    private final Map<Long, Function<BoltChannel, BoltMessagingProtocolHandler>> protocolHandlers;
    private final boolean encryptionRequired;
    private final boolean isEncrypted;
    private final ByteBuffer handshakeBuffer = ByteBuffer.allocate(20).order(ByteOrder.BIG_ENDIAN);
    private BoltMessagingProtocolHandler protocol;

    public BoltHandshakeProtocolHandler(Map<Long, Function<BoltChannel, BoltMessagingProtocolHandler>> protocolHandlers, boolean encryptionRequired, boolean isEncrypted) {
        this.protocolHandlers = protocolHandlers;
        this.encryptionRequired = encryptionRequired;
        this.isEncrypted = isEncrypted;
    }

    public HandshakeOutcome perform(BoltChannel boltChannel, ByteBuf buffer) {
        if (this.encryptionRequired && !this.isEncrypted) {
            boltChannel.log().serverError("HANDSHAKE", "Insecure handshake");
            return HandshakeOutcome.INSECURE_HANDSHAKE;
        }
        if (this.handshakeBuffer.remaining() > buffer.readableBytes()) {
            this.handshakeBuffer.limit(this.handshakeBuffer.position() + buffer.readableBytes());
            buffer.readBytes(this.handshakeBuffer);
            this.handshakeBuffer.limit(this.handshakeBuffer.capacity());
        } else {
            buffer.readBytes(this.handshakeBuffer);
        }
        if (this.handshakeBuffer.remaining() == 0) {
            this.handshakeBuffer.flip();
            if (this.handshakeBuffer.getInt() != 1616949271) {
                boltChannel.log().clientError("HANDSHAKE", "Invalid Bolt signature", () -> String.format("0x%08X", this.handshakeBuffer.getInt()));
                return HandshakeOutcome.INVALID_HANDSHAKE;
            }
            boltChannel.log().clientEvent("HANDSHAKE", () -> String.format("0x%08X", 1616949271));
            for (int i = 0; i < 4; ++i) {
                long suggestion = (long)this.handshakeBuffer.getInt() & 0xFFFFFFFFL;
                if (!this.protocolHandlers.containsKey(suggestion)) continue;
                this.protocol = this.protocolHandlers.get(suggestion).apply(boltChannel);
                boltChannel.log().serverEvent("HANDSHAKE", () -> String.format("0x%02X", this.protocol.version()));
                return HandshakeOutcome.PROTOCOL_CHOSEN;
            }
            boltChannel.log().serverError("HANDSHAKE", "No applicable protocol");
            return HandshakeOutcome.NO_APPLICABLE_PROTOCOL;
        }
        boltChannel.log().serverError("HANDSHAKE", "Partial handshake");
        return HandshakeOutcome.PARTIAL_HANDSHAKE;
    }

    public BoltMessagingProtocolHandler chosenProtocol() {
        return this.protocol;
    }
}

