/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.bolt.v1.messaging.BoltResponseMessage;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageBoundaryHook;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageHandler;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.cypher.result.QueryResult;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.BaseToObjectValueWriter;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.utils.PrettyPrinter;
import org.neo4j.values.virtual.MapValue;

public class BoltResponseMessageWriter
implements BoltResponseMessageHandler<IOException> {
    public static final BoltResponseMessageBoundaryHook NO_BOUNDARY_HOOK = () -> {};
    private final Neo4jPack.Packer packer;
    private final BoltResponseMessageBoundaryHook onMessageComplete;
    private final BoltMessageLogger messageLogger;

    public BoltResponseMessageWriter(Neo4jPack.Packer packer, BoltResponseMessageBoundaryHook onMessageComplete, BoltMessageLogger messageLogger) {
        this.packer = packer;
        this.onMessageComplete = onMessageComplete;
        this.messageLogger = messageLogger;
    }

    @Override
    public void onRecord(QueryResult.Record item) throws IOException {
        AnyValue[] fields = item.fields();
        this.packer.packStructHeader(1, BoltResponseMessage.RECORD.signature());
        this.packer.packListHeader(fields.length);
        for (AnyValue field : fields) {
            this.packer.pack(field);
        }
        this.onMessageComplete.onMessageComplete();
        this.packer.consumeError();
    }

    @Override
    public void onSuccess(MapValue metadata) throws IOException {
        this.messageLogger.logSuccess(() -> metadata);
        this.packer.packStructHeader(1, BoltResponseMessage.SUCCESS.signature());
        this.packer.packRawMap(metadata);
        this.onMessageComplete.onMessageComplete();
    }

    private Supplier<String> metadataSupplier(MapValue metadata) {
        return () -> {
            PrettyPrinter printer = new PrettyPrinter();
            metadata.writeTo((AnyValueWriter)printer);
            return printer.value();
        };
    }

    @Override
    public void onIgnored() throws IOException {
        this.messageLogger.logIgnored();
        this.packer.packStructHeader(0, BoltResponseMessage.IGNORED.signature());
        this.onMessageComplete.onMessageComplete();
    }

    @Override
    public void onFailure(Status status, String errorMessage) throws IOException {
        this.messageLogger.logFailure(status);
        this.packer.packStructHeader(1, BoltResponseMessage.FAILURE.signature());
        this.packer.packMapHeader(2);
        this.packer.pack("code");
        this.packer.pack(status.code().serialize());
        this.packer.pack("message");
        this.packer.pack(errorMessage);
        this.onMessageComplete.onMessageComplete();
    }

    @Override
    public void onFatal(Status status, String errorMessage) throws IOException {
        this.messageLogger.serverError("FATAL", status);
        this.onFailure(status, errorMessage);
        this.flush();
    }

    public void flush() throws IOException {
        this.packer.flush();
    }

    private class MapToObjectWriter
    extends BaseToObjectValueWriter<RuntimeException> {
        private UnsupportedOperationException exception = new UnsupportedOperationException("Functionality not implemented.");

        private MapToObjectWriter() {
        }

        protected Node newNodeProxyById(long id) {
            throw this.exception;
        }

        protected Relationship newRelationshipProxyById(long id) {
            throw this.exception;
        }

        protected Point newGeographicPoint(double longitude, double latitude, String name, int code, String href) {
            throw this.exception;
        }

        protected Point newCartesianPoint(double x, double y, String name, int code, String href) {
            throw this.exception;
        }
    }
}

