/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.neo4j.bolt.v1.messaging.BoltIOException;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.packstream.PackStream;
import org.neo4j.bolt.v1.packstream.PackType;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.collection.primitive.PrimitiveLongIntKeyValueArray;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.BaseToObjectValueWriter;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.CoordinateReferenceSystem;
import org.neo4j.values.virtual.EdgeValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.VirtualValues;

public class Neo4jPack {
    private static final List<Object> EMPTY_LIST = new ArrayList<Object>();
    private static final Map<String, AnyValue> EMPTY_MAP = new HashMap<String, AnyValue>();
    public static final byte NODE = 78;
    public static final byte RELATIONSHIP = 82;
    public static final byte UNBOUND_RELATIONSHIP = 114;
    public static final byte PATH = 80;

    private Neo4jPack() {
    }

    private static class UnpackerWriter
    extends BaseToObjectValueWriter<RuntimeException> {
        private UnpackerWriter() {
        }

        protected Node newNodeProxyById(long id) {
            throw new UnsupportedOperationException("Cannot unpack nodes");
        }

        protected Relationship newRelationshipProxyById(long id) {
            throw new UnsupportedOperationException("Cannot unpack relationships");
        }

        protected Point newGeographicPoint(double longitude, double latitude, String name, int code, String href) {
            throw new UnsupportedOperationException("Cannot unpack points");
        }

        protected Point newCartesianPoint(double x, double y, String name, int code, String href) {
            throw new UnsupportedOperationException("Cannot unpack points");
        }
    }

    private static class Error {
        private final Status status;
        private final String msg;

        private Error(Status status, String msg) {
            this.status = status;
            this.msg = msg;
        }

        Status status() {
            return this.status;
        }

        String msg() {
            return this.msg;
        }
    }

    public static class Unpacker
    extends PackStream.Unpacker {
        private List<Neo4jError> errors = new ArrayList<Neo4jError>(2);

        public Unpacker(PackInput input) {
            super(input);
        }

        public AnyValue unpack() throws IOException {
            PackType valType = this.peekNextType();
            switch (valType) {
                case BYTES: {
                    return Values.byteArray((byte[])this.unpackBytes());
                }
                case STRING: {
                    return Values.stringValue((String)this.unpackString());
                }
                case INTEGER: {
                    return Values.longValue((long)this.unpackLong());
                }
                case FLOAT: {
                    return Values.doubleValue((double)this.unpackDouble());
                }
                case BOOLEAN: {
                    return Values.booleanValue((boolean)this.unpackBoolean());
                }
                case NULL: {
                    this.unpackNull();
                    return Values.NO_VALUE;
                }
                case LIST: {
                    return this.unpackList();
                }
                case MAP: {
                    return this.unpackMap();
                }
                case STRUCT: {
                    this.unpackStructHeader();
                    char signature = this.unpackStructSignature();
                    switch (signature) {
                        case 'N': {
                            throw new BoltIOException((Status)Status.Request.Invalid, "Nodes cannot be unpacked.");
                        }
                        case 'R': {
                            throw new BoltIOException((Status)Status.Request.Invalid, "Relationships cannot be unpacked.");
                        }
                        case 'r': {
                            throw new BoltIOException((Status)Status.Request.Invalid, "Relationships cannot be unpacked.");
                        }
                        case 'P': {
                            throw new BoltIOException((Status)Status.Request.Invalid, "Paths cannot be unpacked.");
                        }
                    }
                    throw new BoltIOException((Status)Status.Request.InvalidFormat, "Unknown struct type: " + Integer.toHexString(signature));
                }
                case END_OF_STREAM: {
                    this.unpackEndOfStream();
                    return null;
                }
            }
            throw new BoltIOException((Status)Status.Request.InvalidFormat, "Unknown value type: " + (Object)((Object)valType));
        }

        ListValue unpackList() throws IOException {
            ArrayList<AnyValue> list;
            int size = (int)this.unpackListHeader();
            if (size == 0) {
                return VirtualValues.EMPTY_LIST;
            }
            if ((long)size == -1L) {
                list = new ArrayList<AnyValue>();
                boolean more = true;
                block3: while (more) {
                    PackType keyType = this.peekNextType();
                    switch (keyType) {
                        case END_OF_STREAM: {
                            this.unpack();
                            more = false;
                            continue block3;
                        }
                    }
                    list.add(this.unpack());
                }
            } else {
                list = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    list.add(this.unpack());
                }
            }
            return VirtualValues.list((AnyValue[])list.toArray(new AnyValue[list.size()]));
        }

        public MapValue unpackMap() throws IOException {
            HashMap<String, AnyValue> map;
            int size = (int)this.unpackMapHeader();
            if (size == 0) {
                return VirtualValues.EMPTY_MAP;
            }
            if ((long)size == -1L) {
                map = new HashMap<String, AnyValue>();
                boolean more = true;
                block9: while (more) {
                    PackType keyType = this.peekNextType();
                    switch (keyType) {
                        case END_OF_STREAM: {
                            this.unpack();
                            more = false;
                            continue block9;
                        }
                        case STRING: {
                            AnyValue val;
                            String key = this.unpackString();
                            if (map.put(key, val = this.unpack()) == null) continue block9;
                            this.errors.add(Neo4jError.from((Status)Status.Request.Invalid, "Duplicate map key `" + key + "`."));
                            continue block9;
                        }
                        case NULL: {
                            this.errors.add(Neo4jError.from((Status)Status.Request.Invalid, "Value `null` is not supported as key in maps, must be a non-nullable string."));
                            this.unpackNull();
                            AnyValue val = this.unpack();
                            map.put(null, val);
                            continue block9;
                        }
                    }
                    throw new PackStream.PackStreamException("Bad key type");
                }
            } else {
                map = new HashMap(size, 1.0f);
                for (int i = 0; i < size; ++i) {
                    String key;
                    PackType type = this.peekNextType();
                    switch (type) {
                        case NULL: {
                            this.errors.add(Neo4jError.from((Status)Status.Request.Invalid, "Value `null` is not supported as key in maps, must be a non-nullable string."));
                            this.unpackNull();
                            key = null;
                            break;
                        }
                        case STRING: {
                            key = this.unpackString();
                            break;
                        }
                        default: {
                            throw new PackStream.PackStreamException("Bad key type: " + (Object)((Object)type));
                        }
                    }
                    AnyValue val = this.unpack();
                    if (map.put(key, val) == null) continue;
                    this.errors.add(Neo4jError.from((Status)Status.Request.Invalid, "Duplicate map key `" + key + "`."));
                }
            }
            return VirtualValues.map(map);
        }

        public Map<String, Object> unpackToRawMap() throws IOException {
            MapValue mapValue = this.unpackMap();
            HashMap<String, Object> map = new HashMap<String, Object>(mapValue.size());
            for (Map.Entry entry : mapValue.entrySet()) {
                UnpackerWriter unpackerWriter = new UnpackerWriter();
                ((AnyValue)entry.getValue()).writeTo((AnyValueWriter)unpackerWriter);
                map.put((String)entry.getKey(), unpackerWriter.value());
            }
            return map;
        }

        Optional<Neo4jError> consumeError() {
            if (this.errors.isEmpty()) {
                return Optional.empty();
            }
            Neo4jError combined = Neo4jError.combine(this.errors);
            this.errors.clear();
            return Optional.of(combined);
        }
    }

    public static class Packer
    extends PackStream.Packer
    implements AnyValueWriter<IOException> {
        private Error error;
        private static final int INITIAL_PATH_CAPACITY = 500;
        private static final int NO_SUCH_ID = -1;
        private final PrimitiveLongIntKeyValueArray nodeIndexes = new PrimitiveLongIntKeyValueArray(501);
        private final PrimitiveLongIntKeyValueArray edgeIndexes = new PrimitiveLongIntKeyValueArray(500);

        public Packer(PackOutput output) {
            super(output);
        }

        public void pack(AnyValue value) throws IOException {
            value.writeTo((AnyValueWriter)this);
        }

        public void packRawMap(MapValue map) throws IOException {
            this.packMapHeader(map.size());
            for (Map.Entry entry : map.entrySet()) {
                this.pack((String)entry.getKey());
                this.pack((AnyValue)entry.getValue());
            }
        }

        void consumeError() throws BoltIOException {
            if (this.error != null) {
                BoltIOException exception = new BoltIOException(this.error.status(), this.error.msg());
                this.error = null;
                throw exception;
            }
        }

        public boolean hasErrors() {
            return this.error != null;
        }

        public void writeNodeReference(long nodeId) throws IOException {
            this.packStructHeader(3, (byte)78);
            this.pack(nodeId);
            this.packListHeader(0);
            this.packMapHeader(0);
        }

        public void writeNode(long nodeId, TextArray labels, MapValue properties) throws IOException {
            this.packStructHeader(3, (byte)78);
            this.pack(nodeId);
            this.packListHeader(labels.length());
            for (int i = 0; i < labels.length(); ++i) {
                labels.value(i).writeTo((AnyValueWriter)this);
            }
            properties.writeTo((AnyValueWriter)this);
        }

        public void writeEdgeReference(long edgeId) throws IOException {
            throw new UnsupportedOperationException("Cannot write a raw edge reference");
        }

        public void writeEdge(long edgeId, long startNodeId, long endNodeId, TextValue type, MapValue properties) throws IOException {
            this.packStructHeader(5, (byte)82);
            this.pack(edgeId);
            this.pack(startNodeId);
            this.pack(endNodeId);
            type.writeTo((AnyValueWriter)this);
            properties.writeTo((AnyValueWriter)this);
        }

        public void beginMap(int size) throws IOException {
            this.packMapHeader(size);
        }

        public void endMap() throws IOException {
        }

        public void beginList(int size) throws IOException {
            this.packListHeader(size);
        }

        public void endList() throws IOException {
        }

        public void writePath(NodeValue[] nodes, EdgeValue[] edges) throws IOException {
            this.packStructHeader(3, (byte)80);
            this.writeNodesForPath(nodes);
            this.writeEdgesForPath(edges);
            this.packListHeader(2 * edges.length);
            if (edges.length == 0) {
                return;
            }
            NodeValue node = nodes[0];
            for (int i = 1; i <= 2 * edges.length; ++i) {
                if (i % 2 == 0) {
                    node = nodes[i / 2];
                    int index = this.nodeIndexes.getOrDefault(node.id(), -1);
                    this.pack(index);
                    continue;
                }
                EdgeValue edge = edges[i / 2];
                int index = this.edgeIndexes.getOrDefault(edge.id(), -1);
                if (node.id() == edge.startNode().id()) {
                    this.pack(index);
                    continue;
                }
                this.pack(-index);
            }
        }

        private void writeNodesForPath(NodeValue[] nodes) throws IOException {
            this.nodeIndexes.reset(nodes.length);
            for (NodeValue node : nodes) {
                this.nodeIndexes.putIfAbsent(node.id(), this.nodeIndexes.size());
            }
            int size = this.nodeIndexes.size();
            this.packListHeader(size);
            if (size > 0) {
                NodeValue node = nodes[0];
                for (long id : this.nodeIndexes.keys()) {
                    int i = 1;
                    while (node.id() != id) {
                        node = nodes[i++];
                    }
                    node.writeTo((AnyValueWriter)this);
                }
            }
        }

        private void writeEdgesForPath(EdgeValue[] edges) throws IOException {
            this.edgeIndexes.reset(edges.length);
            for (EdgeValue node : edges) {
                this.edgeIndexes.putIfAbsent(node.id(), this.edgeIndexes.size() + 1);
            }
            int size = this.edgeIndexes.size();
            this.packListHeader(size);
            if (size > 0) {
                EdgeValue edge = edges[0];
                for (long id : this.edgeIndexes.keys()) {
                    int i = 1;
                    while (edge.id() != id) {
                        edge = edges[i++];
                    }
                    this.packStructHeader(3, (byte)114);
                    this.pack(edge.id());
                    edge.type().writeTo((AnyValueWriter)this);
                    edge.properties().writeTo((AnyValueWriter)this);
                }
            }
        }

        public void beginPoint(CoordinateReferenceSystem coordinateReferenceSystem) throws IOException {
            this.error = new Error((Status)Status.Request.Invalid, "Point is not yet supported as a return type in Bolt");
            this.packNull();
        }

        public void endPoint() throws IOException {
        }

        public void writeNull() throws IOException {
            this.packNull();
        }

        public void writeBoolean(boolean value) throws IOException {
            this.pack(value);
        }

        public void writeInteger(byte value) throws IOException {
            this.pack(value);
        }

        public void writeInteger(short value) throws IOException {
            this.pack(value);
        }

        public void writeInteger(int value) throws IOException {
            this.pack(value);
        }

        public void writeInteger(long value) throws IOException {
            this.pack(value);
        }

        public void writeFloatingPoint(float value) throws IOException {
            this.pack(value);
        }

        public void writeFloatingPoint(double value) throws IOException {
            this.pack(value);
        }

        public void writeUTF8(byte[] bytes, int offset, int length) throws IOException {
            this.packUTF8(bytes, offset, length);
        }

        public void writeString(String value) throws IOException {
            this.pack(value);
        }

        public void writeString(char value) throws IOException {
            this.pack(value);
        }

        public void writeString(char[] value, int offset, int length) throws IOException {
            this.pack(String.valueOf(value, offset, length));
        }

        public void beginArray(int size, ValueWriter.ArrayType arrayType) throws IOException {
            switch (arrayType) {
                case BYTE: {
                    this.packBytesHeader(size);
                    break;
                }
                default: {
                    this.packListHeader(size);
                }
            }
        }

        public void endArray() throws IOException {
        }

        public void writeByteArray(byte[] value) throws IOException {
            this.pack(value);
        }
    }
}

