/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import io.netty.channel.Channel;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.bolt.v1.runtime.BoltWorkerQueueMonitor;
import org.neo4j.bolt.v1.runtime.Job;
import org.neo4j.logging.Log;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;

public class BoltChannelAutoReadLimiter
implements BoltWorkerQueueMonitor {
    protected static final String LOW_WATERMARK_NAME = "low_watermark";
    protected static final String HIGH_WATERMARK_NAME = "high_watermark";
    private final AtomicInteger queueSize = new AtomicInteger(0);
    private final Channel channel;
    private final Log log;
    private final int lowWatermark;
    private final int highWatermark;

    public BoltChannelAutoReadLimiter(Channel channel, Log log) {
        this(channel, log, FeatureToggles.getInteger(BoltChannelAutoReadLimiter.class, (String)LOW_WATERMARK_NAME, (int)100), FeatureToggles.getInteger(BoltChannelAutoReadLimiter.class, (String)HIGH_WATERMARK_NAME, (int)300));
    }

    public BoltChannelAutoReadLimiter(Channel channel, Log log, int lowWatermark, int highWatermark) {
        if (highWatermark <= 0) {
            throw new IllegalArgumentException("invalid highWatermark value");
        }
        if (lowWatermark < 0 || lowWatermark >= highWatermark) {
            throw new IllegalArgumentException("invalid lowWatermark value");
        }
        this.channel = Objects.requireNonNull(channel);
        this.log = log;
        this.lowWatermark = lowWatermark;
        this.highWatermark = highWatermark;
    }

    protected int getLowWatermark() {
        return this.lowWatermark;
    }

    protected int getHighWatermark() {
        return this.highWatermark;
    }

    @Override
    public void enqueued(Job job) {
        this.checkLimitsOnEnqueue(this.queueSize.incrementAndGet());
    }

    @Override
    public void dequeued(Job job) {
        this.checkLimitsOnDequeue(this.queueSize.decrementAndGet());
    }

    @Override
    public void drained(Collection<Job> jobs) {
        this.checkLimitsOnDequeue(this.queueSize.addAndGet(-jobs.size()));
    }

    private void checkLimitsOnEnqueue(int currentSize) {
        if (currentSize > this.highWatermark && this.channel.config().isAutoRead()) {
            if (this.log != null) {
                this.log.warn("Channel [%s]: client produced %d messages on the worker queue, auto-read is being disabled.", new Object[]{this.channel.id(), currentSize});
            }
            this.channel.config().setAutoRead(false);
        }
    }

    private void checkLimitsOnDequeue(int currentSize) {
        if (currentSize <= this.lowWatermark && !this.channel.config().isAutoRead()) {
            if (this.log != null) {
                this.log.warn("Channel [%s]: consumed messages on the worker queue below %d, auto-read is being enabled.", new Object[]{this.channel.id(), currentSize});
            }
            this.channel.config().setAutoRead(true);
        }
    }
}

