/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.time.Duration;
import java.util.function.Supplier;
import org.neo4j.bolt.v1.runtime.BoltQuerySource;
import org.neo4j.bolt.v1.runtime.CypherAdapterStream;
import org.neo4j.bolt.v1.runtime.TransactionStateMachine;
import org.neo4j.bolt.v1.runtime.spi.BoltResult;
import org.neo4j.cypher.internal.javacompat.QueryResultProvider;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.txtracking.TransactionIdTracker;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.impl.query.clientconnection.BoltConnectionInfo;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.values.virtual.MapValue;

class TransactionStateMachineSPI
implements TransactionStateMachine.SPI {
    private final GraphDatabaseAPI db;
    private final ThreadToStatementContextBridge txBridge;
    private final QueryExecutionEngine queryExecutionEngine;
    private final TransactionIdTracker transactionIdTracker;
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private final TransactionalContextFactory contextFactory;
    private final GraphDatabaseQueryService queryService;
    private final Duration txAwaitDuration;
    private final Clock clock;

    TransactionStateMachineSPI(GraphDatabaseAPI db, ThreadToStatementContextBridge txBridge, QueryExecutionEngine queryExecutionEngine, AvailabilityGuard availabilityGuard, GraphDatabaseQueryService queryService, Duration txAwaitDuration, Clock clock) {
        this.db = db;
        this.txBridge = txBridge;
        this.queryExecutionEngine = queryExecutionEngine;
        Supplier transactionIdStoreSupplier = db.getDependencyResolver().provideDependency(TransactionIdStore.class);
        this.transactionIdTracker = new TransactionIdTracker(transactionIdStoreSupplier, availabilityGuard);
        this.contextFactory = Neo4jTransactionalContextFactory.create((GraphDatabaseQueryService)queryService, (PropertyContainerLocker)locker);
        this.queryService = queryService;
        this.txAwaitDuration = txAwaitDuration;
        this.clock = clock;
    }

    @Override
    public void awaitUpToDate(long oldestAcceptableTxId) throws TransactionFailureException {
        this.transactionIdTracker.awaitUpToDate(oldestAcceptableTxId, this.txAwaitDuration);
    }

    @Override
    public long newestEncounteredTxId() {
        return this.transactionIdTracker.newestEncounteredTxId();
    }

    @Override
    public KernelTransaction beginTransaction(SecurityContext securityContext) {
        this.db.beginTransaction(KernelTransaction.Type.explicit, securityContext);
        return this.txBridge.getKernelTransactionBoundToThisThread(false);
    }

    @Override
    public void bindTransactionToCurrentThread(KernelTransaction tx) {
        this.txBridge.bindTransactionToCurrentThread(tx);
    }

    @Override
    public void unbindTransactionFromCurrentThread() {
        this.txBridge.unbindTransactionFromCurrentThread();
    }

    @Override
    public boolean isPeriodicCommit(String query) {
        return this.queryExecutionEngine.isPeriodicCommit(query);
    }

    @Override
    public TransactionStateMachine.BoltResultHandle executeQuery(BoltQuerySource querySource, SecurityContext securityContext, final String statement, final MapValue params, final ThrowingAction<KernelException> onFail) {
        InternalTransaction internalTransaction = this.queryService.beginTransaction(KernelTransaction.Type.implicit, securityContext);
        BoltConnectionInfo sourceDetails = new BoltConnectionInfo(querySource.principalName, querySource.clientName, querySource.connectionDescriptor.clientAddress(), querySource.connectionDescriptor.serverAddress());
        final TransactionalContext transactionalContext = this.contextFactory.newContext((ClientConnectionInfo)sourceDetails, internalTransaction, statement, params);
        return new TransactionStateMachine.BoltResultHandle(){

            @Override
            public BoltResult start() throws KernelException {
                try {
                    Result result = TransactionStateMachineSPI.this.queryExecutionEngine.executeQuery(statement, params, transactionalContext);
                    if (result instanceof QueryResultProvider) {
                        return new CypherAdapterStream(((QueryResultProvider)result).queryResult(), TransactionStateMachineSPI.this.clock);
                    }
                    throw new IllegalStateException(String.format("Unexpected query execution result. Expected to get instance of %s but was %s.", QueryResultProvider.class.getName(), result.getClass().getName()));
                }
                catch (KernelException e) {
                    throw new QueryExecutionKernelException((Throwable)e);
                }
                finally {
                    onFail.apply();
                }
            }

            @Override
            public void terminate() {
                transactionalContext.terminate();
            }
        };
    }
}

