/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.Neo4jPackV1;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.SecureSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.SecureWebSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.SocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.bolt.v1.transport.socket.client.WebSocketConnection;
import org.neo4j.bolt.v2.messaging.Neo4jPackV2;
import org.neo4j.helpers.HostnamePort;

@RunWith(value=Parameterized.class)
public abstract class AbstractBoltTransportsTest {
    private static final List<Class<? extends TransportConnection>> CONNECTION_CLASSES = Arrays.asList(SocketConnection.class, WebSocketConnection.class, SecureSocketConnection.class, SecureWebSocketConnection.class);
    private static final List<Neo4jPack> NEO4J_PACK_VERSIONS = Arrays.asList(new Neo4jPackV1(), new Neo4jPackV2());
    @Parameterized.Parameter(value=0)
    public Class<? extends TransportConnection> connectionClass;
    @Parameterized.Parameter(value=1)
    public Neo4jPack neo4jPack;
    @Parameterized.Parameter(value=2)
    public String name;
    protected HostnamePort address;
    protected TransportConnection connection;
    protected TransportTestUtil util;

    @Before
    public void initializeConnectionAndUtil() throws Exception {
        this.connection = this.connectionClass.newInstance();
        this.util = new TransportTestUtil(this.neo4jPack);
    }

    @After
    public void disconnectFromDatabase() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    @Parameterized.Parameters(name="{2}")
    public static List<Object[]> parameters() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (Class<? extends TransportConnection> connectionClass : CONNECTION_CLASSES) {
            for (Neo4jPack neo4jPack : NEO4J_PACK_VERSIONS) {
                result.add(new Object[]{connectionClass, neo4jPack, AbstractBoltTransportsTest.newName(connectionClass, neo4jPack)});
            }
        }
        return result;
    }

    protected TransportConnection newConnection() throws Exception {
        return this.connectionClass.newInstance();
    }

    protected void reconnect() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
        this.connection = this.newConnection();
    }

    private static String newName(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack) {
        return connectionClass.getSimpleName() + " & " + neo4jPack;
    }
}

