/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.logging.BoltMessageLogger;

@RunWith(value=MockitoJUnitRunner.class)
public class BoltChannelTest {
    private final String connector = "default";
    @Mock
    private Channel channel;
    @Mock
    private BoltMessageLogger messageLogger;

    @Test
    public void shouldLogWhenOpened() {
        BoltChannel boltChannel = BoltChannel.open((String)"default", (Channel)this.channel, (BoltMessageLogger)this.messageLogger);
        Assert.assertNotNull((Object)boltChannel);
        ((BoltMessageLogger)Mockito.verify((Object)this.messageLogger)).serverEvent("OPEN");
    }

    @Test
    public void shouldLogWhenClosed() {
        Channel channel = BoltChannelTest.channelMock(true);
        BoltChannel boltChannel = BoltChannel.open((String)"default", (Channel)channel, (BoltMessageLogger)this.messageLogger);
        Assert.assertNotNull((Object)boltChannel);
        boltChannel.close();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.messageLogger});
        ((BoltMessageLogger)inOrder.verify((Object)this.messageLogger)).serverEvent("OPEN");
        ((BoltMessageLogger)inOrder.verify((Object)this.messageLogger)).serverEvent("CLOSE");
    }

    @Test
    public void shouldCloseUnderlyingChannelWhenItIsOpen() {
        Channel channel = BoltChannelTest.channelMock(true);
        BoltChannel boltChannel = BoltChannel.open((String)"default", (Channel)channel, (BoltMessageLogger)this.messageLogger);
        boltChannel.close();
        ((Channel)Mockito.verify((Object)channel)).close();
    }

    @Test
    public void shouldNotCloseUnderlyingChannelWhenItIsClosed() {
        Channel channel = BoltChannelTest.channelMock(false);
        BoltChannel boltChannel = BoltChannel.open((String)"default", (Channel)channel, (BoltMessageLogger)this.messageLogger);
        boltChannel.close();
        ((Channel)Mockito.verify((Object)channel, (VerificationMode)Mockito.never())).close();
    }

    private static Channel channelMock(boolean open) {
        Channel channel = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)channel.isOpen()).thenReturn((Object)open);
        ChannelFuture channelFuture = (ChannelFuture)Mockito.mock(ChannelFuture.class);
        Mockito.when((Object)channel.close()).thenReturn((Object)channelFuture);
        return channel;
    }
}

