/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.logging;

import io.netty.channel.Channel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.util.Attribute;
import java.net.InetSocketAddress;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.neo4j.bolt.logging.BoltMessageLog;
import org.neo4j.bolt.logging.BoltMessageLoggerImpl;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.util.ValueUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class BoltMessageLoggerImplTest {
    private static final String REMOTE_ADDRESS = "127.0.0.1:60297";
    private static final String CORRELATION_ID = "Bolt-CorrelationId-1234";
    private static String errorMessage = "Oh my woes!";
    private static Neo4jError error = Neo4jError.from((Throwable)new DeadlockDetectedException(errorMessage));
    @Mock
    private Channel channel;
    @Mock
    BoltMessageLog boltMessageLog;
    @Mock
    Attribute<String> correlationIdAttribute;
    BoltMessageLoggerImpl boltMessageLogger;

    @Before
    public void setUp() {
        Mockito.when((Object)this.channel.remoteAddress()).thenReturn((Object)new InetSocketAddress("localhost", 60297));
        Mockito.when((Object)this.correlationIdAttribute.get()).thenReturn((Object)CORRELATION_ID);
        Mockito.when((Object)this.channel.attr(BoltMessageLoggerImpl.CORRELATION_ATTRIBUTE_KEY)).thenReturn(this.correlationIdAttribute);
        this.boltMessageLogger = new BoltMessageLoggerImpl(this.boltMessageLog, this.channel);
    }

    @Test
    public void clientEventWithDetails() {
        this.boltMessageLogger.clientEvent("TEST", () -> "details");
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).info(REMOTE_ADDRESS, CORRELATION_ID, "C TEST details");
    }

    @Test
    public void getRemoteAddressAsIsIncaseOfNonSocketChannel() {
        Channel channel = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)channel.attr(BoltMessageLoggerImpl.CORRELATION_ATTRIBUTE_KEY)).thenReturn(this.correlationIdAttribute);
        Mockito.when((Object)this.correlationIdAttribute.get()).thenReturn((Object)CORRELATION_ID);
        Mockito.when((Object)channel.remoteAddress()).thenReturn((Object)new DomainSocketAddress("socketPath"));
        BoltMessageLoggerImpl boltMessageLogger = new BoltMessageLoggerImpl(this.boltMessageLog, channel);
        boltMessageLogger.clientEvent("TEST", () -> "details");
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).info("socketPath", CORRELATION_ID, "C TEST details");
    }

    @Test
    public void serverEvent() {
        this.boltMessageLogger.serverEvent("TEST");
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).info(REMOTE_ADDRESS, CORRELATION_ID, "S TEST -");
    }

    @Test
    public void serverEventWithDetails() {
        this.boltMessageLogger.serverEvent("TEST", () -> "details");
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).info(REMOTE_ADDRESS, CORRELATION_ID, "S TEST details");
    }

    @Test
    public void logAckFailure() {
        this.boltMessageLogger.logAckFailure();
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).info(REMOTE_ADDRESS, CORRELATION_ID, "C ACK_FAILURE -");
    }

    @Test
    public void logInit() {
        this.boltMessageLogger.logInit("userAgent");
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).info(REMOTE_ADDRESS, CORRELATION_ID, "C INIT userAgent");
    }

    @Test
    public void logRun() {
        this.boltMessageLogger.logRun();
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).info(REMOTE_ADDRESS, CORRELATION_ID, "C RUN -");
    }

    @Test
    public void logPullAll() {
        this.boltMessageLogger.logPullAll();
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).info(REMOTE_ADDRESS, CORRELATION_ID, "C PULL_ALL -");
    }

    @Test
    public void logDiscardAll() {
        this.boltMessageLogger.logDiscardAll();
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).info(REMOTE_ADDRESS, CORRELATION_ID, "C DISCARD_ALL -");
    }

    @Test
    public void logReset() {
        this.boltMessageLogger.logReset();
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).info(REMOTE_ADDRESS, CORRELATION_ID, "C RESET -");
    }

    @Test
    public void logSuccess() {
        this.boltMessageLogger.logSuccess(() -> ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"key", "value"})));
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).info(REMOTE_ADDRESS, CORRELATION_ID, "S SUCCESS {key: \"value\"}");
    }

    @Test
    public void logIgnored() {
        this.boltMessageLogger.logIgnored();
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).info(REMOTE_ADDRESS, CORRELATION_ID, "S IGNORED -");
    }

    @Test
    public void logFailure() {
        this.boltMessageLogger.logFailure(error.status());
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).info(REMOTE_ADDRESS, CORRELATION_ID, "S FAILURE Neo.TransientError.Transaction.DeadlockDetected");
    }

    @Test
    public void logCorrelationIdClientEvent() {
        this.boltMessageLogger.clientEvent("TEST");
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).info(REMOTE_ADDRESS, CORRELATION_ID, "C TEST -");
    }

    @Test
    public void logCorrelationIdClientErrorWithDetails() {
        Mockito.when((Object)this.correlationIdAttribute.get()).thenReturn((Object)CORRELATION_ID);
        Mockito.when((Object)this.channel.hasAttr(BoltMessageLoggerImpl.CORRELATION_ATTRIBUTE_KEY)).thenReturn((Object)true);
        this.boltMessageLogger.clientError("TEST", "errorMessage", () -> "details");
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).error(REMOTE_ADDRESS, CORRELATION_ID, "C TEST details", "errorMessage");
    }

    @Test
    public void logCorrelationIdServerError() {
        this.boltMessageLogger.serverError("TEST", "errorMessage");
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).error(REMOTE_ADDRESS, CORRELATION_ID, "S TEST", "errorMessage");
    }

    @Test
    public void logServerErrorWithStatus() {
        this.boltMessageLogger.serverError("TEST", error.status());
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).error(REMOTE_ADDRESS, CORRELATION_ID, "S TEST", "Neo.TransientError.Transaction.DeadlockDetected");
    }

    @Test
    public void logCorrelationIdClientEventWithDetails() {
        Mockito.when((Object)this.correlationIdAttribute.get()).thenReturn((Object)CORRELATION_ID);
        Mockito.when((Object)this.channel.hasAttr(BoltMessageLoggerImpl.CORRELATION_ATTRIBUTE_KEY)).thenReturn((Object)true);
        Mockito.when((Object)this.channel.attr(BoltMessageLoggerImpl.CORRELATION_ATTRIBUTE_KEY)).thenReturn(this.correlationIdAttribute);
        this.boltMessageLogger.clientEvent("TEST", () -> "details");
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).info(REMOTE_ADDRESS, CORRELATION_ID, "C TEST details");
    }

    @Test
    public void createCorrelationIdIfNotAvailableInInfoLogger() {
        Mockito.when((Object)this.channel.hasAttr(BoltMessageLoggerImpl.CORRELATION_ATTRIBUTE_KEY)).thenReturn((Object)false);
        BoltMessageLoggerImpl boltMessageLogger = new BoltMessageLoggerImpl(this.boltMessageLog, this.channel);
        boltMessageLogger.clientEvent("TEST");
        ((Attribute)Mockito.verify(this.correlationIdAttribute)).set((Object)ArgumentMatchers.anyString());
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).info(REMOTE_ADDRESS, CORRELATION_ID, "C TEST -");
    }

    @Test
    public void createCorrelationIdIfNotAvailableInErrorLogger() {
        Mockito.when((Object)this.channel.hasAttr(BoltMessageLoggerImpl.CORRELATION_ATTRIBUTE_KEY)).thenReturn((Object)false);
        BoltMessageLoggerImpl boltMessageLogger = new BoltMessageLoggerImpl(this.boltMessageLog, this.channel);
        boltMessageLogger.serverError("TEST", "errorMessage");
        ((Attribute)Mockito.verify(this.correlationIdAttribute)).set((Object)ArgumentMatchers.anyString());
        ((BoltMessageLog)Mockito.verify((Object)this.boltMessageLog)).error(REMOTE_ADDRESS, CORRELATION_ID, "S TEST", "errorMessage");
    }
}

