/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.logging;

import io.netty.channel.Channel;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.bolt.logging.BoltMessageLoggerImpl;
import org.neo4j.bolt.logging.BoltMessageLogging;
import org.neo4j.bolt.logging.NullBoltMessageLogger;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.JobScheduler;

@RunWith(value=MockitoJUnitRunner.class)
public class BoltMessageLoggingTest {
    @Mock(answer=Answers.RETURNS_MOCKS)
    private FileSystemAbstraction fs;
    @Mock(answer=Answers.RETURNS_MOCKS)
    private JobScheduler jobScheduler;
    @Mock(answer=Answers.RETURNS_MOCKS)
    private Log log;
    @Mock(answer=Answers.RETURNS_MOCKS)
    private Channel channel;
    private static InetSocketAddress inetSocketAddress = new InetSocketAddress("127.0.0.1", 7476);

    @Test
    public void shouldCreateNullLoggerWhenDisabled() {
        Config config = BoltMessageLoggingTest.newConfig(false);
        BoltMessageLogging logging = BoltMessageLogging.create((FileSystemAbstraction)this.fs, (JobScheduler)this.jobScheduler, (Config)config, (Log)this.log);
        BoltMessageLogger logger = logging.newLogger(this.channel);
        Assert.assertThat((Object)logger, (Matcher)Matchers.instanceOf(NullBoltMessageLogger.class));
    }

    @Test
    public void shouldCreateNullLoggerWhenUnableToCreateRealLogger() throws IOException {
        Config config = BoltMessageLoggingTest.newConfig(true);
        IOException fsError = new IOException();
        Mockito.when((Object)this.fs.openAsOutputStream((File)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{fsError});
        BoltMessageLogging logging = BoltMessageLogging.create((FileSystemAbstraction)this.fs, (JobScheduler)this.jobScheduler, (Config)config, (Log)this.log);
        BoltMessageLogger logger = logging.newLogger(this.channel);
        Assert.assertThat((Object)logger, (Matcher)Matchers.instanceOf(NullBoltMessageLogger.class));
        ((Log)Mockito.verify((Object)this.log)).warn(ArgumentMatchers.startsWith((String)"Unable to create bolt message log"), (Throwable)ArgumentMatchers.eq((Object)fsError));
    }

    @Test
    public void shouldCreateRealLoggerWhenEnabled() {
        Config config = BoltMessageLoggingTest.newConfig(true);
        Mockito.when((Object)this.channel.remoteAddress()).thenReturn((Object)inetSocketAddress);
        BoltMessageLogging logging = BoltMessageLogging.create((FileSystemAbstraction)this.fs, (JobScheduler)this.jobScheduler, (Config)config, (Log)this.log);
        BoltMessageLogger logger = logging.newLogger(this.channel);
        Assert.assertThat((Object)logger, (Matcher)Matchers.instanceOf(BoltMessageLoggerImpl.class));
    }

    @Test
    public void shouldCreateNullLoggerWhenNone() {
        BoltMessageLogging logging = BoltMessageLogging.none();
        BoltMessageLogger logger = logging.newLogger(this.channel);
        Assert.assertThat((Object)logger, (Matcher)Matchers.instanceOf(NullBoltMessageLogger.class));
    }

    private static Config newConfig(boolean boltLogEnabled) {
        return Config.defaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.bolt_logging_enabled.name(), Boolean.toString(boltLogEnabled)}));
    }
}

