/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import java.util.ArrayList;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionQueueMonitor;
import org.neo4j.bolt.runtime.BoltConnectionQueueMonitorAggregate;
import org.neo4j.bolt.v1.runtime.Job;

public class BoltConnectionQueueMonitorAggregateTest {
    private BoltConnection connection = (BoltConnection)Mockito.mock(BoltConnection.class);

    @Test
    public void shouldCallEnqueuedOnSingleMonitor() {
        Job job = (Job)Mockito.mock(Job.class);
        BoltConnectionQueueMonitor monitor = (BoltConnectionQueueMonitor)Mockito.mock(BoltConnectionQueueMonitor.class);
        BoltConnectionQueueMonitorAggregate monitorAggregate = new BoltConnectionQueueMonitorAggregate(new BoltConnectionQueueMonitor[]{monitor});
        monitorAggregate.enqueued(this.connection, job);
        ((BoltConnectionQueueMonitor)Mockito.verify((Object)monitor)).enqueued(this.connection, job);
    }

    @Test
    public void shouldCallDrainedOnSingleMonitor() {
        ArrayList batch = new ArrayList();
        BoltConnectionQueueMonitor monitor = (BoltConnectionQueueMonitor)Mockito.mock(BoltConnectionQueueMonitor.class);
        BoltConnectionQueueMonitorAggregate monitorAggregate = new BoltConnectionQueueMonitorAggregate(new BoltConnectionQueueMonitor[]{monitor});
        monitorAggregate.drained(this.connection, batch);
        ((BoltConnectionQueueMonitor)Mockito.verify((Object)monitor)).drained(this.connection, batch);
    }

    @Test
    public void shouldCallEnqueuedOnEachMonitor() {
        Job job = (Job)Mockito.mock(Job.class);
        BoltConnectionQueueMonitor monitor1 = (BoltConnectionQueueMonitor)Mockito.mock(BoltConnectionQueueMonitor.class);
        BoltConnectionQueueMonitor monitor2 = (BoltConnectionQueueMonitor)Mockito.mock(BoltConnectionQueueMonitor.class);
        BoltConnectionQueueMonitorAggregate monitorAggregate = new BoltConnectionQueueMonitorAggregate(new BoltConnectionQueueMonitor[]{monitor1, monitor2});
        monitorAggregate.enqueued(this.connection, job);
        ((BoltConnectionQueueMonitor)Mockito.verify((Object)monitor1)).enqueued(this.connection, job);
        ((BoltConnectionQueueMonitor)Mockito.verify((Object)monitor2)).enqueued(this.connection, job);
    }

    @Test
    public void shouldCallDrainedOnEachMonitor() {
        ArrayList batch = new ArrayList();
        BoltConnectionQueueMonitor monitor1 = (BoltConnectionQueueMonitor)Mockito.mock(BoltConnectionQueueMonitor.class);
        BoltConnectionQueueMonitor monitor2 = (BoltConnectionQueueMonitor)Mockito.mock(BoltConnectionQueueMonitor.class);
        BoltConnectionQueueMonitorAggregate monitorAggregate = new BoltConnectionQueueMonitorAggregate(new BoltConnectionQueueMonitor[]{monitor1, monitor2});
        monitorAggregate.drained(this.connection, batch);
        ((BoltConnectionQueueMonitor)Mockito.verify((Object)monitor1)).drained(this.connection, batch);
        ((BoltConnectionQueueMonitor)Mockito.verify((Object)monitor2)).drained(this.connection, batch);
    }
}

