/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import io.netty.channel.embedded.EmbeddedChannel;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionReadLimiter;
import org.neo4j.bolt.v1.runtime.Job;
import org.neo4j.logging.Log;

public class BoltConnectionReadLimiterTest {
    private static final Job job = s -> s.run("INIT", null, null);
    private BoltConnection connection;
    private EmbeddedChannel channel;
    private Log log;

    @Before
    public void setup() {
        this.channel = new EmbeddedChannel();
        this.log = (Log)Mockito.mock(Log.class);
        this.connection = (BoltConnection)Mockito.mock(BoltConnection.class);
        Mockito.when((Object)this.connection.id()).thenReturn((Object)this.channel.id().asLongText());
        Mockito.when((Object)this.connection.channel()).thenReturn((Object)this.channel);
    }

    @After
    public void cleanup() {
        this.channel.finishAndReleaseAll();
    }

    @Test
    public void shouldNotDisableAutoReadBelowHighWatermark() {
        BoltConnectionReadLimiter limiter = this.newLimiter(1, 2);
        Assert.assertTrue((boolean)this.channel.config().isAutoRead());
        limiter.enqueued(this.connection, job);
        Assert.assertTrue((boolean)this.channel.config().isAutoRead());
        ((Log)Mockito.verify((Object)this.log, (VerificationMode)Mockito.never())).warn(Matchers.anyString(), new Object[]{Matchers.any(), Matchers.any()});
    }

    @Test
    public void shouldDisableAutoReadWhenAtHighWatermark() {
        BoltConnectionReadLimiter limiter = this.newLimiter(1, 2);
        Assert.assertTrue((boolean)this.channel.config().isAutoRead());
        limiter.enqueued(this.connection, job);
        limiter.enqueued(this.connection, job);
        limiter.enqueued(this.connection, job);
        Assert.assertFalse((boolean)this.channel.config().isAutoRead());
        ((Log)Mockito.verify((Object)this.log)).warn(Matchers.contains((String)"disabled"), new Object[]{Matchers.eq((Object)this.channel.remoteAddress()), Matchers.eq((int)3)});
    }

    @Test
    public void shouldDisableAutoReadOnlyOnceWhenAboveHighWatermark() {
        BoltConnectionReadLimiter limiter = this.newLimiter(1, 2);
        Assert.assertTrue((boolean)this.channel.config().isAutoRead());
        limiter.enqueued(this.connection, job);
        limiter.enqueued(this.connection, job);
        limiter.enqueued(this.connection, job);
        limiter.enqueued(this.connection, job);
        limiter.enqueued(this.connection, job);
        Assert.assertFalse((boolean)this.channel.config().isAutoRead());
        ((Log)Mockito.verify((Object)this.log, (VerificationMode)Mockito.times((int)1))).warn(Matchers.contains((String)"disabled"), new Object[]{Matchers.eq((Object)this.channel.remoteAddress()), Matchers.eq((int)3)});
    }

    @Test
    public void shouldEnableAutoReadWhenAtLowWatermark() {
        BoltConnectionReadLimiter limiter = this.newLimiter(1, 2);
        Assert.assertTrue((boolean)this.channel.config().isAutoRead());
        limiter.enqueued(this.connection, job);
        limiter.enqueued(this.connection, job);
        limiter.enqueued(this.connection, job);
        limiter.drained(this.connection, Arrays.asList(job, job));
        Assert.assertTrue((boolean)this.channel.config().isAutoRead());
        ((Log)Mockito.verify((Object)this.log, (VerificationMode)Mockito.times((int)1))).warn(Matchers.contains((String)"disabled"), new Object[]{Matchers.eq((Object)this.channel.remoteAddress()), Matchers.eq((int)3)});
        ((Log)Mockito.verify((Object)this.log, (VerificationMode)Mockito.times((int)1))).warn(Matchers.contains((String)"enabled"), new Object[]{Matchers.eq((Object)this.channel.remoteAddress()), Matchers.eq((int)1)});
    }

    @Test
    public void shouldEnableAutoReadOnlyOnceWhenBelowLowWatermark() {
        BoltConnectionReadLimiter limiter = this.newLimiter(1, 2);
        Assert.assertTrue((boolean)this.channel.config().isAutoRead());
        limiter.enqueued(this.connection, job);
        limiter.enqueued(this.connection, job);
        limiter.enqueued(this.connection, job);
        limiter.drained(this.connection, Arrays.asList(job, job, job));
        Assert.assertTrue((boolean)this.channel.config().isAutoRead());
        ((Log)Mockito.verify((Object)this.log, (VerificationMode)Mockito.times((int)1))).warn(Matchers.contains((String)"disabled"), new Object[]{Matchers.eq((Object)this.channel.remoteAddress()), Matchers.eq((int)3)});
        ((Log)Mockito.verify((Object)this.log, (VerificationMode)Mockito.times((int)1))).warn(Matchers.contains((String)"enabled"), new Object[]{Matchers.eq((Object)this.channel.remoteAddress()), Matchers.eq((int)1)});
    }

    @Test
    public void shouldNotAcceptNegativeLowWatermark() {
        try {
            this.newLimiter(-1, 5);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException exc) {
            Assert.assertThat((Object)exc.getMessage(), (Matcher)CoreMatchers.startsWith((String)"invalid lowWatermark value"));
        }
    }

    @Test
    public void shouldNotAcceptLowWatermarkEqualToHighWatermark() {
        try {
            this.newLimiter(5, 5);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException exc) {
            Assert.assertThat((Object)exc.getMessage(), (Matcher)CoreMatchers.startsWith((String)"invalid lowWatermark value"));
        }
    }

    @Test
    public void shouldNotAcceptLowWatermarkLargerThanHighWatermark() {
        try {
            this.newLimiter(6, 5);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException exc) {
            Assert.assertThat((Object)exc.getMessage(), (Matcher)CoreMatchers.startsWith((String)"invalid lowWatermark value"));
        }
    }

    @Test
    public void shouldNotAcceptZeroHighWatermark() {
        try {
            this.newLimiter(1, 0);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException exc) {
            Assert.assertThat((Object)exc.getMessage(), (Matcher)CoreMatchers.startsWith((String)"invalid highWatermark value"));
        }
    }

    @Test
    public void shouldNotAcceptNegativeHighWatermark() {
        try {
            this.newLimiter(1, -1);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException exc) {
            Assert.assertThat((Object)exc.getMessage(), (Matcher)CoreMatchers.startsWith((String)"invalid highWatermark value"));
        }
    }

    private BoltConnectionReadLimiter newLimiter(int low, int high) {
        return new BoltConnectionReadLimiter(this.log, low, high);
    }
}

