/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.BoltKernelExtension;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.bolt.logging.BoltMessageLogging;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionLifetimeListener;
import org.neo4j.bolt.runtime.BoltConnectionQueueMonitor;
import org.neo4j.bolt.runtime.DefaultBoltConnection;
import org.neo4j.bolt.testing.Jobs;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.runtime.BoltConnectionAuthFatality;
import org.neo4j.bolt.v1.runtime.BoltConnectionFatality;
import org.neo4j.bolt.v1.runtime.BoltProtocolBreachFatality;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.Job;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.rule.concurrent.OtherThreadRule;

public class DefaultBoltConnectionTest {
    private final String connector = "default";
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private final LogService logService = new SimpleLogService((LogProvider)this.logProvider);
    private final BoltConnectionLifetimeListener connectionListener = (BoltConnectionLifetimeListener)Mockito.mock(BoltConnectionLifetimeListener.class);
    private final BoltConnectionQueueMonitor queueMonitor = (BoltConnectionQueueMonitor)Mockito.mock(BoltConnectionQueueMonitor.class);
    private final EmbeddedChannel channel = new EmbeddedChannel();
    private final BoltMessageLogger messageLogger = BoltMessageLogging.none().newLogger((Channel)this.channel);
    private BoltChannel boltChannel;
    private BoltStateMachine stateMachine;
    @Rule
    public OtherThreadRule<Boolean> otherThread = new OtherThreadRule();

    @Before
    public void setup() {
        this.boltChannel = BoltChannel.open((String)"default", (Channel)this.channel, (BoltMessageLogger)this.messageLogger);
        this.stateMachine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        Mockito.when((Object)this.stateMachine.owner()).thenReturn((Object)"neo4j");
        Mockito.when((Object)this.stateMachine.shouldStickOnThread()).thenReturn((Object)false);
        Mockito.when((Object)this.stateMachine.hasOpenStatement()).thenReturn((Object)false);
    }

    @After
    public void cleanup() {
        this.channel.finishAndReleaseAll();
    }

    @Test
    public void idShouldReturnBoltChannelId() {
        DefaultBoltConnection connection = this.newConnection();
        Assert.assertEquals((Object)this.boltChannel.id(), (Object)connection.id());
    }

    @Test
    public void localAddressShouldReturnBoltServerAddress() {
        DefaultBoltConnection connection = this.newConnection();
        Assert.assertEquals((Object)this.boltChannel.serverAddress(), (Object)connection.localAddress());
    }

    @Test
    public void remoteAddressShouldReturnBoltClientAddress() {
        DefaultBoltConnection connection = this.newConnection();
        Assert.assertEquals((Object)this.boltChannel.clientAddress(), (Object)connection.remoteAddress());
    }

    @Test
    public void channelShouldReturnBoltRawChannel() {
        DefaultBoltConnection connection = this.newConnection();
        Assert.assertEquals((Object)this.boltChannel.rawChannel(), (Object)connection.channel());
    }

    @Test
    public void hasPendingJobsShouldReportFalseWhenInitialised() {
        DefaultBoltConnection connection = this.newConnection();
        Assert.assertFalse((boolean)connection.hasPendingJobs());
    }

    @Test
    public void startShouldNotifyListener() {
        DefaultBoltConnection connection = this.newConnection();
        connection.start();
        ((BoltConnectionLifetimeListener)Mockito.verify((Object)this.connectionListener)).created((BoltConnection)connection);
    }

    @Test
    public void stopShouldNotifyListenerOnTheNextBatch() {
        DefaultBoltConnection connection = this.newConnection();
        connection.start();
        connection.stop();
        connection.processNextBatch();
        ((BoltConnectionLifetimeListener)Mockito.verify((Object)this.connectionListener)).closed((BoltConnection)connection);
    }

    @Test
    public void enqueuedShouldNotifyQueueMonitor() {
        Job job = Jobs.noop();
        DefaultBoltConnection connection = this.newConnection();
        connection.enqueue(job);
        ((BoltConnectionQueueMonitor)Mockito.verify((Object)this.queueMonitor)).enqueued((BoltConnection)connection, job);
    }

    @Test
    public void enqueuedShouldQueueJob() {
        Job job = Jobs.noop();
        DefaultBoltConnection connection = this.newConnection();
        connection.enqueue(job);
        Assert.assertTrue((boolean)connection.hasPendingJobs());
    }

    @Test
    public void processNextBatchShouldDoNothingIfQueueIsEmptyAndConnectionNotClosed() {
        DefaultBoltConnection connection = this.newConnection();
        connection.processNextBatch();
        ((BoltConnectionQueueMonitor)Mockito.verify((Object)this.queueMonitor, (VerificationMode)Mockito.never())).drained((BoltConnection)ArgumentMatchers.same((Object)connection), ArgumentMatchers.anyCollection());
    }

    @Test
    public void processNextBatchShouldNotifyQueueMonitorAboutDrain() {
        ArrayList drainedJobs = new ArrayList();
        Job job = Jobs.noop();
        DefaultBoltConnection connection = this.newConnection();
        ((BoltConnectionQueueMonitor)Mockito.doAnswer(inv -> drainedJobs.addAll((Collection)inv.getArgument(1))).when((Object)this.queueMonitor)).drained((BoltConnection)ArgumentMatchers.same((Object)connection), ArgumentMatchers.anyCollection());
        connection.enqueue(job);
        connection.processNextBatch();
        ((BoltConnectionQueueMonitor)Mockito.verify((Object)this.queueMonitor)).drained((BoltConnection)ArgumentMatchers.same((Object)connection), ArgumentMatchers.anyCollection());
        Assert.assertTrue((boolean)drainedJobs.contains(job));
    }

    @Test
    public void processNextBatchShouldDrainMaxBatchSizeItemsOnEachCall() {
        ArrayList drainedJobs = new ArrayList();
        ArrayList<Job> pushedJobs = new ArrayList<Job>();
        DefaultBoltConnection connection = this.newConnection(10);
        ((BoltConnectionQueueMonitor)Mockito.doAnswer(inv -> drainedJobs.addAll((Collection)inv.getArgument(1))).when((Object)this.queueMonitor)).drained((BoltConnection)ArgumentMatchers.same((Object)connection), ArgumentMatchers.anyCollection());
        for (int i = 0; i < 15; ++i) {
            Job newJob = Jobs.noop();
            pushedJobs.add(newJob);
            connection.enqueue(newJob);
        }
        connection.processNextBatch();
        ((BoltConnectionQueueMonitor)Mockito.verify((Object)this.queueMonitor)).drained((BoltConnection)ArgumentMatchers.same((Object)connection), ArgumentMatchers.anyCollection());
        Assert.assertEquals((long)10L, (long)drainedJobs.size());
        Assert.assertTrue((boolean)drainedJobs.containsAll(pushedJobs.subList(0, 10)));
        drainedJobs.clear();
        connection.processNextBatch();
        ((BoltConnectionQueueMonitor)Mockito.verify((Object)this.queueMonitor, (VerificationMode)Mockito.times((int)2))).drained((BoltConnection)ArgumentMatchers.same((Object)connection), ArgumentMatchers.anyCollection());
        Assert.assertEquals((long)5L, (long)drainedJobs.size());
        Assert.assertTrue((boolean)drainedJobs.containsAll(pushedJobs.subList(10, 15)));
    }

    @Test
    public void interruptShouldInterruptStateMachine() {
        DefaultBoltConnection connection = this.newConnection();
        connection.interrupt();
        ((BoltStateMachine)Mockito.verify((Object)this.stateMachine)).interrupt();
    }

    @Test
    public void stopShouldFirstTerminateStateMachine() {
        DefaultBoltConnection connection = this.newConnection();
        connection.stop();
        ((BoltStateMachine)Mockito.verify((Object)this.stateMachine)).terminate();
    }

    @Test
    public void stopShouldCloseStateMachine() {
        DefaultBoltConnection connection = this.newConnection();
        connection.stop();
        connection.processNextBatch();
        ((BoltStateMachine)Mockito.verify((Object)this.stateMachine)).terminate();
        ((BoltStateMachine)Mockito.verify((Object)this.stateMachine)).close();
    }

    @Test
    public void processNextBatchShouldCloseConnectionOnFatalAuthenticationError() {
        DefaultBoltConnection connection = this.newConnection();
        connection.enqueue(machine -> {
            throw new BoltConnectionAuthFatality("auth failure");
        });
        connection.processNextBatch();
        ((BoltStateMachine)Mockito.verify((Object)this.stateMachine)).close();
        this.logProvider.assertNone(AssertableLogProvider.inLog((Matcher)Matchers.containsString((String)BoltKernelExtension.class.getPackage().getName())).error(Matchers.any(String.class), Matchers.any(Throwable.class)));
    }

    @Test
    public void processNextBatchShouldCloseConnectionAndLogOnFatalBoltError() {
        BoltProtocolBreachFatality exception = new BoltProtocolBreachFatality("fatal bolt error");
        DefaultBoltConnection connection = this.newConnection();
        connection.enqueue(arg_0 -> DefaultBoltConnectionTest.lambda$processNextBatchShouldCloseConnectionAndLogOnFatalBoltError$3((BoltConnectionFatality)exception, arg_0));
        connection.processNextBatch();
        ((BoltStateMachine)Mockito.verify((Object)this.stateMachine)).close();
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog((Matcher)Matchers.containsString((String)BoltKernelExtension.class.getPackage().getName())).error(Matchers.containsString((String)"Protocol breach detected in bolt session"), Matchers.is((Object)exception))});
    }

    @Test
    public void processNextBatchShouldCloseConnectionAndLogOnUnexpectedException() {
        RuntimeException exception = new RuntimeException("unexpected exception");
        DefaultBoltConnection connection = this.newConnection();
        connection.enqueue(machine -> {
            throw exception;
        });
        connection.processNextBatch();
        ((BoltStateMachine)Mockito.verify((Object)this.stateMachine)).close();
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog((Matcher)Matchers.containsString((String)BoltKernelExtension.class.getPackage().getName())).error(Matchers.containsString((String)"Unexpected error detected in bolt session"), Matchers.is((Object)exception))});
    }

    @Test
    public void processNextBatchShouldThrowAssertionErrorIfStatementOpen() throws Exception {
        DefaultBoltConnection connection = this.newConnection(1);
        connection.enqueue(Jobs.noop());
        connection.enqueue(Jobs.noop());
        Mockito.when((Object)this.stateMachine.hasOpenStatement()).thenReturn((Object)true);
        connection.processNextBatch();
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog((String)DefaultBoltConnection.class.getName()).error(Matchers.startsWith((String)"Unexpected error"), Matchers.isA(AssertionError.class))});
    }

    @Test
    public void processNextBatchShouldNotThrowAssertionErrorIfStatementOpenButStopping() throws Exception {
        DefaultBoltConnection connection = this.newConnection(1);
        connection.enqueue(Jobs.noop());
        connection.enqueue(Jobs.noop());
        Mockito.when((Object)this.stateMachine.hasOpenStatement()).thenReturn((Object)true);
        connection.stop();
        connection.processNextBatch();
        this.logProvider.assertNone(AssertableLogProvider.inLog((String)DefaultBoltConnection.class.getName()).error(Matchers.startsWith((String)"Unexpected error"), Matchers.isA(AssertionError.class)));
    }

    @Test
    public void processNextBatchShouldReturnWhenConnectionIsStopped() throws Exception {
        DefaultBoltConnection connection = this.newConnection(1);
        connection.enqueue(Jobs.noop());
        connection.enqueue(Jobs.noop());
        Mockito.when((Object)this.stateMachine.shouldStickOnThread()).thenReturn((Object)true);
        Future future = this.otherThread.execute(arg_0 -> DefaultBoltConnectionTest.lambda$processNextBatchShouldReturnWhenConnectionIsStopped$5((BoltConnection)connection, arg_0));
        connection.stop();
        this.otherThread.get().awaitFuture(future);
        ((BoltStateMachine)Mockito.verify((Object)this.stateMachine)).close();
    }

    private DefaultBoltConnection newConnection() {
        return this.newConnection(10);
    }

    private DefaultBoltConnection newConnection(int maxBatchSize) {
        return new DefaultBoltConnection(this.boltChannel, (PackOutput)Mockito.mock(PackOutput.class), this.stateMachine, this.logService, this.connectionListener, this.queueMonitor, maxBatchSize);
    }

    private static /* synthetic */ Boolean lambda$processNextBatchShouldReturnWhenConnectionIsStopped$5(BoltConnection connection, Boolean state) throws Exception {
        return connection.processNextBatch();
    }

    private static /* synthetic */ void lambda$processNextBatchShouldCloseConnectionAndLogOnFatalBoltError$3(BoltConnectionFatality exception, BoltStateMachine machine) throws BoltConnectionFatality {
        throw exception;
    }
}

