/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import java.util.UUID;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionLifetimeListener;
import org.neo4j.bolt.runtime.BoltConnectionMetricsMonitor;
import org.neo4j.bolt.runtime.BoltConnectionQueueMonitor;
import org.neo4j.bolt.runtime.MetricsReportingBoltConnection;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.runtime.BoltConnectionAuthFatality;
import org.neo4j.bolt.v1.runtime.BoltProtocolBreachFatality;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.Job;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.time.Clocks;

public class MetricsReportingBoltConnectionTest {
    @Test
    public void shouldNotifyConnectionOpened() {
        BoltConnectionMetricsMonitor metricsMonitor = (BoltConnectionMetricsMonitor)Mockito.mock(BoltConnectionMetricsMonitor.class);
        BoltConnection connection = MetricsReportingBoltConnectionTest.newConnection(metricsMonitor);
        connection.start();
        ((BoltConnectionMetricsMonitor)Mockito.verify((Object)metricsMonitor)).connectionOpened();
    }

    @Test
    public void shouldNotifyConnectionClosed() {
        BoltConnectionMetricsMonitor metricsMonitor = (BoltConnectionMetricsMonitor)Mockito.mock(BoltConnectionMetricsMonitor.class);
        BoltConnection connection = MetricsReportingBoltConnectionTest.newConnection(metricsMonitor);
        connection.start();
        connection.stop();
        connection.processNextBatch();
        ((BoltConnectionMetricsMonitor)Mockito.verify((Object)metricsMonitor)).connectionClosed();
    }

    @Test
    public void shouldNotifyConnectionClosedOnBoltConnectionAuthFatality() {
        MetricsReportingBoltConnectionTest.verifyConnectionClosed(machine -> {
            throw new BoltConnectionAuthFatality("auth failure");
        });
    }

    @Test
    public void shouldNotifyConnectionClosedOnBoltProtocolBreachFatality() {
        MetricsReportingBoltConnectionTest.verifyConnectionClosed(machine -> {
            throw new BoltProtocolBreachFatality("protocol failure");
        });
    }

    @Test
    public void shouldNotifyConnectionClosedOnUncheckedException() {
        MetricsReportingBoltConnectionTest.verifyConnectionClosed(machine -> {
            throw new RuntimeException("unexpected error");
        });
    }

    @Test
    public void shouldNotifyMessageReceived() {
        BoltConnectionMetricsMonitor metricsMonitor = (BoltConnectionMetricsMonitor)Mockito.mock(BoltConnectionMetricsMonitor.class);
        BoltConnection connection = MetricsReportingBoltConnectionTest.newConnection(metricsMonitor);
        connection.start();
        connection.enqueue(machine -> {});
        ((BoltConnectionMetricsMonitor)Mockito.verify((Object)metricsMonitor)).messageReceived();
    }

    @Test
    public void shouldNotifyMessageProcessingStartedAndCompleted() {
        BoltConnectionMetricsMonitor metricsMonitor = (BoltConnectionMetricsMonitor)Mockito.mock(BoltConnectionMetricsMonitor.class);
        BoltConnection connection = MetricsReportingBoltConnectionTest.newConnection(metricsMonitor);
        connection.start();
        connection.enqueue(machine -> {});
        connection.processNextBatch();
        ((BoltConnectionMetricsMonitor)Mockito.verify((Object)metricsMonitor)).messageProcessingStarted(ArgumentMatchers.anyLong());
        ((BoltConnectionMetricsMonitor)Mockito.verify((Object)metricsMonitor)).messageProcessingCompleted(ArgumentMatchers.anyLong());
    }

    @Test
    public void shouldNotifyConnectionActivatedAndDeactivated() {
        BoltConnectionMetricsMonitor metricsMonitor = (BoltConnectionMetricsMonitor)Mockito.mock(BoltConnectionMetricsMonitor.class);
        BoltConnection connection = MetricsReportingBoltConnectionTest.newConnection(metricsMonitor);
        connection.start();
        connection.enqueue(machine -> {});
        connection.processNextBatch();
        ((BoltConnectionMetricsMonitor)Mockito.verify((Object)metricsMonitor)).connectionActivated();
        ((BoltConnectionMetricsMonitor)Mockito.verify((Object)metricsMonitor)).connectionWaiting();
    }

    @Test
    public void shouldNotifyMessageProcessingFailed() {
        BoltConnectionMetricsMonitor metricsMonitor = (BoltConnectionMetricsMonitor)Mockito.mock(BoltConnectionMetricsMonitor.class);
        BoltConnection connection = MetricsReportingBoltConnectionTest.newConnection(metricsMonitor);
        connection.start();
        connection.enqueue(machine -> {
            throw new BoltConnectionAuthFatality("some error");
        });
        connection.processNextBatch();
        ((BoltConnectionMetricsMonitor)Mockito.verify((Object)metricsMonitor)).messageProcessingFailed();
    }

    private static void verifyConnectionClosed(Job throwingJob) {
        BoltConnectionMetricsMonitor metricsMonitor = (BoltConnectionMetricsMonitor)Mockito.mock(BoltConnectionMetricsMonitor.class);
        BoltConnection connection = MetricsReportingBoltConnectionTest.newConnection(metricsMonitor);
        connection.start();
        connection.enqueue(throwingJob);
        connection.processNextBatch();
        ((BoltConnectionMetricsMonitor)Mockito.verify((Object)metricsMonitor)).connectionClosed();
    }

    private static BoltConnection newConnection(BoltConnectionMetricsMonitor metricsMonitor) {
        BoltChannel channel = (BoltChannel)Mockito.mock(BoltChannel.class);
        Mockito.when((Object)channel.id()).thenReturn((Object)UUID.randomUUID().toString());
        return new MetricsReportingBoltConnection(channel, (PackOutput)Mockito.mock(PackOutput.class), (BoltStateMachine)Mockito.mock(BoltStateMachine.class), (LogService)NullLogService.getInstance(), (BoltConnectionLifetimeListener)Mockito.mock(BoltConnectionLifetimeListener.class), (BoltConnectionQueueMonitor)Mockito.mock(BoltConnectionQueueMonitor.class), metricsMonitor, Clocks.systemClock());
    }
}

