/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import java.net.SocketAddress;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.runtime.BoltConnectionFatality;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.Job;
import org.neo4j.bolt.v1.transport.ChunkedOutput;

public class SynchronousBoltConnection
implements BoltConnection {
    private final EmbeddedChannel channel = new EmbeddedChannel();
    private final PackOutput output = new ChunkedOutput((Channel)this.channel, TransportThrottleGroup.NO_THROTTLE);
    private final BoltStateMachine machine;

    public SynchronousBoltConnection(BoltStateMachine machine) {
        this.machine = machine;
    }

    public String id() {
        return this.channel.id().asLongText();
    }

    public SocketAddress localAddress() {
        return this.channel.localAddress();
    }

    public SocketAddress remoteAddress() {
        return this.channel.remoteAddress();
    }

    public Channel channel() {
        return this.channel;
    }

    public PackOutput output() {
        return this.output;
    }

    public boolean hasPendingJobs() {
        return false;
    }

    public void start() {
    }

    public void enqueue(Job job) {
        try {
            job.perform(this.machine);
        }
        catch (BoltConnectionFatality connectionFatality) {
            throw new RuntimeException(connectionFatality);
        }
    }

    public boolean processNextBatch() {
        return true;
    }

    public void handleSchedulingError(Throwable t) {
    }

    public void interrupt() {
        this.machine.interrupt();
    }

    public void stop() {
        this.channel.finishAndReleaseAll();
        this.machine.close();
    }
}

