/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.testing;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.RecordedBoltResponse;
import org.neo4j.bolt.v1.messaging.BoltResponseMessage;
import org.neo4j.bolt.v1.runtime.BoltConnectionFatality;
import org.neo4j.bolt.v1.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.MachineRoom;
import org.neo4j.bolt.v1.runtime.StatementProcessor;
import org.neo4j.cypher.result.QueryResult;
import org.neo4j.function.ThrowingAction;
import org.neo4j.function.ThrowingBiConsumer;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

public class BoltMatchers {
    private BoltMatchers() {
    }

    public static Matcher<RecordedBoltResponse> succeeded() {
        return new BaseMatcher<RecordedBoltResponse>(){

            public boolean matches(Object item) {
                RecordedBoltResponse response = (RecordedBoltResponse)item;
                return response.message() == BoltResponseMessage.SUCCESS;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)BoltResponseMessage.SUCCESS);
            }
        };
    }

    public static Matcher<RecordedBoltResponse> succeededWithMetadata(final String key, final AnyValue value) {
        return new BaseMatcher<RecordedBoltResponse>(){

            public boolean matches(Object item) {
                RecordedBoltResponse response = (RecordedBoltResponse)item;
                return response.message() == BoltResponseMessage.SUCCESS && response.hasMetadata(key) && response.metadata(key).equals(value);
            }

            public void describeTo(Description description) {
                description.appendValue((Object)BoltResponseMessage.SUCCESS).appendText(String.format(" with metadata %s = %s", key, value.toString()));
            }
        };
    }

    public static Matcher<RecordedBoltResponse> containsRecord(final Object ... values) {
        return new BaseMatcher<RecordedBoltResponse>(){
            private AnyValue[] anyValues;
            {
                this.anyValues = (AnyValue[])Arrays.stream(values).map(ValueUtils::of).toArray(AnyValue[]::new);
            }

            public boolean matches(Object item) {
                RecordedBoltResponse response = (RecordedBoltResponse)item;
                QueryResult.Record[] records = response.records();
                return records.length > 0 && Arrays.equals(records[0].fields(), this.anyValues);
            }

            public void describeTo(Description description) {
                description.appendText(String.format("with record %s", values));
            }
        };
    }

    public static Matcher<RecordedBoltResponse> succeededWithRecord(final Object ... values) {
        return new BaseMatcher<RecordedBoltResponse>(){
            private AnyValue[] anyValues;
            {
                this.anyValues = (AnyValue[])Arrays.stream(values).map(ValueUtils::of).toArray(AnyValue[]::new);
            }

            public boolean matches(Object item) {
                RecordedBoltResponse response = (RecordedBoltResponse)item;
                QueryResult.Record[] records = response.records();
                return response.message() == BoltResponseMessage.SUCCESS && Arrays.equals(records[0].fields(), this.anyValues);
            }

            public void describeTo(Description description) {
                description.appendValue((Object)BoltResponseMessage.SUCCESS).appendText(String.format(" with record %s", values));
            }
        };
    }

    public static Matcher<RecordedBoltResponse> succeededWithMetadata(final String key, final Pattern pattern) {
        return new BaseMatcher<RecordedBoltResponse>(){

            public boolean matches(Object item) {
                RecordedBoltResponse response = (RecordedBoltResponse)item;
                return response.message() == BoltResponseMessage.SUCCESS && response.hasMetadata(key) && pattern.matcher(((TextValue)response.metadata(key)).stringValue()).matches();
            }

            public void describeTo(Description description) {
                description.appendValue((Object)BoltResponseMessage.SUCCESS).appendText(String.format(" with metadata %s ~ %s", key, pattern.toString()));
            }
        };
    }

    public static Matcher<RecordedBoltResponse> wasIgnored() {
        return new BaseMatcher<RecordedBoltResponse>(){

            public boolean matches(Object item) {
                RecordedBoltResponse response = (RecordedBoltResponse)item;
                return response.message() == BoltResponseMessage.IGNORED;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)BoltResponseMessage.IGNORED);
            }
        };
    }

    public static Matcher<RecordedBoltResponse> failedWithStatus(final Status status) {
        return new BaseMatcher<RecordedBoltResponse>(){

            public boolean matches(Object item) {
                RecordedBoltResponse response = (RecordedBoltResponse)item;
                return response.message() == BoltResponseMessage.FAILURE && response.hasMetadata("code") && response.metadata("code").equals(Values.stringValue((String)status.code().serialize()));
            }

            public void describeTo(Description description) {
                description.appendValue((Object)BoltResponseMessage.FAILURE).appendText(String.format(" with status code %s", status.code().serialize()));
            }
        };
    }

    public static Matcher<BoltStateMachine> hasTransaction() {
        return new BaseMatcher<BoltStateMachine>(){

            public boolean matches(Object item) {
                BoltStateMachine machine = (BoltStateMachine)item;
                StatementProcessor statementProcessor = machine.statementProcessor();
                return statementProcessor != null && statementProcessor.hasTransaction();
            }

            public void describeTo(Description description) {
                description.appendText("no transaction");
            }
        };
    }

    public static Matcher<BoltStateMachine> hasNoTransaction() {
        return new BaseMatcher<BoltStateMachine>(){

            public boolean matches(Object item) {
                BoltStateMachine machine = (BoltStateMachine)item;
                StatementProcessor statementProcessor = machine.statementProcessor();
                return statementProcessor == null || !statementProcessor.hasTransaction();
            }

            public void describeTo(Description description) {
                description.appendText("no transaction");
            }
        };
    }

    public static Matcher<BoltStateMachine> inState(final BoltStateMachine.State state) {
        return new BaseMatcher<BoltStateMachine>(){

            public boolean matches(Object item) {
                BoltStateMachine machine = (BoltStateMachine)item;
                return machine.state() == state;
            }

            public void describeTo(Description description) {
                description.appendText("can reset");
            }
        };
    }

    public static Matcher<BoltStateMachine> isClosed() {
        return new BaseMatcher<BoltStateMachine>(){

            public boolean matches(Object item) {
                BoltStateMachine machine = (BoltStateMachine)item;
                return machine.isClosed();
            }

            public void describeTo(Description description) {
                description.appendText("can reset");
            }
        };
    }

    public static Matcher<BoltStateMachine> canReset() {
        return new BaseMatcher<BoltStateMachine>(){

            public boolean matches(Object item) {
                BoltStateMachine machine = (BoltStateMachine)item;
                BoltResponseRecorder recorder = new BoltResponseRecorder();
                try {
                    machine.reset((BoltResponseHandler)recorder);
                    return recorder.responseCount() == 1 && machine.state() == BoltStateMachine.State.READY;
                }
                catch (BoltConnectionFatality boltConnectionFatality) {
                    return false;
                }
            }

            public void describeTo(Description description) {
                description.appendText("can reset");
            }
        };
    }

    public static void verifyKillsConnection(ThrowingAction<BoltConnectionFatality> action) {
        try {
            action.apply();
            Assert.fail((String)"should have killed the connection");
        }
        catch (BoltConnectionFatality boltConnectionFatality) {
            // empty catch block
        }
    }

    public static void verifyOneResponse(BoltStateMachine.State initialState, ThrowingBiConsumer<BoltStateMachine, BoltResponseRecorder, BoltConnectionFatality> transition) throws AuthenticationException, BoltConnectionFatality {
        BoltStateMachine machine = MachineRoom.newMachine(initialState);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        try {
            transition.accept((Object)machine, (Object)recorder);
        }
        catch (BoltConnectionFatality boltConnectionFatality) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)recorder.responseCount());
    }
}

