/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.bolt.logging.NullBoltMessageLogger;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.transport.BoltProtocolPipelineInstaller;
import org.neo4j.bolt.transport.DefaultBoltProtocolPipelineInstallerFactory;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;

public class DefaultBoltProtocolPipelineInstallerFactoryTest {
    private static final String CONNECTOR = "default";

    @Test
    public void shouldCreateV1Handler() {
        DefaultBoltProtocolPipelineInstallerFactoryTest.testHandlerCreation(1L);
    }

    @Test
    public void shouldCreateV2Handler() {
        DefaultBoltProtocolPipelineInstallerFactoryTest.testHandlerCreation(2L);
    }

    @Test
    public void shouldCreateNothingForUnknownProtocolVersion() {
        int protocolVersion = 42;
        BoltChannel channel = (BoltChannel)Mockito.mock(BoltChannel.class);
        DefaultBoltProtocolPipelineInstallerFactory factory = new DefaultBoltProtocolPipelineInstallerFactory((BoltConnectionFactory)Mockito.mock(BoltConnectionFactory.class), TransportThrottleGroup.NO_THROTTLE, (LogService)NullLogService.getInstance());
        BoltProtocolPipelineInstaller handler = factory.create((long)protocolVersion, channel);
        Assert.assertNull((Object)handler);
    }

    private static void testHandlerCreation(long protocolVersion) {
        EmbeddedChannel channel = new EmbeddedChannel();
        BoltChannel boltChannel = BoltChannel.open((String)CONNECTOR, (Channel)channel, (BoltMessageLogger)NullBoltMessageLogger.getInstance());
        BoltConnectionFactory connectionFactory = (BoltConnectionFactory)Mockito.mock(BoltConnectionFactory.class);
        BoltConnection connection = (BoltConnection)Mockito.mock(BoltConnection.class);
        Mockito.when((Object)connectionFactory.newConnection(boltChannel)).thenReturn((Object)connection);
        DefaultBoltProtocolPipelineInstallerFactory factory = new DefaultBoltProtocolPipelineInstallerFactory(connectionFactory, TransportThrottleGroup.NO_THROTTLE, (LogService)NullLogService.getInstance());
        BoltProtocolPipelineInstaller handler = factory.create(protocolVersion, boltChannel);
        handler.install();
        Assert.assertEquals((long)protocolVersion, (long)handler.version());
        ((BoltConnectionFactory)Mockito.verify((Object)connectionFactory)).newConnection(boltChannel);
        ((BoltConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).stop();
        channel.close();
        ((BoltConnection)Mockito.verify((Object)connection)).stop();
        channel.finishAndReleaseAll();
    }
}

