/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.Iterator;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.bolt.logging.NullBoltMessageLogger;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.transport.DefaultBoltProtocolPipelineInstaller;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.bolt.transport.pipeline.ChunkDecoder;
import org.neo4j.bolt.transport.pipeline.HouseKeeper;
import org.neo4j.bolt.transport.pipeline.MessageAccumulator;
import org.neo4j.bolt.transport.pipeline.MessageDecoder;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.Neo4jPackV1;
import org.neo4j.bolt.v2.messaging.Neo4jPackV2;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;

@RunWith(value=Parameterized.class)
public class DefaultBoltProtocolPipelineInstallerTest {
    private final EmbeddedChannel channel = new EmbeddedChannel();
    @Parameterized.Parameter(value=0)
    public Neo4jPack pack;
    @Parameterized.Parameter(value=1)
    public String name;

    @Parameterized.Parameters(name="{1}")
    public static Object[][] testParameters() {
        return new Object[][]{{new Neo4jPackV1(), "V1"}, {new Neo4jPackV2(), "V2"}};
    }

    @After
    public void cleanup() {
        this.channel.finishAndReleaseAll();
    }

    @Test
    public void shouldReportCorrectVersion() {
        DefaultBoltProtocolPipelineInstaller protocol = new DefaultBoltProtocolPipelineInstaller(DefaultBoltProtocolPipelineInstallerTest.newBoltChannel((Channel)this.channel), (BoltConnection)Mockito.mock(BoltConnection.class), this.pack, TransportThrottleGroup.NO_THROTTLE, (LogService)NullLogService.getInstance());
        Assert.assertEquals((long)this.pack.version(), (long)protocol.version());
    }

    @Test
    public void shouldInstallChannelHandlersInCorrectOrder() {
        DefaultBoltProtocolPipelineInstaller protocol = new DefaultBoltProtocolPipelineInstaller(DefaultBoltProtocolPipelineInstallerTest.newBoltChannel((Channel)this.channel), (BoltConnection)Mockito.mock(BoltConnection.class), this.pack, TransportThrottleGroup.NO_THROTTLE, (LogService)NullLogService.getInstance());
        protocol.install();
        Iterator handlers = this.channel.pipeline().iterator();
        Assert.assertThat(((Map.Entry)handlers.next()).getValue(), (Matcher)Matchers.instanceOf(ChunkDecoder.class));
        Assert.assertThat(((Map.Entry)handlers.next()).getValue(), (Matcher)Matchers.instanceOf(MessageAccumulator.class));
        Assert.assertThat(((Map.Entry)handlers.next()).getValue(), (Matcher)Matchers.instanceOf(MessageDecoder.class));
        Assert.assertThat(((Map.Entry)handlers.next()).getValue(), (Matcher)Matchers.instanceOf(HouseKeeper.class));
        Assert.assertFalse((boolean)handlers.hasNext());
    }

    private static BoltChannel newBoltChannel(Channel rawChannel) {
        return BoltChannel.open((String)"bolt", (Channel)rawChannel, (BoltMessageLogger)NullBoltMessageLogger.getInstance());
    }
}

