/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.neo4j.bolt.transport.pipeline.MessageDecoder;
import org.neo4j.bolt.v1.messaging.BoltIOException;
import org.neo4j.bolt.v1.messaging.BoltRequestMessage;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageHandler;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.Neo4jPackV1;
import org.neo4j.bolt.v1.messaging.example.Edges;
import org.neo4j.bolt.v1.messaging.example.Nodes;
import org.neo4j.bolt.v1.messaging.example.Paths;
import org.neo4j.bolt.v1.messaging.message.AckFailureMessage;
import org.neo4j.bolt.v1.messaging.message.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.message.PullAllMessage;
import org.neo4j.bolt.v1.messaging.message.ResetMessage;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.packstream.PackedOutputArray;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.bolt.v2.messaging.Neo4jPackV2;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.VirtualValues;

@RunWith(value=Parameterized.class)
public class MessageDecoderTest {
    private EmbeddedChannel channel;
    @Parameterized.Parameter(value=0)
    public Neo4jPack packerUnderTest;
    @Parameterized.Parameter(value=1)
    public String name;

    @Parameterized.Parameters(name="{1}")
    public static Object[][] testParameters() {
        return new Object[][]{{new Neo4jPackV1(), "V1"}, {new Neo4jPackV2(), "V2"}};
    }

    @After
    public void cleanup() {
        if (this.channel != null) {
            this.channel.finishAndReleaseAll();
        }
    }

    @Test
    public void shouldDispatchInit() throws Exception {
        BoltRequestMessageHandler handler = (BoltRequestMessageHandler)Mockito.mock(BoltRequestMessageHandler.class);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new MessageDecoder(this.packerUnderTest, handler)});
        String userAgent = "Test/User Agent 1.0";
        Map authToken = MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "user", "credentials", "password"});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])MessageMatchers.serialize(this.packerUnderTest, InitMessage.init(userAgent, authToken)))});
        this.channel.finishAndReleaseAll();
        ((BoltRequestMessageHandler)Mockito.verify((Object)handler)).onInit(userAgent, authToken);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
    }

    @Test
    public void shouldDispatchAckFailure() throws Exception {
        BoltRequestMessageHandler handler = (BoltRequestMessageHandler)Mockito.mock(BoltRequestMessageHandler.class);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new MessageDecoder(this.packerUnderTest, handler)});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])MessageMatchers.serialize(this.packerUnderTest, AckFailureMessage.ackFailure()))});
        this.channel.finishAndReleaseAll();
        ((BoltRequestMessageHandler)Mockito.verify((Object)handler)).onAckFailure();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
    }

    @Test
    public void shouldDispatchReset() throws Exception {
        BoltRequestMessageHandler handler = (BoltRequestMessageHandler)Mockito.mock(BoltRequestMessageHandler.class);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new MessageDecoder(this.packerUnderTest, handler)});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])MessageMatchers.serialize(this.packerUnderTest, ResetMessage.reset()))});
        this.channel.finishAndReleaseAll();
        ((BoltRequestMessageHandler)Mockito.verify((Object)handler)).onReset();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
    }

    @Test
    public void shouldDispatchRun() throws Exception {
        BoltRequestMessageHandler handler = (BoltRequestMessageHandler)Mockito.mock(BoltRequestMessageHandler.class);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new MessageDecoder(this.packerUnderTest, handler)});
        String statement = "RETURN 1";
        MapValue parameters = ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"param1", 1, "param2", "2", "param3", true, "param4", 5.0}));
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])MessageMatchers.serialize(this.packerUnderTest, RunMessage.run(statement, parameters)))});
        this.channel.finishAndReleaseAll();
        ((BoltRequestMessageHandler)Mockito.verify((Object)handler)).onRun(statement, parameters);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
    }

    @Test
    public void shouldDispatchDiscardAll() throws Exception {
        BoltRequestMessageHandler handler = (BoltRequestMessageHandler)Mockito.mock(BoltRequestMessageHandler.class);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new MessageDecoder(this.packerUnderTest, handler)});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])MessageMatchers.serialize(this.packerUnderTest, DiscardAllMessage.discardAll()))});
        this.channel.finishAndReleaseAll();
        ((BoltRequestMessageHandler)Mockito.verify((Object)handler)).onDiscardAll();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
    }

    @Test
    public void shouldDispatchPullAll() throws Exception {
        BoltRequestMessageHandler handler = (BoltRequestMessageHandler)Mockito.mock(BoltRequestMessageHandler.class);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new MessageDecoder(this.packerUnderTest, handler)});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])MessageMatchers.serialize(this.packerUnderTest, PullAllMessage.pullAll()))});
        this.channel.finishAndReleaseAll();
        ((BoltRequestMessageHandler)Mockito.verify((Object)handler)).onPullAll();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
    }

    @Test
    public void shouldCallExternalErrorOnInitWithNullKeys() throws Exception {
        BoltRequestMessageHandler handler = (BoltRequestMessageHandler)Mockito.mock(BoltRequestMessageHandler.class);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new MessageDecoder(this.packerUnderTest, handler)});
        String userAgent = "Test/User Agent 1.0";
        Map authToken = MapUtil.map((Object[])new Object[]{"scheme", "basic", null, "user", "credentials", "password"});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])MessageMatchers.serialize(this.packerUnderTest, InitMessage.init(userAgent, authToken)))});
        this.channel.finishAndReleaseAll();
        ((BoltRequestMessageHandler)Mockito.verify((Object)handler)).onExternalError(Neo4jError.from((Status)Status.Request.Invalid, (String)"Value `null` is not supported as key in maps, must be a non-nullable string."));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
    }

    @Test
    public void shouldCallExternalErrorOnInitWithDuplicateKeys() throws Exception {
        BoltRequestMessageHandler handler = (BoltRequestMessageHandler)Mockito.mock(BoltRequestMessageHandler.class);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new MessageDecoder(this.packerUnderTest, handler)});
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.packerUnderTest.newPacker((PackOutput)out);
        packer.packStructHeader(2, BoltRequestMessage.INIT.signature());
        packer.pack("Test/User Agent 1.0");
        packer.packMapHeader(3);
        packer.pack("scheme");
        packer.pack("basic");
        packer.pack("principal");
        packer.pack("user");
        packer.pack("scheme");
        packer.pack("password");
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])out.bytes())});
        this.channel.finishAndReleaseAll();
        ((BoltRequestMessageHandler)Mockito.verify((Object)handler)).onExternalError(Neo4jError.from((Status)Status.Request.Invalid, (String)"Duplicate map key `scheme`."));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
    }

    @Test
    public void shouldCallExternalErrorOnNodeParameter() throws Exception {
        this.testUnpackableStructParametersWithKnownType((AnyValue)Nodes.ALICE, "Node values cannot be unpacked with this version of bolt.");
    }

    @Test
    public void shouldCallExternalErrorOnRelationshipParameter() throws Exception {
        this.testUnpackableStructParametersWithKnownType((AnyValue)Edges.ALICE_KNOWS_BOB, "Relationship values cannot be unpacked with this version of bolt.");
    }

    @Test
    public void shouldCallExternalErrorOnPathParameter() throws Exception {
        for (PathValue path : Paths.ALL_PATHS) {
            this.testUnpackableStructParametersWithKnownType((AnyValue)path, "Path values cannot be unpacked with this version of bolt.");
        }
    }

    @Test
    public void shouldCallExternalErrorOnDuration() throws Exception {
        Assume.assumeThat((Object)this.packerUnderTest.version(), (Matcher)Matchers.equalTo((Object)1L));
        this.testUnpackableStructParametersWithKnownType((Neo4jPack)new Neo4jPackV2(), (AnyValue)Values.durationValue((TemporalAmount)Duration.ofDays(10L)), "Duration values cannot be unpacked with this version of bolt.");
    }

    @Test
    public void shouldCallExternalErrorOnDate() throws Exception {
        Assume.assumeThat((Object)this.packerUnderTest.version(), (Matcher)Matchers.equalTo((Object)1L));
        this.testUnpackableStructParametersWithKnownType((Neo4jPack)new Neo4jPackV2(), ValueUtils.of((Object)LocalDate.now()), "LocalDate values cannot be unpacked with this version of bolt.");
    }

    @Test
    public void shouldCallExternalErrorOnLocalTime() throws Exception {
        Assume.assumeThat((Object)this.packerUnderTest.version(), (Matcher)Matchers.equalTo((Object)1L));
        this.testUnpackableStructParametersWithKnownType((Neo4jPack)new Neo4jPackV2(), ValueUtils.of((Object)LocalTime.now()), "LocalTime values cannot be unpacked with this version of bolt.");
    }

    @Test
    public void shouldCallExternalErrorOnTime() throws Exception {
        Assume.assumeThat((Object)this.packerUnderTest.version(), (Matcher)Matchers.equalTo((Object)1L));
        this.testUnpackableStructParametersWithKnownType((Neo4jPack)new Neo4jPackV2(), ValueUtils.of((Object)OffsetTime.now()), "OffsetTime values cannot be unpacked with this version of bolt.");
    }

    @Test
    public void shouldCallExternalErrorOnLocalDateTime() throws Exception {
        Assume.assumeThat((Object)this.packerUnderTest.version(), (Matcher)Matchers.equalTo((Object)1L));
        this.testUnpackableStructParametersWithKnownType((Neo4jPack)new Neo4jPackV2(), ValueUtils.of((Object)LocalDateTime.now()), "LocalDateTime values cannot be unpacked with this version of bolt.");
    }

    @Test
    public void shouldCallExternalErrorOnDateTimeWithOffset() throws Exception {
        Assume.assumeThat((Object)this.packerUnderTest.version(), (Matcher)Matchers.equalTo((Object)1L));
        this.testUnpackableStructParametersWithKnownType((Neo4jPack)new Neo4jPackV2(), ValueUtils.of((Object)OffsetDateTime.now()), "OffsetDateTime values cannot be unpacked with this version of bolt.");
    }

    @Test
    public void shouldCallExternalErrorOnDateTimeWithZoneName() throws Exception {
        Assume.assumeThat((Object)this.packerUnderTest.version(), (Matcher)Matchers.equalTo((Object)1L));
        this.testUnpackableStructParametersWithKnownType((Neo4jPack)new Neo4jPackV2(), ValueUtils.of((Object)ZonedDateTime.now()), "ZonedDateTime values cannot be unpacked with this version of bolt.");
    }

    @Test
    public void shouldThrowOnUnknownStructType() throws Exception {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.packerUnderTest.newPacker((PackOutput)out);
        packer.packStructHeader(2, BoltRequestMessage.RUN.signature());
        packer.pack("RETURN $x");
        packer.packMapHeader(1);
        packer.pack("x");
        packer.packStructHeader(0, (byte)65);
        try {
            this.unpack(out.bytes());
        }
        catch (BoltIOException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.equalTo((Object)"Struct types of 0x41 are not recognized."));
        }
    }

    private void testUnpackableStructParametersWithKnownType(AnyValue parameterValue, String expectedMessage) throws IOException {
        this.testUnpackableStructParametersWithKnownType(this.packerUnderTest, parameterValue, expectedMessage);
    }

    private void testUnpackableStructParametersWithKnownType(Neo4jPack packerForSerialization, AnyValue parameterValue, String expectedMessage) throws IOException {
        String statement = "RETURN $x";
        MapValue parameters = VirtualValues.map(Collections.singletonMap("x", parameterValue));
        BoltRequestMessageHandler handler = (BoltRequestMessageHandler)Mockito.mock(BoltRequestMessageHandler.class);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new MessageDecoder(this.packerUnderTest, handler)});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])MessageMatchers.serialize(packerForSerialization, RunMessage.run(statement, parameters)))});
        this.channel.finishAndReleaseAll();
        ((BoltRequestMessageHandler)Mockito.verify((Object)handler)).onExternalError(Neo4jError.from((Status)Status.Statement.TypeError, (String)expectedMessage));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
    }

    private void unpack(byte[] input) throws IOException {
        BoltRequestMessageHandler handler = (BoltRequestMessageHandler)Mockito.mock(BoltRequestMessageHandler.class);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new MessageDecoder(this.packerUnderTest, handler)});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])input)});
        this.channel.finishAndReleaseAll();
    }
}

