/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.bolt.logging.NullBoltMessageLogger;
import org.neo4j.bolt.testing.BoltTestUtil;
import org.neo4j.bolt.transport.BoltProtocolPipelineInstaller;
import org.neo4j.bolt.transport.BoltProtocolPipelineInstallerFactory;
import org.neo4j.bolt.transport.pipeline.ProtocolHandshaker;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class ProtocolHandshakerTest {
    private final String connector = "default";
    private final Channel channel = (Channel)Mockito.mock(Channel.class);
    private final LogProvider logProvider = NullLogProvider.getInstance();
    private final BoltMessageLogger messageLogger = NullBoltMessageLogger.getInstance();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void shouldChooseFirstAvailableProtocol() {
        try (BoltChannel boltChannel = BoltChannel.open((String)"default", (Channel)this.channel, (BoltMessageLogger)this.messageLogger);){
            BoltProtocolPipelineInstaller handler = ProtocolHandshakerTest.newHandler(1L);
            BoltProtocolPipelineInstallerFactory handlerFactory = ProtocolHandshakerTest.newHandlerFactory(1L, handler);
            EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ProtocolHandshaker(handlerFactory, boltChannel, this.logProvider, false, true)});
            ByteBuf input = Unpooled.wrappedBuffer((byte[][])new byte[][]{{96, 96, -80, 23}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}});
            channel.writeInbound(new Object[]{input});
            Assert.assertEquals((long)1L, (long)channel.outboundMessages().size());
            BoltTestUtil.assertByteBufEquals(Unpooled.buffer().writeInt(1), (ByteBuf)channel.readOutbound());
            this.thrown.expect(NoSuchElementException.class);
            channel.pipeline().remove(ProtocolHandshaker.class);
            Assert.assertTrue((boolean)channel.isActive());
            ((BoltProtocolPipelineInstaller)Mockito.verify((Object)handler)).install();
        }
    }

    @Test
    public void shouldHandleFragmentedMessage() {
        try (BoltChannel boltChannel = BoltChannel.open((String)"default", (Channel)this.channel, (BoltMessageLogger)this.messageLogger);){
            BoltProtocolPipelineInstaller handler = ProtocolHandshakerTest.newHandler(1L);
            BoltProtocolPipelineInstallerFactory handlerFactory = ProtocolHandshakerTest.newHandlerFactory(1L, handler);
            EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ProtocolHandshaker(handlerFactory, boltChannel, this.logProvider, false, true)});
            channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{96, 96, -80})});
            Assert.assertEquals((long)0L, (long)channel.outboundMessages().size());
            channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{23, 0, 0, 0})});
            Assert.assertEquals((long)0L, (long)channel.outboundMessages().size());
            channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 0, 0})});
            Assert.assertEquals((long)0L, (long)channel.outboundMessages().size());
            channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 0, 0, 0})});
            Assert.assertEquals((long)0L, (long)channel.outboundMessages().size());
            channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 0, 0})});
            Assert.assertEquals((long)0L, (long)channel.outboundMessages().size());
            channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 0})});
            Assert.assertEquals((long)1L, (long)channel.outboundMessages().size());
            BoltTestUtil.assertByteBufEquals(Unpooled.buffer().writeInt(1), (ByteBuf)channel.readOutbound());
            this.thrown.expect(NoSuchElementException.class);
            channel.pipeline().remove(ProtocolHandshaker.class);
            Assert.assertTrue((boolean)channel.isActive());
            ((BoltProtocolPipelineInstaller)Mockito.verify((Object)handler)).install();
        }
    }

    @Test
    public void shouldHandleHandshakeFollowedImmediatelyByMessage() {
        try (BoltChannel boltChannel = BoltChannel.open((String)"default", (Channel)this.channel, (BoltMessageLogger)this.messageLogger);){
            BoltProtocolPipelineInstaller handler = ProtocolHandshakerTest.newHandler(1L);
            BoltProtocolPipelineInstallerFactory handlerFactory = ProtocolHandshakerTest.newHandlerFactory(1L, handler);
            EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ProtocolHandshaker(handlerFactory, boltChannel, this.logProvider, false, true)});
            ByteBuf input = Unpooled.wrappedBuffer((byte[][])new byte[][]{{96, 96, -80, 23}, {0, 0, 0, 0}, {0, 0, 0, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {1, 2, 3, 4}});
            channel.writeInbound(new Object[]{input});
            Assert.assertEquals((long)1L, (long)channel.outboundMessages().size());
            BoltTestUtil.assertByteBufEquals(Unpooled.buffer().writeInt(1), (ByteBuf)channel.readOutbound());
            Assert.assertEquals((long)1L, (long)channel.inboundMessages().size());
            BoltTestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4}), (ByteBuf)channel.readInbound());
            this.thrown.expect(NoSuchElementException.class);
            channel.pipeline().remove(ProtocolHandshaker.class);
            Assert.assertTrue((boolean)channel.isActive());
            ((BoltProtocolPipelineInstaller)Mockito.verify((Object)handler)).install();
        }
    }

    @Test
    public void shouldHandleMaxVersionNumber() {
        try (BoltChannel boltChannel = BoltChannel.open((String)"default", (Channel)this.channel, (BoltMessageLogger)this.messageLogger);){
            long maxVersionNumber = 0xFFFFFFFFL;
            BoltProtocolPipelineInstaller handler = ProtocolHandshakerTest.newHandler(maxVersionNumber);
            BoltProtocolPipelineInstallerFactory handlerFactory = ProtocolHandshakerTest.newHandlerFactory(maxVersionNumber, handler);
            EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ProtocolHandshaker(handlerFactory, boltChannel, this.logProvider, false, true)});
            ByteBuf input = Unpooled.wrappedBuffer((byte[][])new byte[][]{{96, 96, -80, 23}, {-1, -1, -1, -1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}});
            channel.writeInbound(new Object[]{input});
            Assert.assertEquals((long)1L, (long)channel.outboundMessages().size());
            BoltTestUtil.assertByteBufEquals(Unpooled.buffer().writeInt((int)maxVersionNumber), (ByteBuf)channel.readOutbound());
            this.thrown.expect(NoSuchElementException.class);
            channel.pipeline().remove(ProtocolHandshaker.class);
            Assert.assertTrue((boolean)channel.isActive());
            ((BoltProtocolPipelineInstaller)Mockito.verify((Object)handler)).install();
        }
    }

    @Test
    public void shouldFallbackToNoProtocolIfNoMatch() {
        try (BoltChannel boltChannel = BoltChannel.open((String)"default", (Channel)this.channel, (BoltMessageLogger)this.messageLogger);){
            BoltProtocolPipelineInstaller handler = ProtocolHandshakerTest.newHandler(1L);
            BoltProtocolPipelineInstallerFactory handlerFactory = ProtocolHandshakerTest.newHandlerFactory(1L, handler);
            EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ProtocolHandshaker(handlerFactory, boltChannel, this.logProvider, false, true)});
            ByteBuf input = Unpooled.wrappedBuffer((byte[][])new byte[][]{{96, 96, -80, 23}, {0, 0, 0, 0}, {0, 0, 0, 2}, {0, 0, 0, 3}, {0, 0, 0, 4}});
            channel.writeInbound(new Object[]{input});
            Assert.assertEquals((long)1L, (long)channel.outboundMessages().size());
            BoltTestUtil.assertByteBufEquals(Unpooled.buffer().writeInt(0), (ByteBuf)channel.readOutbound());
            Assert.assertFalse((boolean)channel.isActive());
            ((BoltProtocolPipelineInstaller)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).install();
        }
    }

    @Test
    public void shouldRejectIfWrongPreamble() {
        try (BoltChannel boltChannel = BoltChannel.open((String)"default", (Channel)this.channel, (BoltMessageLogger)this.messageLogger);){
            BoltProtocolPipelineInstaller handler = ProtocolHandshakerTest.newHandler(1L);
            BoltProtocolPipelineInstallerFactory handlerFactory = ProtocolHandshakerTest.newHandlerFactory(1L, handler);
            EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ProtocolHandshaker(handlerFactory, boltChannel, this.logProvider, false, true)});
            ByteBuf input = Unpooled.wrappedBuffer((byte[][])new byte[][]{{-34, -85, -51, -17}, {0, 0, 0, 1}, {0, 0, 0, 2}, {0, 0, 0, 3}, {0, 0, 0, 4}});
            channel.writeInbound(new Object[]{input});
            Assert.assertEquals((long)0L, (long)channel.outboundMessages().size());
            Assert.assertFalse((boolean)channel.isActive());
            ((BoltProtocolPipelineInstaller)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).install();
        }
    }

    @Test
    public void shouldRejectIfInsecureWhenEncryptionRequired() {
        try (BoltChannel boltChannel = BoltChannel.open((String)"default", (Channel)this.channel, (BoltMessageLogger)this.messageLogger);){
            BoltProtocolPipelineInstaller handler = ProtocolHandshakerTest.newHandler(1L);
            BoltProtocolPipelineInstallerFactory handlerFactory = ProtocolHandshakerTest.newHandlerFactory(1L, handler);
            EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ProtocolHandshaker(handlerFactory, boltChannel, this.logProvider, true, false)});
            ByteBuf input = Unpooled.wrappedBuffer((byte[][])new byte[][]{{96, 96, -80, 23}, {0, 0, 0, 1}, {0, 0, 0, 2}, {0, 0, 0, 3}, {0, 0, 0, 4}});
            channel.writeInbound(new Object[]{input});
            Assert.assertEquals((long)0L, (long)channel.outboundMessages().size());
            Assert.assertFalse((boolean)channel.isActive());
            ((BoltProtocolPipelineInstaller)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).install();
        }
    }

    private static BoltProtocolPipelineInstaller newHandler(long version) {
        BoltProtocolPipelineInstaller handler = (BoltProtocolPipelineInstaller)Mockito.mock(BoltProtocolPipelineInstaller.class);
        Mockito.when((Object)handler.version()).thenReturn((Object)version);
        return handler;
    }

    private static BoltProtocolPipelineInstallerFactory newHandlerFactory(long version, BoltProtocolPipelineInstaller handler) {
        return (givenVersion, channel) -> version == givenVersion ? handler : null;
    }
}

