/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.bolt.v1.messaging.AuthTokenValuesWriter;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public class AuthTokenValuesWriterTest {
    @Test
    public void shouldFailToWriteNode() {
        AuthTokenValuesWriter writer = new AuthTokenValuesWriter();
        NodeValue value = VirtualValues.nodeValue((long)42L, (TextArray)Values.stringArray((String[])new String[]{"Person"}), (MapValue)VirtualValues.EMPTY_MAP);
        try {
            writer.valueAsObject((AnyValue)value);
            Assert.fail((String)"Exception expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailToWriteRelationship() {
        AuthTokenValuesWriter writer = new AuthTokenValuesWriter();
        NodeValue startNode = VirtualValues.nodeValue((long)24L, (TextArray)Values.stringArray((String[])new String[]{"Person"}), (MapValue)VirtualValues.EMPTY_MAP);
        NodeValue endNode = VirtualValues.nodeValue((long)42L, (TextArray)Values.stringArray((String[])new String[]{"Person"}), (MapValue)VirtualValues.EMPTY_MAP);
        RelationshipValue value = VirtualValues.relationshipValue((long)42L, (NodeValue)startNode, (NodeValue)endNode, (TextValue)Values.stringValue((String)"KNOWS"), (MapValue)VirtualValues.EMPTY_MAP);
        try {
            writer.valueAsObject((AnyValue)value);
            Assert.fail((String)"Exception expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailToWritePoint() {
        AuthTokenValuesWriter writer = new AuthTokenValuesWriter();
        PointValue value = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[2]);
        try {
            writer.valueAsObject((AnyValue)value);
            Assert.fail((String)"Exception expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldConvertStringValueToString() {
        AuthTokenValuesWriter writer = new AuthTokenValuesWriter();
        TextValue value = Values.stringValue((String)"Hello");
        Assert.assertEquals((Object)"Hello", (Object)writer.valueAsObject((AnyValue)value));
    }

    @Test
    public void shouldConvertLongValueToLong() {
        AuthTokenValuesWriter writer = new AuthTokenValuesWriter();
        LongValue value = Values.longValue((long)42L);
        Assert.assertEquals((Object)42L, (Object)writer.valueAsObject((AnyValue)value));
    }

    @Test
    public void shouldConvertMultipleValues() {
        AuthTokenValuesWriter writer = new AuthTokenValuesWriter();
        TextValue value1 = Values.stringValue((String)"Hello");
        TextValue value2 = Values.stringValue((String)" ");
        TextValue value3 = Values.stringValue((String)"World!");
        LongValue value4 = Values.longValue((long)42L);
        Assert.assertEquals((Object)"Hello", (Object)writer.valueAsObject((AnyValue)value1));
        Assert.assertEquals((Object)" ", (Object)writer.valueAsObject((AnyValue)value2));
        Assert.assertEquals((Object)"World!", (Object)writer.valueAsObject((AnyValue)value3));
        Assert.assertEquals((Object)42L, (Object)writer.valueAsObject((AnyValue)value4));
    }
}

