/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.util.Map;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageHandler;
import org.neo4j.bolt.v1.messaging.MessageRecorder;
import org.neo4j.bolt.v1.messaging.message.AckFailureMessage;
import org.neo4j.bolt.v1.messaging.message.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.message.PullAllMessage;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.messaging.message.ResetMessage;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.values.virtual.MapValue;

public class BoltRequestMessageRecorder
extends MessageRecorder<RequestMessage>
implements BoltRequestMessageHandler {
    public void onInit(String clientName, Map<String, Object> credentials) {
        this.messages.add(InitMessage.init(clientName, credentials));
    }

    public void onAckFailure() {
        this.messages.add(AckFailureMessage.ackFailure());
    }

    public void onReset() {
        this.messages.add(ResetMessage.reset());
    }

    public void onRun(String statement, MapValue params) {
        this.messages.add(RunMessage.run(statement, params));
    }

    public void onDiscardAll() {
        this.messages.add(DiscardAllMessage.discardAll());
    }

    public void onPullAll() {
        this.messages.add(PullAllMessage.pullAll());
    }

    public void onExternalError(Neo4jError error) {
    }
}

