/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageHandler;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageRecorder;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageWriter;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.Neo4jPackV1;
import org.neo4j.bolt.v1.messaging.RecordingByteChannel;
import org.neo4j.bolt.v1.messaging.message.AckFailureMessage;
import org.neo4j.bolt.v1.messaging.message.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.message.PullAllMessage;
import org.neo4j.bolt.v1.messaging.message.RecordMessage;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.messaging.message.ResetMessage;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.packstream.BufferedChannelInput;
import org.neo4j.bolt.v1.packstream.BufferedChannelOutput;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.runtime.spi.Records;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.util.HexPrinter;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public class BoltRequestMessageTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private final Neo4jPack neo4jPack = new Neo4jPackV1();

    @Test
    public void shouldHandleCommonMessages() throws Throwable {
        this.assertSerializes(InitMessage.init("MyClient/1.0", MapUtil.map((Object[])new Object[]{"scheme", "basic"})));
        this.assertSerializes(AckFailureMessage.ackFailure());
        this.assertSerializes(ResetMessage.reset());
        this.assertSerializes(RunMessage.run("CREATE (n) RETURN \u00e5\u00e4\u00f6"));
        this.assertSerializes(DiscardAllMessage.discardAll());
        this.assertSerializes(PullAllMessage.pullAll());
    }

    @Test
    public void shouldHandleParameterizedStatements() throws Throwable {
        MapValue parameters = ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 12L}));
        RunMessage msg = this.serializeAndDeserialize(RunMessage.run("asd", parameters));
        MapValue params = msg.params();
        MatcherAssert.assertThat((Object)params, (Matcher)Matchers.equalTo((Object)parameters));
    }

    @Test
    public void shouldSerializeNode() throws Throwable {
        NodeValue nodeValue = VirtualValues.nodeValue((long)12L, (TextArray)Values.stringArray((String[])new String[]{"User", "Banana"}), (MapValue)VirtualValues.map((String[])new String[]{"name", "age"}, (AnyValue[])new AnyValue[]{Values.stringValue((String)"Bob"), Values.intValue((int)14)}));
        MatcherAssert.assertThat((Object)this.serialized((AnyValue)nodeValue), (Matcher)Matchers.equalTo((Object)("B1 71 91 B3 4E 0C 92 84 55 73 65 72 86 42 61 6E" + System.lineSeparator() + "61 6E 61 A2 84 6E 61 6D 65 83 42 6F 62 83 61 67" + System.lineSeparator() + "65 0E")));
    }

    @Test
    public void shouldSerializeRelationship() throws Throwable {
        RelationshipValue rel = VirtualValues.relationshipValue((long)12L, (NodeValue)VirtualValues.nodeValue((long)1L, (TextArray)Values.stringArray((String[])new String[0]), (MapValue)VirtualValues.EMPTY_MAP), (NodeValue)VirtualValues.nodeValue((long)2L, (TextArray)Values.stringArray((String[])new String[0]), (MapValue)VirtualValues.EMPTY_MAP), (TextValue)Values.stringValue((String)"KNOWS"), (MapValue)VirtualValues.map((String[])new String[]{"name", "age"}, (AnyValue[])new AnyValue[]{Values.stringValue((String)"Bob"), Values.intValue((int)14)}));
        MatcherAssert.assertThat((Object)this.serialized((AnyValue)rel), (Matcher)Matchers.equalTo((Object)("B1 71 91 B5 52 0C 01 02 85 4B 4E 4F 57 53 A2 84" + System.lineSeparator() + "6E 61 6D 65 83 42 6F 62 83 61 67 65 0E")));
    }

    private String serialized(AnyValue object) throws IOException {
        RecordMessage message = new RecordMessage(Records.record((AnyValue[])new AnyValue[]{object}));
        return HexPrinter.hex((byte[])MessageMatchers.serialize(this.neo4jPack, message), (int)4, (String)" ");
    }

    private void assertSerializes(RequestMessage msg) throws IOException {
        MatcherAssert.assertThat((Object)this.serializeAndDeserialize(msg), (Matcher)Matchers.equalTo((Object)msg));
    }

    private <T extends RequestMessage> T serializeAndDeserialize(T msg) throws IOException {
        RecordingByteChannel channel = new RecordingByteChannel();
        BoltRequestMessageReader reader = new BoltRequestMessageReader(this.neo4jPack.newUnpacker((PackInput)new BufferedChannelInput(16).reset(channel)));
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)new BufferedChannelOutput(channel));
        BoltRequestMessageWriter writer = new BoltRequestMessageWriter(packer);
        writer.write(msg).flush();
        channel.eof();
        return this.unpack(reader, channel);
    }

    private <T extends RequestMessage> T unpack(BoltRequestMessageReader reader, RecordingByteChannel channel) {
        String serialized = HexPrinter.hex((byte[])channel.getBytes());
        BoltRequestMessageRecorder messages = new BoltRequestMessageRecorder();
        try {
            reader.read((BoltRequestMessageHandler)messages);
        }
        catch (Throwable e) {
            throw new AssertionError("Failed to unpack message, wire data was:\n" + serialized + "[" + channel.getBytes().length + "b]", e);
        }
        return (T)((RequestMessage)messages.asList().get(0));
    }
}

