/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.neo4j.bolt.v1.messaging.BoltRequestMessage;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageHandler;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;

public class BoltRequestMessageWriter
implements BoltRequestMessageHandler {
    private final Neo4jPack.Packer packer;

    public BoltRequestMessageWriter(Neo4jPack.Packer packer) {
        this.packer = packer;
    }

    public BoltRequestMessageWriter write(RequestMessage message) throws IOException {
        message.dispatch(this);
        return this;
    }

    public void onInit(String clientName, Map<String, Object> credentials) {
        try {
            this.packer.packStructHeader(2, BoltRequestMessage.INIT.signature());
            this.packer.pack(clientName);
            this.packer.pack((AnyValue)ValueUtils.asMapValue(credentials));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void onAckFailure() {
        try {
            this.packer.packStructHeader(0, BoltRequestMessage.ACK_FAILURE.signature());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void onReset() {
        try {
            this.packer.packStructHeader(0, BoltRequestMessage.RESET.signature());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void onRun(String statement, MapValue params) {
        try {
            this.packer.packStructHeader(2, BoltRequestMessage.RUN.signature());
            this.packer.pack(statement);
            this.packer.pack((AnyValue)params);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void onDiscardAll() {
        try {
            this.packer.packStructHeader(0, BoltRequestMessage.DISCARD_ALL.signature());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void onPullAll() {
        try {
            this.packer.packStructHeader(0, BoltRequestMessage.PULL_ALL.signature());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void flush() {
        try {
            this.packer.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void onExternalError(Neo4jError error) {
    }
}

