/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import org.neo4j.bolt.v1.messaging.BoltIOException;
import org.neo4j.bolt.v1.messaging.BoltResponseMessage;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageHandler;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.packstream.PackStream;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.bolt.v1.runtime.spi.Records;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.virtual.MapValue;

public class BoltResponseMessageReader {
    private final Neo4jPack.Unpacker unpacker;

    public BoltResponseMessageReader(Neo4jPack.Unpacker unpacker) {
        this.unpacker = unpacker;
    }

    public <E extends Exception> void read(BoltResponseMessageHandler<E> handler) throws IOException, E {
        try {
            this.unpacker.unpackStructHeader();
            char signature = this.unpacker.unpackStructSignature();
            BoltResponseMessage message = BoltResponseMessage.withSignature((int)signature);
            try {
                switch (message) {
                    case SUCCESS: {
                        MapValue successMetadata = this.unpacker.unpackMap();
                        handler.onSuccess(successMetadata);
                        break;
                    }
                    case RECORD: {
                        long length = this.unpacker.unpackListHeader();
                        AnyValue[] fields = new AnyValue[(int)length];
                        int i = 0;
                        while ((long)i < length) {
                            fields[i] = this.unpacker.unpack();
                            ++i;
                        }
                        handler.onRecord(Records.record((AnyValue[])fields));
                        break;
                    }
                    case IGNORED: {
                        handler.onIgnored();
                        break;
                    }
                    case FAILURE: {
                        MapValue failureMetadata = this.unpacker.unpackMap();
                        String code = failureMetadata.containsKey("code") ? ((StringValue)failureMetadata.get("code")).stringValue() : Status.General.UnknownError.name();
                        String msg = failureMetadata.containsKey("message") ? ((StringValue)failureMetadata.get("message")).stringValue() : "<No message supplied>";
                        handler.onFailure(Neo4jError.codeFromString((String)code), msg);
                        break;
                    }
                    default: {
                        throw new BoltIOException((Status)Status.Request.InvalidFormat, String.format("Message 0x%s is not supported.", Integer.toHexString(signature)));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new BoltIOException((Status)Status.Request.InvalidFormat, String.format("Message 0x%s is not a valid message signature.", Integer.toHexString(signature)));
            }
        }
        catch (PackStream.PackStreamException e) {
            throw new BoltIOException((Status)Status.Request.InvalidFormat, String.format("Unable to read message type. Error was: %s.", e.getMessage()), (Throwable)e);
        }
    }
}

