/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.bolt.logging.NullBoltMessageLogger;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageReader;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageRecorder;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.Neo4jPackV1;
import org.neo4j.bolt.v1.messaging.RecordingByteChannel;
import org.neo4j.bolt.v1.messaging.example.Paths;
import org.neo4j.bolt.v1.messaging.message.FailureMessage;
import org.neo4j.bolt.v1.messaging.message.IgnoredMessage;
import org.neo4j.bolt.v1.messaging.message.RecordMessage;
import org.neo4j.bolt.v1.messaging.message.ResponseMessage;
import org.neo4j.bolt.v1.messaging.message.SuccessMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.packstream.BufferedChannelInput;
import org.neo4j.bolt.v1.packstream.BufferedChannelOutput;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.runtime.spi.Records;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.util.HexPrinter;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public class BoltResponseMessageTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private final Neo4jPack neo4jPack = new Neo4jPackV1();

    @Test
    public void shouldHandleCommonMessages() throws Throwable {
        this.assertSerializes(new RecordMessage(Records.record((AnyValue[])new AnyValue[]{Values.longValue((long)1L), Values.stringValue((String)"b"), Values.longValue((long)2L)})));
        this.assertSerializes(new SuccessMessage(VirtualValues.EMPTY_MAP));
        this.assertSerializes(new FailureMessage((Status)Status.General.UnknownError, "Err"));
        this.assertSerializes(new IgnoredMessage());
    }

    @Test
    public void shouldSerializeBasicTypes() throws Throwable {
        this.assertSerializesNeoValue(null);
        this.assertSerializesNeoValue(true);
        this.assertSerializesNeoValue(false);
        this.assertSerializesNeoValue(Long.MAX_VALUE);
        this.assertSerializesNeoValue(1337L);
        this.assertSerializesNeoValue(Long.MIN_VALUE);
        this.assertSerializesNeoValue(Double.MIN_VALUE);
        this.assertSerializesNeoValue(13.37);
        this.assertSerializesNeoValue(Double.MAX_VALUE);
        this.assertSerializesNeoValue("");
        this.assertSerializesNeoValue("A basic piece of text");
        this.assertSerializesNeoValue(new String(new byte[16000], StandardCharsets.UTF_8));
        this.assertSerializesNeoValue(Collections.emptyList());
        this.assertSerializesNeoValue(Arrays.asList(null, null));
        this.assertSerializesNeoValue(Arrays.asList(true, false));
        this.assertSerializesNeoValue(Arrays.asList("one", "", "three"));
        this.assertSerializesNeoValue(Arrays.asList(12.4, 0.0));
        this.assertSerializesNeoValue(MapUtil.map((Object[])new Object[]{"k", null}));
        this.assertSerializesNeoValue(MapUtil.map((Object[])new Object[]{"k", true}));
        this.assertSerializesNeoValue(MapUtil.map((Object[])new Object[]{"k", false}));
        this.assertSerializesNeoValue(MapUtil.map((Object[])new Object[]{"k", 1337L}));
        this.assertSerializesNeoValue(MapUtil.map((Object[])new Object[]{"k", 133.7}));
        this.assertSerializesNeoValue(MapUtil.map((Object[])new Object[]{"k", "Hello"}));
        this.assertSerializesNeoValue(MapUtil.map((Object[])new Object[]{"k", Arrays.asList("one", "", "three")}));
    }

    @Test
    public void shouldSerializeNode() throws Throwable {
        NodeValue nodeValue = VirtualValues.nodeValue((long)12L, (TextArray)Values.stringArray((String[])new String[]{"User", "Banana"}), (MapValue)VirtualValues.map((String[])new String[]{"name", "age"}, (AnyValue[])new AnyValue[]{Values.stringValue((String)"Bob"), Values.intValue((int)14)}));
        MatcherAssert.assertThat((Object)this.serialized((AnyValue)nodeValue), (Matcher)Matchers.equalTo((Object)("B1 71 91 B3 4E 0C 92 84 55 73 65 72 86 42 61 6E" + System.lineSeparator() + "61 6E 61 A2 84 6E 61 6D 65 83 42 6F 62 83 61 67" + System.lineSeparator() + "65 0E")));
    }

    @Test
    public void shouldSerializeRelationship() throws Throwable {
        RelationshipValue rel = VirtualValues.relationshipValue((long)12L, (NodeValue)VirtualValues.nodeValue((long)1L, (TextArray)Values.stringArray((String[])new String[0]), (MapValue)VirtualValues.EMPTY_MAP), (NodeValue)VirtualValues.nodeValue((long)2L, (TextArray)Values.stringArray((String[])new String[0]), (MapValue)VirtualValues.EMPTY_MAP), (TextValue)Values.stringValue((String)"KNOWS"), (MapValue)VirtualValues.map((String[])new String[]{"name", "age"}, (AnyValue[])new AnyValue[]{Values.stringValue((String)"Bob"), Values.intValue((int)14)}));
        MatcherAssert.assertThat((Object)this.serialized((AnyValue)rel), (Matcher)Matchers.equalTo((Object)("B1 71 91 B5 52 0C 01 02 85 4B 4E 4F 57 53 A2 84" + System.lineSeparator() + "6E 61 6D 65 83 42 6F 62 83 61 67 65 0E")));
    }

    @Test
    public void shouldSerializePaths() throws Throwable {
        MatcherAssert.assertThat((Object)this.serialized((AnyValue)Paths.PATH_WITH_LENGTH_ZERO), (Matcher)Matchers.equalTo((Object)("B1 71 91 B3 50 91 B3 4E C9 03 E9 92 86 50 65 72" + System.lineSeparator() + "73 6F 6E 88 45 6D 70 6C 6F 79 65 65 A2 84 6E 61" + System.lineSeparator() + "6D 65 85 41 6C 69 63 65 83 61 67 65 21 90 90")));
        MatcherAssert.assertThat((Object)this.serialized((AnyValue)Paths.PATH_WITH_LENGTH_ONE), (Matcher)Matchers.equalTo((Object)("B1 71 91 B3 50 92 B3 4E C9 03 E9 92 86 50 65 72" + System.lineSeparator() + "73 6F 6E 88 45 6D 70 6C 6F 79 65 65 A2 84 6E 61" + System.lineSeparator() + "6D 65 85 41 6C 69 63 65 83 61 67 65 21 B3 4E C9" + System.lineSeparator() + "03 EA 92 86 50 65 72 73 6F 6E 88 45 6D 70 6C 6F" + System.lineSeparator() + "79 65 65 A2 84 6E 61 6D 65 83 42 6F 62 83 61 67" + System.lineSeparator() + "65 2C 91 B3 72 0C 85 4B 4E 4F 57 53 A1 85 73 69" + System.lineSeparator() + "6E 63 65 C9 07 CF 92 01 01")));
        MatcherAssert.assertThat((Object)this.serialized((AnyValue)Paths.PATH_WITH_LENGTH_TWO), (Matcher)Matchers.equalTo((Object)("B1 71 91 B3 50 93 B3 4E C9 03 E9 92 86 50 65 72" + System.lineSeparator() + "73 6F 6E 88 45 6D 70 6C 6F 79 65 65 A2 84 6E 61" + System.lineSeparator() + "6D 65 85 41 6C 69 63 65 83 61 67 65 21 B3 4E C9" + System.lineSeparator() + "03 EB 91 86 50 65 72 73 6F 6E A1 84 6E 61 6D 65" + System.lineSeparator() + "85 43 61 72 6F 6C B3 4E C9 03 EC 90 A1 84 6E 61" + System.lineSeparator() + "6D 65 84 44 61 76 65 92 B3 72 0D 85 4C 49 4B 45" + System.lineSeparator() + "53 A0 B3 72 22 8A 4D 41 52 52 49 45 44 5F 54 4F" + System.lineSeparator() + "A0 94 01 01 02 02")));
        MatcherAssert.assertThat((Object)this.serialized((AnyValue)Paths.PATH_WITH_RELATIONSHIP_TRAVERSED_AGAINST_ITS_DIRECTION), (Matcher)Matchers.equalTo((Object)("B1 71 91 B3 50 94 B3 4E C9 03 E9 92 86 50 65 72" + System.lineSeparator() + "73 6F 6E 88 45 6D 70 6C 6F 79 65 65 A2 84 6E 61" + System.lineSeparator() + "6D 65 85 41 6C 69 63 65 83 61 67 65 21 B3 4E C9" + System.lineSeparator() + "03 EA 92 86 50 65 72 73 6F 6E 88 45 6D 70 6C 6F" + System.lineSeparator() + "79 65 65 A2 84 6E 61 6D 65 83 42 6F 62 83 61 67" + System.lineSeparator() + "65 2C B3 4E C9 03 EB 91 86 50 65 72 73 6F 6E A1" + System.lineSeparator() + "84 6E 61 6D 65 85 43 61 72 6F 6C B3 4E C9 03 EC" + System.lineSeparator() + "90 A1 84 6E 61 6D 65 84 44 61 76 65 93 B3 72 0C" + System.lineSeparator() + "85 4B 4E 4F 57 53 A1 85 73 69 6E 63 65 C9 07 CF" + System.lineSeparator() + "B3 72 20 88 44 49 53 4C 49 4B 45 53 A0 B3 72 22" + System.lineSeparator() + "8A 4D 41 52 52 49 45 44 5F 54 4F A0 96 01 01 FE" + System.lineSeparator() + "02 03 03")));
        MatcherAssert.assertThat((Object)this.serialized((AnyValue)Paths.PATH_WITH_NODES_VISITED_MULTIPLE_TIMES), (Matcher)Matchers.equalTo((Object)("B1 71 91 B3 50 93 B3 4E C9 03 E9 92 86 50 65 72" + System.lineSeparator() + "73 6F 6E 88 45 6D 70 6C 6F 79 65 65 A2 84 6E 61" + System.lineSeparator() + "6D 65 85 41 6C 69 63 65 83 61 67 65 21 B3 4E C9" + System.lineSeparator() + "03 EA 92 86 50 65 72 73 6F 6E 88 45 6D 70 6C 6F" + System.lineSeparator() + "79 65 65 A2 84 6E 61 6D 65 83 42 6F 62 83 61 67" + System.lineSeparator() + "65 2C B3 4E C9 03 EB 91 86 50 65 72 73 6F 6E A1" + System.lineSeparator() + "84 6E 61 6D 65 85 43 61 72 6F 6C 93 B3 72 0C 85" + System.lineSeparator() + "4B 4E 4F 57 53 A1 85 73 69 6E 63 65 C9 07 CF B3" + System.lineSeparator() + "72 0D 85 4C 49 4B 45 53 A0 B3 72 20 88 44 49 53" + System.lineSeparator() + "4C 49 4B 45 53 A0 9A 01 01 FF 00 02 02 03 01 FD" + System.lineSeparator() + "02")));
        MatcherAssert.assertThat((Object)this.serialized((AnyValue)Paths.PATH_WITH_RELATIONSHIP_TRAVERSED_MULTIPLE_TIMES_IN_SAME_DIRECTION), (Matcher)Matchers.equalTo((Object)("B1 71 91 B3 50 94 B3 4E C9 03 E9 92 86 50 65 72" + System.lineSeparator() + "73 6F 6E 88 45 6D 70 6C 6F 79 65 65 A2 84 6E 61" + System.lineSeparator() + "6D 65 85 41 6C 69 63 65 83 61 67 65 21 B3 4E C9" + System.lineSeparator() + "03 EB 91 86 50 65 72 73 6F 6E A1 84 6E 61 6D 65" + System.lineSeparator() + "85 43 61 72 6F 6C B3 4E C9 03 EA 92 86 50 65 72" + System.lineSeparator() + "73 6F 6E 88 45 6D 70 6C 6F 79 65 65 A2 84 6E 61" + System.lineSeparator() + "6D 65 83 42 6F 62 83 61 67 65 2C B3 4E C9 03 EC" + System.lineSeparator() + "90 A1 84 6E 61 6D 65 84 44 61 76 65 94 B3 72 0D" + System.lineSeparator() + "85 4C 49 4B 45 53 A0 B3 72 20 88 44 49 53 4C 49" + System.lineSeparator() + "4B 45 53 A0 B3 72 0C 85 4B 4E 4F 57 53 A1 85 73" + System.lineSeparator() + "69 6E 63 65 C9 07 CF B3 72 22 8A 4D 41 52 52 49" + System.lineSeparator() + "45 44 5F 54 4F A0 9A 01 01 02 02 FD 00 01 01 04" + System.lineSeparator() + "03")));
        MatcherAssert.assertThat((Object)this.serialized((AnyValue)Paths.PATH_WITH_LOOP), (Matcher)Matchers.equalTo((Object)("B1 71 91 B3 50 92 B3 4E C9 03 EB 91 86 50 65 72" + System.lineSeparator() + "73 6F 6E A1 84 6E 61 6D 65 85 43 61 72 6F 6C B3" + System.lineSeparator() + "4E C9 03 EC 90 A1 84 6E 61 6D 65 84 44 61 76 65" + System.lineSeparator() + "92 B3 72 22 8A 4D 41 52 52 49 45 44 5F 54 4F A0" + System.lineSeparator() + "B3 72 2C 89 57 4F 52 4B 53 5F 46 4F 52 A0 94 01" + System.lineSeparator() + "01 02 01")));
    }

    private String serialized(AnyValue object) throws IOException {
        RecordMessage message = new RecordMessage(Records.record((AnyValue[])new AnyValue[]{object}));
        return HexPrinter.hex((byte[])MessageMatchers.serialize(this.neo4jPack, message), (int)4, (String)" ");
    }

    private void assertSerializes(ResponseMessage msg) throws IOException {
        MatcherAssert.assertThat((Object)this.serializeAndDeserialize(msg), (Matcher)Matchers.equalTo((Object)msg));
    }

    private <T extends ResponseMessage> T serializeAndDeserialize(T msg) throws IOException {
        RecordingByteChannel channel = new RecordingByteChannel();
        BoltResponseMessageReader reader = new BoltResponseMessageReader(this.neo4jPack.newUnpacker((PackInput)new BufferedChannelInput(16).reset(channel)));
        BufferedChannelOutput output = new BufferedChannelOutput(channel);
        BoltResponseMessageWriter writer = new BoltResponseMessageWriter(this.neo4jPack, (PackOutput)output, (LogService)NullLogService.getInstance(), (BoltMessageLogger)NullBoltMessageLogger.getInstance());
        msg.dispatch(writer);
        writer.flush();
        channel.eof();
        return this.unpack(reader, channel);
    }

    private <T extends ResponseMessage> T unpack(BoltResponseMessageReader reader, RecordingByteChannel channel) {
        String serialized = HexPrinter.hex((byte[])channel.getBytes());
        BoltResponseMessageRecorder messages = new BoltResponseMessageRecorder();
        try {
            reader.read(messages);
        }
        catch (Throwable e) {
            throw new AssertionError("Failed to unpack message, wire data was:\n" + serialized + "[" + channel.getBytes().length + "b]", e);
        }
        return (T)((ResponseMessage)messages.asList().get(0));
    }

    private void assertSerializesNeoValue(Object val) throws IOException {
        this.assertSerializes(new RecordMessage(Records.record((AnyValue[])new AnyValue[]{ValueUtils.of((Object)val)})));
    }
}

