/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageHandler;
import org.neo4j.bolt.v1.messaging.MessageProcessingHandler;
import org.neo4j.bolt.v1.packstream.PackOutputClosedException;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.test.matchers.CommonMatchers;
import org.neo4j.values.virtual.MapValue;

public class MessageProcessingHandlerTest {
    @Test
    public void shouldCallHaltOnUnexpectedFailures() throws Exception {
        BoltResponseMessageHandler<IOException> msgHandler = MessageProcessingHandlerTest.newResponseHandlerMock();
        ((BoltResponseMessageHandler)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Something went horribly wrong")}).when(msgHandler)).onSuccess((MapValue)ArgumentMatchers.any(MapValue.class));
        BoltConnection connection = (BoltConnection)Mockito.mock(BoltConnection.class);
        MessageProcessingHandler handler = new MessageProcessingHandler(msgHandler, connection, (Log)Mockito.mock(Log.class));
        handler.onFinish();
        ((BoltConnection)Mockito.verify((Object)connection)).stop();
    }

    @Test
    public void shouldLogOriginalErrorWhenOutputIsClosed() throws Exception {
        MessageProcessingHandlerTest.testLoggingOfOriginalErrorWhenOutputIsClosed(Neo4jError.from((Throwable)new RuntimeException("Non-fatal error")));
    }

    @Test
    public void shouldLogOriginalFatalErrorWhenOutputIsClosed() throws Exception {
        MessageProcessingHandlerTest.testLoggingOfOriginalErrorWhenOutputIsClosed(Neo4jError.fatalFrom((Throwable)new RuntimeException("Fatal error")));
    }

    @Test
    public void shouldLogWriteErrorAndOriginalErrorWhenUnknownFailure() throws Exception {
        MessageProcessingHandlerTest.testLoggingOfWriteErrorAndOriginalErrorWhenUnknownFailure(Neo4jError.from((Throwable)new RuntimeException("Non-fatal error")));
    }

    @Test
    public void shouldLogWriteErrorAndOriginalFatalErrorWhenUnknownFailure() throws Exception {
        MessageProcessingHandlerTest.testLoggingOfWriteErrorAndOriginalErrorWhenUnknownFailure(Neo4jError.fatalFrom((Throwable)new RuntimeException("Fatal error")));
    }

    @Test
    public void shouldLogShortWarningOnClientDisconnectMidwayThroughQuery() throws Exception {
        PackOutputClosedException outputClosed = new PackOutputClosedException("Output closed", "<client>");
        Neo4jError txTerminated = Neo4jError.from((Throwable)new TransactionTerminatedException((Status)Status.Transaction.Terminated));
        AssertableLogProvider logProvider = MessageProcessingHandlerTest.emulateFailureWritingError(txTerminated, (Throwable)outputClosed);
        logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog((String)"Test").warn(Matchers.equalTo((Object)"Client %s disconnected while query was running. Session has been cleaned up. This can be caused by temporary network problems, but if you see this often, ensure your applications are properly waiting for operations to complete before exiting."), new Object[]{Matchers.equalTo((Object)"<client>")})});
    }

    private static void testLoggingOfOriginalErrorWhenOutputIsClosed(Neo4jError original) throws Exception {
        PackOutputClosedException outputClosed = new PackOutputClosedException("Output closed", "<client>");
        AssertableLogProvider logProvider = MessageProcessingHandlerTest.emulateFailureWritingError(original, (Throwable)outputClosed);
        logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog((String)"Test").warn(Matchers.startsWith((String)"Unable to send error back to the client"), Matchers.equalTo((Object)original.cause()))});
    }

    private static void testLoggingOfWriteErrorAndOriginalErrorWhenUnknownFailure(Neo4jError original) throws Exception {
        RuntimeException outputError = new RuntimeException("Output failed");
        AssertableLogProvider logProvider = MessageProcessingHandlerTest.emulateFailureWritingError(original, outputError);
        logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog((String)"Test").error(Matchers.startsWith((String)"Unable to send error back to the client"), (Matcher)Matchers.both((Matcher)Matchers.equalTo((Object)outputError)).and(CommonMatchers.hasSuppressed((Throwable[])new Throwable[]{original.cause()})))});
    }

    private static AssertableLogProvider emulateFailureWritingError(Neo4jError error, Throwable errorDuringWrite) throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        BoltResponseMessageHandler<IOException> responseHandler = MessageProcessingHandlerTest.newResponseHandlerMock(error.isFatal(), errorDuringWrite);
        MessageProcessingHandler handler = new MessageProcessingHandler(responseHandler, (BoltConnection)Mockito.mock(BoltConnection.class), logProvider.getLog("Test"));
        handler.markFailed(error);
        handler.onFinish();
        return logProvider;
    }

    private static BoltResponseMessageHandler<IOException> newResponseHandlerMock(boolean fatalError, Throwable error) throws Exception {
        BoltResponseMessageHandler<IOException> handler = MessageProcessingHandlerTest.newResponseHandlerMock();
        if (fatalError) {
            ((BoltResponseMessageHandler)Mockito.doThrow((Throwable[])new Throwable[]{error}).when(handler)).onFatal((Status)ArgumentMatchers.any(Status.class), ArgumentMatchers.anyString());
        } else {
            ((BoltResponseMessageHandler)Mockito.doThrow((Throwable[])new Throwable[]{error}).when(handler)).onFailure((Status)ArgumentMatchers.any(Status.class), ArgumentMatchers.anyString());
        }
        return handler;
    }

    private static BoltResponseMessageHandler<IOException> newResponseHandlerMock() {
        return (BoltResponseMessageHandler)Mockito.mock(BoltResponseMessageHandler.class);
    }
}

