/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.bolt.v1.messaging.BoltIOException;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.Neo4jPackV1;
import org.neo4j.bolt.v1.messaging.example.Edges;
import org.neo4j.bolt.v1.messaging.example.Nodes;
import org.neo4j.bolt.v1.messaging.example.Paths;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.packstream.PackedInputArray;
import org.neo4j.bolt.v1.packstream.PackedOutputArray;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.UTF8StringValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.VirtualValues;

public class Neo4jPackV1Test {
    private final Neo4jPackV1 neo4jPack = new Neo4jPackV1();

    private byte[] packed(AnyValue object) throws IOException {
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)output);
        packer.pack(object);
        return output.bytes();
    }

    private AnyValue unpacked(byte[] bytes) throws IOException {
        PackedInputArray input = new PackedInputArray(bytes);
        Neo4jPack.Unpacker unpacker = this.neo4jPack.newUnpacker((PackInput)input);
        return unpacker.unpack();
    }

    @Test
    public void shouldBeAbleToPackAndUnpackList() throws IOException {
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)output);
        packer.packListHeader(Nodes.ALICE.labels().length());
        ArrayList<String> expected = new ArrayList<String>();
        TextArray labels = Nodes.ALICE.labels();
        for (int i = 0; i < labels.length(); ++i) {
            String labelName = labels.stringValue(i);
            packer.pack(labelName);
            expected.add(labelName);
        }
        AnyValue unpacked = this.unpacked(output.bytes());
        Assert.assertThat((Object)unpacked, (Matcher)CoreMatchers.instanceOf(ListValue.class));
        ListValue unpackedList = (ListValue)unpacked;
        Assert.assertThat((Object)unpackedList, (Matcher)CoreMatchers.equalTo((Object)ValueUtils.asListValue(expected)));
    }

    @Test
    public void shouldBeAbleToPackAndUnpackMap() throws IOException {
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)output);
        packer.packMapHeader(Nodes.ALICE.properties().size());
        Nodes.ALICE.properties().foreach((s, value) -> {
            try {
                packer.pack(s);
                packer.pack(value);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        AnyValue unpacked = this.unpacked(output.bytes());
        Assert.assertThat((Object)unpacked, (Matcher)CoreMatchers.instanceOf(MapValue.class));
        MapValue unpackedMap = (MapValue)unpacked;
        Assert.assertThat((Object)unpackedMap, (Matcher)CoreMatchers.equalTo((Object)Nodes.ALICE.properties()));
    }

    @Test
    public void shouldFailWhenTryingToPackAndUnpackMapContainingNullKeys() throws IOException {
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)output);
        HashMap<String, LongValue> map = new HashMap<String, LongValue>();
        map.put(null, Values.longValue((long)42L));
        map.put("foo", Values.longValue((long)1337L));
        packer.packMapHeader(map.size());
        for (Map.Entry entry : map.entrySet()) {
            packer.pack((String)entry.getKey());
            packer.pack((AnyValue)entry.getValue());
        }
        try {
            PackedInputArray input = new PackedInputArray(output.bytes());
            Neo4jPack.Unpacker unpacker = this.neo4jPack.newUnpacker((PackInput)input);
            unpacker.unpack();
            Assert.fail((String)"exception expected");
        }
        catch (BoltIOException ex) {
            Assert.assertEquals((Object)Neo4jError.from((Status)Status.Request.Invalid, (String)"Value `null` is not supported as key in maps, must be a non-nullable string."), (Object)Neo4jError.from((Throwable)ex));
        }
    }

    @Test
    public void shouldThrowOnUnpackingMapWithDuplicateKeys() throws IOException {
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)output);
        packer.packMapHeader(2);
        packer.pack("key");
        packer.pack((AnyValue)Values.intValue((int)1));
        packer.pack("key");
        packer.pack((AnyValue)Values.intValue((int)2));
        try {
            PackedInputArray input = new PackedInputArray(output.bytes());
            Neo4jPack.Unpacker unpacker = this.neo4jPack.newUnpacker((PackInput)input);
            unpacker.unpack();
            Assert.fail((String)"exception expected");
        }
        catch (BoltIOException ex) {
            Assert.assertEquals((Object)Neo4jError.from((Status)Status.Request.Invalid, (String)"Duplicate map key `key`."), (Object)Neo4jError.from((Throwable)ex));
        }
    }

    @Test
    public void shouldThrowOnUnpackingMapWithUnsupportedKeyType() throws IOException {
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)output);
        packer.packMapHeader(2);
        packer.pack(ValueUtils.of((Object)1L));
        packer.pack((AnyValue)Values.intValue((int)1));
        try {
            PackedInputArray input = new PackedInputArray(output.bytes());
            Neo4jPack.Unpacker unpacker = this.neo4jPack.newUnpacker((PackInput)input);
            unpacker.unpack();
            Assert.fail((String)"exception expected");
        }
        catch (BoltIOException ex) {
            Assert.assertEquals((Object)Neo4jError.from((Status)Status.Request.InvalidFormat, (String)"Bad key type: INTEGER"), (Object)Neo4jError.from((Throwable)ex));
        }
    }

    @Test
    public void shouldNotBeAbleToUnpackNode() throws IOException {
        try {
            this.unpacked(this.packed((AnyValue)Nodes.ALICE));
            Assert.fail((String)"exception expected.");
        }
        catch (BoltIOException ex) {
            Assert.assertEquals((Object)Neo4jError.from((Status)Status.Statement.TypeError, (String)"Node values cannot be unpacked with this version of bolt."), (Object)Neo4jError.from((Throwable)ex));
        }
    }

    @Test
    public void shouldNotBeAbleToUnpackRelationship() throws IOException {
        try {
            this.unpacked(this.packed((AnyValue)Edges.ALICE_KNOWS_BOB));
            Assert.fail((String)"exception expected.");
        }
        catch (BoltIOException ex) {
            Assert.assertEquals((Object)Neo4jError.from((Status)Status.Statement.TypeError, (String)"Relationship values cannot be unpacked with this version of bolt."), (Object)Neo4jError.from((Throwable)ex));
        }
    }

    @Test
    public void shouldNotBeAbleToUnpackUnboundRelationship() throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)out);
        packer.packStructHeader(3, (byte)114);
        packer.pack(ValueUtils.of((Object)1L));
        packer.pack(ValueUtils.of((Object)"RELATES_TO"));
        packer.pack((AnyValue)ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"a", 1L, "b", "x"})));
        try {
            this.unpacked(out.bytes());
            Assert.fail((String)"exception expected.");
        }
        catch (BoltIOException ex) {
            Assert.assertEquals((Object)Neo4jError.from((Status)Status.Statement.TypeError, (String)"Relationship values cannot be unpacked with this version of bolt."), (Object)Neo4jError.from((Throwable)ex));
        }
    }

    @Test
    public void shouldNotBeAbleToUnpackPaths() throws IOException {
        for (PathValue path : Paths.ALL_PATHS) {
            try {
                this.unpacked(this.packed((AnyValue)path));
                Assert.fail((String)"exception expected.");
            }
            catch (BoltIOException ex) {
                Assert.assertEquals((Object)Neo4jError.from((Status)Status.Statement.TypeError, (String)"Path values cannot be unpacked with this version of bolt."), (Object)Neo4jError.from((Throwable)ex));
            }
        }
    }

    @Test
    public void shouldTreatSingleCharAsSingleCharacterString() throws IOException {
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)output);
        packer.pack((AnyValue)Values.charValue((char)'C'));
        AnyValue unpacked = this.unpacked(output.bytes());
        Assert.assertThat((Object)unpacked, (Matcher)CoreMatchers.instanceOf(TextValue.class));
        Assert.assertThat((Object)unpacked, (Matcher)CoreMatchers.equalTo((Object)Values.stringValue((String)"C")));
    }

    @Test
    public void shouldTreatCharArrayAsListOfStrings() throws IOException {
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)output);
        packer.pack((AnyValue)Values.charArray((char[])new char[]{'W', 'H', 'Y'}));
        AnyValue unpacked = this.unpacked(output.bytes());
        Assert.assertThat((Object)unpacked, (Matcher)CoreMatchers.instanceOf(ListValue.class));
        Assert.assertThat((Object)unpacked, (Matcher)CoreMatchers.equalTo((Object)VirtualValues.list((AnyValue[])new AnyValue[]{Values.stringValue((String)"W"), Values.stringValue((String)"H"), Values.stringValue((String)"Y")})));
    }

    @Test
    public void shouldPackUtf8() throws IOException {
        String value = "\ud83d\ude31";
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        TextValue textValue = Values.utf8Value((byte[])bytes, (int)0, (int)bytes.length);
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)output);
        packer.pack((AnyValue)textValue);
        AnyValue unpacked = this.unpacked(output.bytes());
        Assert.assertThat((Object)unpacked, (Matcher)Matchers.is((Matcher)CoreMatchers.instanceOf(UTF8StringValue.class)));
        Assert.assertThat((Object)unpacked, (Matcher)CoreMatchers.equalTo((Object)textValue));
    }
}

