/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class RecordingByteChannel
implements WritableByteChannel,
ReadableByteChannel {
    private final ByteBuffer buffer = ByteBuffer.allocate(65536);
    private int writePosition;
    private int readPosition;
    private boolean eof;

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public int write(ByteBuffer src) {
        this.buffer.position(this.writePosition);
        int originalPosition = this.writePosition;
        this.buffer.put(src);
        this.writePosition = this.buffer.position();
        return this.writePosition - originalPosition;
    }

    @Override
    public int read(ByteBuffer dst) {
        if (this.readPosition == this.writePosition) {
            return this.eof ? -1 : 0;
        }
        this.buffer.position(this.readPosition);
        int originalPosition = this.readPosition;
        int originalLimit = this.buffer.limit();
        this.buffer.limit(Math.min(this.buffer.position() + (dst.limit() - dst.position()), this.writePosition));
        dst.put(this.buffer);
        this.readPosition = this.buffer.position();
        this.buffer.limit(originalLimit);
        return this.readPosition - originalPosition;
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[this.buffer.position()];
        this.buffer.position(0);
        this.buffer.get(bytes);
        return bytes;
    }

    public void eof() {
        this.eof = true;
    }
}

