/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.message;

import org.neo4j.bolt.v1.messaging.BoltResponseMessageHandler;
import org.neo4j.bolt.v1.messaging.message.ResponseMessage;
import org.neo4j.kernel.api.exceptions.Status;

public class FailureMessage
implements ResponseMessage {
    private final Status status;
    private final String message;

    public FailureMessage(Status status, String message) {
        this.status = status;
        this.message = message;
    }

    public Status status() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    @Override
    public <E extends Exception> void dispatch(BoltResponseMessageHandler<E> consumer) throws E {
        consumer.onFailure(this.status, this.message);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FailureMessage)) {
            return false;
        }
        FailureMessage that = (FailureMessage)o;
        return (this.message != null ? this.message.equals(that.message) : that.message == null) && (this.status != null ? this.status.equals(that.status) : that.status == null);
    }

    public int hashCode() {
        int result = this.status != null ? this.status.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "FailureMessage{status=" + this.status + ", message='" + this.message + '\'' + '}';
    }
}

