/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.message;

import org.neo4j.bolt.v1.messaging.BoltRequestMessageHandler;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public class RunMessage
implements RequestMessage {
    private static final MapValue EMPTY_PARAMETERS = VirtualValues.EMPTY_MAP;
    private final String statement;
    private final MapValue params;

    public static RunMessage run(String statement, MapValue parameters) {
        return new RunMessage(statement, parameters);
    }

    public static RunMessage run(String statement) {
        return RunMessage.run(statement, EMPTY_PARAMETERS);
    }

    private RunMessage(String statement, MapValue params) {
        this.statement = statement;
        this.params = params;
    }

    public MapValue params() {
        return this.params;
    }

    public String statement() {
        return this.statement;
    }

    @Override
    public void dispatch(BoltRequestMessageHandler consumer) {
        consumer.onRun(this.statement, this.params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunMessage that = (RunMessage)o;
        return this.params.equals((VirtualValue)that.params) && this.statement.equals(that.statement);
    }

    public int hashCode() {
        int result = this.statement.hashCode();
        result = 31 * result + this.params.hashCode();
        return result;
    }

    public String toString() {
        return "RunMessage{statement='" + this.statement + '\'' + ", params=" + this.params + '}';
    }
}

