/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.bolt.logging.NullBoltMessageLogger;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageWriter;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageReader;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageRecorder;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.RecordingByteChannel;
import org.neo4j.bolt.v1.messaging.message.FailureMessage;
import org.neo4j.bolt.v1.messaging.message.IgnoredMessage;
import org.neo4j.bolt.v1.messaging.message.RecordMessage;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.messaging.message.ResponseMessage;
import org.neo4j.bolt.v1.messaging.message.SuccessMessage;
import org.neo4j.bolt.v1.messaging.util.ArrayByteChannel;
import org.neo4j.bolt.v1.packstream.BufferedChannelInput;
import org.neo4j.bolt.v1.packstream.BufferedChannelOutput;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.transport.integration.TestNotification;
import org.neo4j.cypher.result.QueryResult;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.util.BaseToObjectValueWriter;
import org.neo4j.kernel.impl.util.HexPrinter;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.virtual.MapValue;

public class MessageMatchers {
    private MessageMatchers() {
    }

    private static Map<String, Object> toRawMap(MapValue mapValue) {
        Deserializer deserializer = new Deserializer();
        HashMap<String, Object> map = new HashMap<String, Object>(mapValue.size());
        for (Map.Entry entry : mapValue.entrySet()) {
            ((AnyValue)entry.getValue()).writeTo((AnyValueWriter)deserializer);
            map.put((String)entry.getKey(), deserializer.value());
        }
        return map;
    }

    public static Matcher<List<ResponseMessage>> equalsMessages(final Matcher<ResponseMessage> ... messageMatchers) {
        return new TypeSafeMatcher<List<ResponseMessage>>(){

            protected boolean matchesSafely(List<ResponseMessage> messages) {
                if (messageMatchers.length != messages.size()) {
                    return false;
                }
                for (int i = 0; i < messageMatchers.length; ++i) {
                    if (messageMatchers[i].matches((Object)messages.get(i))) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendList("MessageList[", ", ", "]", Arrays.asList(messageMatchers));
            }
        };
    }

    public static Matcher<ResponseMessage> hasNotification(final Notification notification) {
        return new TypeSafeMatcher<ResponseMessage>(){

            protected boolean matchesSafely(ResponseMessage t) {
                Assert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(SuccessMessage.class));
                Map meta = MessageMatchers.toRawMap(((SuccessMessage)t).meta());
                Assert.assertThat((Object)meta.containsKey("notifications"), (Matcher)Is.is((Object)true));
                Set notifications = ((List)meta.get("notifications")).stream().map(TestNotification::fromMap).collect(Collectors.toSet());
                Assert.assertThat(notifications, (Matcher)Matchers.contains((Object[])new Notification[]{notification}));
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("SUCCESS");
            }
        };
    }

    public static Matcher<ResponseMessage> msgSuccess(final Map<String, Object> metadata) {
        return new TypeSafeMatcher<ResponseMessage>(){

            protected boolean matchesSafely(ResponseMessage t) {
                Assert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(SuccessMessage.class));
                Assert.assertThat((Object)MessageMatchers.toRawMap(((SuccessMessage)t).meta()), (Matcher)CoreMatchers.equalTo((Object)metadata));
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("SUCCESS");
            }
        };
    }

    public static Matcher<ResponseMessage> msgSuccess(final Matcher<Map<String, ?>> matcher) {
        return new TypeSafeMatcher<ResponseMessage>(){

            protected boolean matchesSafely(ResponseMessage t) {
                Assert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(SuccessMessage.class));
                Map actual = MessageMatchers.toRawMap(((SuccessMessage)t).meta());
                Assert.assertThat((Object)actual, (Matcher)matcher);
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("SUCCESS");
            }
        };
    }

    public static Matcher<ResponseMessage> msgSuccess() {
        return new TypeSafeMatcher<ResponseMessage>(){

            protected boolean matchesSafely(ResponseMessage t) {
                Assert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(SuccessMessage.class));
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("SUCCESS");
            }
        };
    }

    public static Matcher<ResponseMessage> msgIgnored() {
        return new TypeSafeMatcher<ResponseMessage>(){

            protected boolean matchesSafely(ResponseMessage t) {
                Assert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(IgnoredMessage.class));
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("IGNORED");
            }
        };
    }

    public static Matcher<ResponseMessage> msgFailure(final Status status, final String message) {
        return new TypeSafeMatcher<ResponseMessage>(){

            protected boolean matchesSafely(ResponseMessage t) {
                Assert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(FailureMessage.class));
                FailureMessage msg = (FailureMessage)t;
                Assert.assertThat((Object)msg.status(), (Matcher)CoreMatchers.equalTo((Object)status));
                Assert.assertThat((Object)msg.message(), (Matcher)CoreMatchers.containsString((String)message));
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("FAILURE");
            }
        };
    }

    public static Matcher<ResponseMessage> msgRecord(final Matcher<QueryResult.Record> matcher) {
        return new TypeSafeMatcher<ResponseMessage>(){

            protected boolean matchesSafely(ResponseMessage t) {
                Assert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(RecordMessage.class));
                RecordMessage msg = (RecordMessage)t;
                Assert.assertThat((Object)msg.record(), (Matcher)matcher);
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("RECORD ");
                description.appendDescriptionOf((SelfDescribing)matcher);
            }
        };
    }

    public static byte[] serialize(Neo4jPack neo4jPack, RequestMessage ... messages) throws IOException {
        RecordingByteChannel rawData = new RecordingByteChannel();
        Neo4jPack.Packer packer = neo4jPack.newPacker((PackOutput)new BufferedChannelOutput(rawData));
        BoltRequestMessageWriter writer = new BoltRequestMessageWriter(packer);
        for (RequestMessage message : messages) {
            writer.write(message);
        }
        writer.flush();
        return rawData.getBytes();
    }

    public static byte[] serialize(Neo4jPack neo4jPack, ResponseMessage ... messages) throws IOException {
        RecordingByteChannel rawData = new RecordingByteChannel();
        BufferedChannelOutput output = new BufferedChannelOutput(rawData);
        BoltResponseMessageWriter writer = new BoltResponseMessageWriter(neo4jPack, (PackOutput)output, (LogService)NullLogService.getInstance(), (BoltMessageLogger)NullBoltMessageLogger.getInstance());
        for (ResponseMessage message : messages) {
            message.dispatch(writer);
        }
        writer.flush();
        return rawData.getBytes();
    }

    public static ResponseMessage responseMessage(Neo4jPack neo4jPack, byte[] bytes) throws IOException {
        BoltResponseMessageReader unpacker = MessageMatchers.responseReader(neo4jPack, bytes);
        BoltResponseMessageRecorder consumer = new BoltResponseMessageRecorder();
        try {
            unpacker.read(consumer);
            return (ResponseMessage)consumer.asList().get(0);
        }
        catch (Throwable e) {
            throw new IOException("Failed to deserialize response, '" + e.getMessage() + "'.\nRaw data: \n" + HexPrinter.hex((byte[])bytes), e);
        }
    }

    private static BoltResponseMessageReader responseReader(Neo4jPack neo4jPack, byte[] bytes) {
        BufferedChannelInput input = new BufferedChannelInput(128);
        input.reset(new ArrayByteChannel(bytes));
        return new BoltResponseMessageReader(neo4jPack.newUnpacker((PackInput)input));
    }

    private static class Deserializer
    extends BaseToObjectValueWriter<RuntimeException> {
        private Deserializer() {
        }

        protected Node newNodeProxyById(long id) {
            return null;
        }

        protected Relationship newRelationshipProxyById(long id) {
            return null;
        }

        protected Point newPoint(CoordinateReferenceSystem crs, double[] coordinate) {
            return null;
        }
    }
}

