/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.packstream.utf8;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.bolt.v1.packstream.utf8.UTF8Encoder;

public class UTF8EncoderTest {
    @Test
    public void shouldEncodeDecode() {
        this.assertEncodes("");
        this.assertEncodes("a");
        this.assertEncodes("\u00e4");
        this.assertEncodes("\u00e4a");
        this.assertEncodes("\u57fa\u672c\u4e0a\uff0c\u96fb\u8166\u53ea\u662f\u8655\u7406\u6578\u4f4d\u3002\u5b83\u5011\u6307\u5b9a\u4e00\u500b\u6578\u4f4d\uff0c\u4f86\u5132\u5b58\u5b57\u6bcd\u6216\u5176\u4ed6\u5b57\u5143\u3002\u5728\u5275\u9020Unicode\u4e4b\u524d\uff0c\u6709\u6578\u767e\u7a2e\u6307\u5b9a\u9019\u4e9b\u6578\u4f4d\u7684\u7de8\u78bc\u7cfb\u7d71\u3002\u6c92\u6709\u4e00\u500b\u7de8\u78bc\u53ef\u4ee5\u5305\u542b\u8db3\u5920\u7684\u5b57\u5143\uff0c\u4f8b\u5982\uff1a\u55ae\u55ae\u6b50\u6d32\u5171\u540c\u9ad4\u5c31\u9700\u8981\u597d\u5e7e\u7a2e\u4e0d\u540c\u7684\u7de8\u78bc\u4f86\u5305\u62ec\u6240\u6709\u7684\u8a9e\u8a00\u3002\u5373\u4f7f\u662f\u55ae\u4e00\u7a2e\u8a9e\u8a00\uff0c\u4f8b\u5982\u82f1\u8a9e\uff0c\u4e5f\u6c92\u6709\u54ea\u4e00\u500b\u7de8\u78bc\u53ef\u4ee5\u9069\u7528\u65bc\u6240\u6709\u7684\u5b57\u6bcd\u3001\u6a19\u9ede\u7b26\u865f\uff0c\u548c\u5e38\u7528\u7684\u6280\u8853\u7b26\u865f");
        this.assertEncodes(new String(new byte[(int)Math.pow(2.0, 18.0)]));
    }

    private void assertEncodes(String val) {
        Assert.assertEquals((Object)val, (Object)this.encodeDecode(val));
    }

    private String encodeDecode(String original) {
        ByteBuffer encoded = UTF8Encoder.fastestAvailableEncoder().encode(original);
        byte[] b = new byte[encoded.remaining()];
        encoded.get(b);
        return new String(b, StandardCharsets.UTF_8);
    }
}

