/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.testing.BoltMatchers;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.v1.runtime.BoltConnectionAuthFatality;
import org.neo4j.bolt.v1.runtime.BoltConnectionFatality;
import org.neo4j.bolt.v1.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.BoltStateMachineSPI;
import org.neo4j.bolt.v1.runtime.MachineRoom;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.bolt.v1.runtime.TransactionStateMachine;
import org.neo4j.bolt.v1.runtime.spi.BoltResult;
import org.neo4j.function.ThrowingBiConsumer;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.security.AuthorizationExpiredException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.util.ValueUtils;

public class BoltStateMachineTest {
    @Test
    public void allStateTransitionsShouldSendExactlyOneResponseToTheClient() throws Exception {
        for (BoltStateMachine.State initialState : BoltStateMachine.State.values()) {
            BoltMatchers.verifyOneResponse(initialState, (ThrowingBiConsumer<BoltStateMachine, BoltResponseRecorder, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, recorder) -> machine.init("BoltStateMachineTest/0.0", Collections.emptyMap(), (BoltResponseHandler)recorder)));
            BoltMatchers.verifyOneResponse(initialState, (ThrowingBiConsumer<BoltStateMachine, BoltResponseRecorder, BoltConnectionFatality>)((ThrowingBiConsumer)BoltStateMachine::ackFailure));
            BoltMatchers.verifyOneResponse(initialState, (ThrowingBiConsumer<BoltStateMachine, BoltResponseRecorder, BoltConnectionFatality>)((ThrowingBiConsumer)BoltStateMachine::reset));
            BoltMatchers.verifyOneResponse(initialState, (ThrowingBiConsumer<BoltStateMachine, BoltResponseRecorder, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, recorder) -> machine.run("statement", MachineRoom.EMPTY_PARAMS, (BoltResponseHandler)recorder)));
            BoltMatchers.verifyOneResponse(initialState, (ThrowingBiConsumer<BoltStateMachine, BoltResponseRecorder, BoltConnectionFatality>)((ThrowingBiConsumer)BoltStateMachine::discardAll));
            BoltMatchers.verifyOneResponse(initialState, (ThrowingBiConsumer<BoltStateMachine, BoltResponseRecorder, BoltConnectionFatality>)((ThrowingBiConsumer)BoltStateMachine::pullAll));
        }
    }

    @Test
    public void initialStateShouldBeConnected() {
        MatcherAssert.assertThat((Object)MachineRoom.newMachine(), BoltMatchers.inState(BoltStateMachine.State.CONNECTED));
    }

    @Test
    public void shouldRollbackOpenTransactionOnReset() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachineWithTransaction(BoltStateMachine.State.READY);
        machine.state = BoltStateMachine.State.FAILED;
        machine.reset((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.hasNoTransaction());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(BoltStateMachine.State.READY));
    }

    @Test
    public void shouldRollbackOpenTransactionOnClose() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachineWithTransaction(BoltStateMachine.State.READY);
        machine.close();
        MatcherAssert.assertThat((Object)machine, BoltMatchers.hasNoTransaction());
    }

    @Test
    public void shouldPublishClientName() throws Throwable {
        ((BoltStateMachine.SPI)Mockito.verify((Object)MachineRoom.newMachine((BoltStateMachine.State)BoltStateMachine.State.READY).spi)).udcRegisterClient("BoltStateMachineTest/0.0");
    }

    @Test
    public void shouldBeAbleToResetWhenInReadyState() throws Throwable {
        MatcherAssert.assertThat((Object)MachineRoom.newMachine(BoltStateMachine.State.READY), BoltMatchers.canReset());
    }

    @Test
    public void shouldResetWithOpenTransaction() throws Throwable {
        MatcherAssert.assertThat((Object)MachineRoom.newMachineWithTransaction(BoltStateMachine.State.READY), BoltMatchers.canReset());
    }

    @Test
    public void shouldResetWithOpenTransactionAndOpenResult() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachineWithTransaction(BoltStateMachine.State.READY);
        machine.run("RETURN 1", MachineRoom.EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.canReset());
    }

    @Test
    public void shouldResetWithOpenResult() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachine(BoltStateMachine.State.READY);
        machine.run("RETURN 1", MachineRoom.EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.canReset());
    }

    @Test
    public void shouldResetWhenFailed() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachineWithTransaction(BoltStateMachine.State.READY);
        machine.state = BoltStateMachine.State.FAILED;
        MatcherAssert.assertThat((Object)machine, BoltMatchers.canReset());
    }

    @Test
    public void shouldFailWhenOutOfOrderRollback() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachine(BoltStateMachine.State.FAILED);
        machine.run("ROLLBACK", MachineRoom.EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(BoltStateMachine.State.FAILED));
    }

    @Test
    public void shouldGoBackToReadyAfterAckFailure() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachine(BoltStateMachine.State.FAILED);
        machine.ackFailure((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(BoltStateMachine.State.READY));
    }

    @Test
    public void shouldNotRollbackOpenTransactionOnAckFailure() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachineWithTransaction(BoltStateMachine.State.READY);
        machine.state = BoltStateMachine.State.FAILED;
        machine.ackFailure((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.hasTransaction());
    }

    @Test
    public void shouldRemainStoppedAfterInterrupted() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachine(BoltStateMachine.State.READY);
        machine.close();
        MatcherAssert.assertThat((Object)machine, BoltMatchers.isClosed());
        machine.interrupt();
        machine.reset((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.isClosed());
    }

    @Test
    public void shouldBeAbleToKillMessagesAheadInLineWithAnInterrupt() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachine(BoltStateMachine.State.READY);
        machine.interrupt();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.run("RETURN 1", MachineRoom.EMPTY_PARAMS, (BoltResponseHandler)recorder);
        machine.reset((BoltResponseHandler)recorder);
        machine.run("RETURN 1", MachineRoom.EMPTY_PARAMS, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.wasIgnored());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
    }

    @Test
    public void multipleInterruptsShouldBeMatchedWithMultipleResets() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachine(BoltStateMachine.State.READY);
        machine.interrupt();
        machine.interrupt();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.run("RETURN 1", MachineRoom.EMPTY_PARAMS, (BoltResponseHandler)recorder);
        machine.reset((BoltResponseHandler)recorder);
        machine.run("RETURN 1", MachineRoom.EMPTY_PARAMS, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.wasIgnored());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.wasIgnored());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.wasIgnored());
        recorder.reset();
        machine.reset((BoltResponseHandler)recorder);
        machine.run("RETURN 1", MachineRoom.EMPTY_PARAMS, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
    }

    @Test
    public void testPublishingError() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachine(BoltStateMachine.State.READY);
        machine.run("RETURN 1", null, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder(){

            @Override
            public void onRecords(BoltResult result, boolean pull) {
                throw new RuntimeException("I've been expecting you, Mr Bond.");
            }
        };
        machine.pullAll((BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.General.UnknownError));
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(BoltStateMachine.State.FAILED));
    }

    @Test
    public void testRollbackError() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachine(BoltStateMachine.State.READY);
        machine.run("BEGIN", MachineRoom.EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        TransactionStateMachine txMachine = (TransactionStateMachine)machine.ctx.statementProcessor;
        Mockito.when((Object)txMachine.ctx.currentTransaction.isOpen()).thenReturn((Object)true);
        ((KernelTransaction)Mockito.doThrow((Throwable[])new Throwable[]{new TransactionFailureException("No Mr. Bond, I expect you to die.")}).when((Object)txMachine.ctx.currentTransaction)).close();
        machine.run("ROLLBACK", MachineRoom.EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(BoltStateMachine.State.FAILED));
    }

    @Test
    public void testFailOnNestedTransactions() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachine(BoltStateMachine.State.READY);
        machine.run("BEGIN", MachineRoom.EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.run("BEGIN", MachineRoom.EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(BoltStateMachine.State.FAILED));
    }

    @Test
    public void testCantDoAnythingIfInFailedState() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachine(BoltStateMachine.State.FAILED);
        machine.run("RETURN 1", MachineRoom.EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(BoltStateMachine.State.FAILED));
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(BoltStateMachine.State.FAILED));
        machine.pullAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(BoltStateMachine.State.FAILED));
    }

    @Test
    public void testUsingResetToAcknowledgeError() throws Throwable {
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltStateMachine machine = MachineRoom.newMachine(BoltStateMachine.State.FAILED);
        machine.reset((BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        machine.run("RETURN 1", MachineRoom.EMPTY_PARAMS, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
    }

    @Test
    public void actionsDisallowedBeforeInitialized() {
        BoltStateMachine machine = MachineRoom.newMachine();
        try {
            machine.run("RETURN 1", null, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
            Assert.fail((String)"Failed to fail fatally");
        }
        catch (BoltConnectionFatality boltConnectionFatality) {
            // empty catch block
        }
    }

    @Test
    public void shouldTerminateOnAuthExpiryDuringREADYRun() throws Throwable {
        TransactionStateMachine.SPI transactionSPI = (TransactionStateMachine.SPI)Mockito.mock(TransactionStateMachine.SPI.class);
        ((TransactionStateMachine.SPI)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationExpiredException("Auth expired!")}).when((Object)transactionSPI)).beginTransaction((LoginContext)ArgumentMatchers.any());
        BoltStateMachine machine = MachineRoom.newMachineWithTransactionSPI(transactionSPI);
        machine.state = BoltStateMachine.State.READY;
        org.neo4j.test.assertion.Assert.assertException(() -> machine.run("THIS WILL BE IGNORED", MachineRoom.EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler()), BoltConnectionAuthFatality.class, (String)"Auth expired!");
    }

    @Test
    public void shouldTerminateOnAuthExpiryDuringSTREAMINGPullAll() throws Throwable {
        BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
        ((BoltResponseHandler)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationExpiredException("Auth expired!")}).when((Object)responseHandler)).onRecords((BoltResult)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        BoltStateMachine machine = MachineRoom.newMachine(BoltStateMachine.State.STREAMING);
        ((TransactionStateMachine)machine.statementProcessor()).ctx.currentResult = BoltResult.EMPTY;
        org.neo4j.test.assertion.Assert.assertException(() -> machine.pullAll(responseHandler), BoltConnectionAuthFatality.class, (String)"Auth expired!");
    }

    @Test
    public void shouldTerminateOnAuthExpiryDuringSTREAMINGDiscardAll() throws Throwable {
        BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
        ((BoltResponseHandler)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationExpiredException("Auth expired!")}).when((Object)responseHandler)).onRecords((BoltResult)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        BoltStateMachine machine = MachineRoom.newMachine(BoltStateMachine.State.STREAMING);
        ((TransactionStateMachine)machine.statementProcessor()).ctx.currentResult = BoltResult.EMPTY;
        org.neo4j.test.assertion.Assert.assertException(() -> machine.discardAll(responseHandler), BoltConnectionAuthFatality.class, (String)"Auth expired!");
    }

    @Test
    public void callResetEvenThoughAlreadyClosed() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachine(BoltStateMachine.State.READY);
        TransactionStateMachine statementProcessor = (TransactionStateMachine)machine.statementProcessor();
        machine.close();
        MatcherAssert.assertThat((Object)statementProcessor.ctx.currentTransaction, (Matcher)CoreMatchers.nullValue());
        Assert.assertTrue((boolean)machine.ctx.closed);
        statementProcessor.run("RETURN 1", MachineRoom.EMPTY_PARAMS);
        MatcherAssert.assertThat((Object)statementProcessor.ctx.currentTransaction, (Matcher)CoreMatchers.notNullValue());
        machine.close();
        MatcherAssert.assertThat((Object)statementProcessor.ctx.currentTransaction, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldCallOnTerminateWhenClosing() {
        BoltStateMachineSPI spi = (BoltStateMachineSPI)Mockito.mock(BoltStateMachineSPI.class, (Answer)Mockito.RETURNS_MOCKS);
        BoltChannel boltChannel = (BoltChannel)Mockito.mock(BoltChannel.class);
        BoltStateMachine machine = new BoltStateMachine((BoltStateMachine.SPI)spi, boltChannel, Clock.systemUTC(), (LogService)NullLogService.getInstance());
        machine.close();
        ((BoltStateMachineSPI)Mockito.verify((Object)spi)).onTerminate(machine);
    }

    @Test
    public void shouldCloseBoltChannelWhenClosed() {
        BoltStateMachineSPI spi = (BoltStateMachineSPI)Mockito.mock(BoltStateMachineSPI.class);
        BoltChannel boltChannel = (BoltChannel)Mockito.mock(BoltChannel.class);
        BoltStateMachine machine = new BoltStateMachine((BoltStateMachine.SPI)spi, boltChannel, Clock.systemUTC(), (LogService)NullLogService.getInstance());
        machine.close();
        ((BoltChannel)Mockito.verify((Object)boltChannel)).close();
    }

    @Test
    public void shouldSetPendingErrorOnMarkFailedIfNoHandler() {
        BoltStateMachineSPI spi = (BoltStateMachineSPI)Mockito.mock(BoltStateMachineSPI.class);
        BoltChannel boltChannel = (BoltChannel)Mockito.mock(BoltChannel.class);
        BoltStateMachine machine = new BoltStateMachine((BoltStateMachine.SPI)spi, boltChannel, Clock.systemUTC(), (LogService)NullLogService.getInstance());
        Neo4jError error = Neo4jError.from((Status)Status.Request.NoThreadsAvailable, (String)"no threads");
        machine.markFailed(error);
        Assert.assertEquals((Object)error, (Object)machine.ctx.pendingError);
        Assert.assertEquals((Object)BoltStateMachine.State.FAILED, (Object)machine.state);
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextInitMessageOnMarkFailedIfNoHandler() throws Exception {
        BoltStateMachineTest.testMarkFailedOnNextMessage((ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, handler) -> machine.init("Test/1.0", Collections.emptyMap(), handler)));
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextRunMessageOnMarkFailedIfNoHandler() throws Exception {
        BoltStateMachineTest.testMarkFailedOnNextMessage((ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, handler) -> machine.run("RETURN 1", ValueUtils.asMapValue(Collections.emptyMap()), handler)));
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextPullAllMessageOnMarkFailedIfNoHandler() throws Exception {
        BoltStateMachineTest.testMarkFailedOnNextMessage((ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, handler) -> machine.pullAll(handler)));
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextDiscardAllMessageOnMarkFailedIfNoHandler() throws Exception {
        BoltStateMachineTest.testMarkFailedOnNextMessage((ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, handler) -> machine.discardAll(handler)));
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextResetMessageOnMarkFailedIfNoHandler() throws Exception {
        BoltStateMachineTest.testMarkFailedOnNextMessage((ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, handler) -> machine.reset(handler)));
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextAckFailureMessageOnMarkFailedIfNoHandler() throws Exception {
        BoltStateMachineTest.testMarkFailedOnNextMessage((ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, handler) -> machine.ackFailure(handler)));
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextExternalErrorMessageOnMarkFailedIfNoHandler() throws Exception {
        BoltStateMachineTest.testMarkFailedOnNextMessage((ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, handler) -> machine.externalError(Neo4jError.from((Status)Status.Request.Invalid, (String)"invalid"), handler)));
    }

    @Test
    public void shouldInvokeResponseHandlerOnMarkFailedIfThereIsHandler() {
        BoltStateMachineSPI spi = (BoltStateMachineSPI)Mockito.mock(BoltStateMachineSPI.class);
        BoltChannel boltChannel = (BoltChannel)Mockito.mock(BoltChannel.class);
        BoltStateMachine machine = new BoltStateMachine((BoltStateMachine.SPI)spi, boltChannel, Clock.systemUTC(), (LogService)NullLogService.getInstance());
        Neo4jError error = Neo4jError.from((Status)Status.Request.NoThreadsAvailable, (String)"no threads");
        machine.ctx.responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
        machine.markFailed(error);
        Assert.assertNull((Object)machine.ctx.pendingError);
        Assert.assertEquals((Object)BoltStateMachine.State.FAILED, (Object)machine.state);
        ((BoltResponseHandler)Mockito.verify((Object)machine.ctx.responseHandler)).markFailed(error);
    }

    private static void testMarkFailedOnNextMessage(ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality> action) throws Exception {
        BoltStateMachineSPI spi = (BoltStateMachineSPI)Mockito.mock(BoltStateMachineSPI.class);
        BoltChannel boltChannel = (BoltChannel)Mockito.mock(BoltChannel.class);
        BoltStateMachine machine = new BoltStateMachine((BoltStateMachine.SPI)spi, boltChannel, Clock.systemUTC(), (LogService)NullLogService.getInstance());
        BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
        Neo4jError error = Neo4jError.from((Status)Status.Request.NoThreadsAvailable, (String)"no threads");
        machine.markFailed(error);
        action.accept((Object)machine, (Object)responseHandler);
        Assert.assertEquals((Object)BoltStateMachine.State.FAILED, (Object)machine.state);
        ((BoltResponseHandler)Mockito.verify((Object)responseHandler)).markFailed(error);
    }
}

