/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.v1.runtime.CypherAdapterStream;
import org.neo4j.bolt.v1.runtime.spi.BoltResult;
import org.neo4j.cypher.result.QueryResult;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.impl.notification.NotificationCode;
import org.neo4j.graphdb.impl.notification.NotificationDetail;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public class CypherAdapterStreamTest {
    @Test
    public void shouldIncludeBasicMetadata() throws Throwable {
        QueryStatistics queryStatistics = (QueryStatistics)Mockito.mock(QueryStatistics.class);
        Mockito.when((Object)queryStatistics.containsUpdates()).thenReturn((Object)true);
        Mockito.when((Object)queryStatistics.getNodesCreated()).thenReturn((Object)1);
        Mockito.when((Object)queryStatistics.getNodesDeleted()).thenReturn((Object)2);
        Mockito.when((Object)queryStatistics.getRelationshipsCreated()).thenReturn((Object)3);
        Mockito.when((Object)queryStatistics.getRelationshipsDeleted()).thenReturn((Object)4);
        Mockito.when((Object)queryStatistics.getPropertiesSet()).thenReturn((Object)5);
        Mockito.when((Object)queryStatistics.getIndexesAdded()).thenReturn((Object)6);
        Mockito.when((Object)queryStatistics.getIndexesRemoved()).thenReturn((Object)7);
        Mockito.when((Object)queryStatistics.getConstraintsAdded()).thenReturn((Object)8);
        Mockito.when((Object)queryStatistics.getConstraintsRemoved()).thenReturn((Object)9);
        Mockito.when((Object)queryStatistics.getLabelsAdded()).thenReturn((Object)10);
        Mockito.when((Object)queryStatistics.getLabelsRemoved()).thenReturn((Object)11);
        QueryResult result = (QueryResult)Mockito.mock(QueryResult.class);
        Mockito.when((Object)result.fieldNames()).thenReturn((Object)new String[0]);
        Mockito.when((Object)result.executionType()).thenReturn((Object)QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE));
        Mockito.when((Object)result.queryStatistics()).thenReturn((Object)queryStatistics);
        Mockito.when((Object)result.getNotifications()).thenReturn(Collections.emptyList());
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)clock.millis()).thenReturn((Object)0L, (Object[])new Long[]{1337L});
        TransactionalContext tc = (TransactionalContext)Mockito.mock(TransactionalContext.class);
        CypherAdapterStream stream = new CypherAdapterStream(result, clock);
        MapValue meta = this.metadataOf(stream);
        MatcherAssert.assertThat((Object)meta.get("type"), (Matcher)CoreMatchers.equalTo((Object)Values.stringValue((String)"rw")));
        MatcherAssert.assertThat((Object)meta.get("stats"), (Matcher)CoreMatchers.equalTo((Object)VirtualValues.map(this.mapValues("nodes-created", Values.intValue((int)1), "nodes-deleted", Values.intValue((int)2), "relationships-created", Values.intValue((int)3), "relationships-deleted", Values.intValue((int)4), "properties-set", Values.intValue((int)5), "indexes-added", Values.intValue((int)6), "indexes-removed", Values.intValue((int)7), "constraints-added", Values.intValue((int)8), "constraints-removed", Values.intValue((int)9), "labels-added", Values.intValue((int)10), "labels-removed", Values.intValue((int)11)))));
        MatcherAssert.assertThat((Object)meta.get("result_consumed_after"), (Matcher)CoreMatchers.equalTo((Object)Values.longValue((long)1337L)));
    }

    @Test
    public void shouldIncludePlanIfPresent() throws Throwable {
        QueryStatistics queryStatistics = (QueryStatistics)Mockito.mock(QueryStatistics.class);
        Mockito.when((Object)queryStatistics.containsUpdates()).thenReturn((Object)false);
        QueryResult result = (QueryResult)Mockito.mock(QueryResult.class);
        Mockito.when((Object)result.fieldNames()).thenReturn((Object)new String[0]);
        Mockito.when((Object)result.executionType()).thenReturn((Object)QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_ONLY));
        Mockito.when((Object)result.queryStatistics()).thenReturn((Object)queryStatistics);
        Mockito.when((Object)result.getNotifications()).thenReturn(Collections.emptyList());
        Mockito.when((Object)result.executionPlanDescription()).thenReturn((Object)CypherAdapterStreamTest.plan("Join", (Map<String, Object>)MapUtil.map((Object[])new Object[]{"arg1", 1}), Collections.singletonList("id1"), CypherAdapterStreamTest.plan("Scan", (Map<String, Object>)MapUtil.map((Object[])new Object[]{"arg2", 1}), Collections.singletonList("id2"), new ExecutionPlanDescription[0])));
        TransactionalContext tc = (TransactionalContext)Mockito.mock(TransactionalContext.class);
        CypherAdapterStream stream = new CypherAdapterStream(result, Clock.systemUTC());
        MapValue meta = this.metadataOf(stream);
        Map<String, AnyValue> expectedChild = this.mapValues("args", VirtualValues.map(this.mapValues("arg2", Values.intValue((int)1))), "identifiers", VirtualValues.list((AnyValue[])new AnyValue[]{Values.stringValue((String)"id2")}), "operatorType", Values.stringValue((String)"Scan"), "children", VirtualValues.EMPTY_LIST);
        Map<String, AnyValue> expectedPlan = this.mapValues("args", VirtualValues.map(this.mapValues("arg1", Values.intValue((int)1))), "identifiers", VirtualValues.list((AnyValue[])new AnyValue[]{Values.stringValue((String)"id1")}), "operatorType", Values.stringValue((String)"Join"), "children", VirtualValues.list((AnyValue[])new AnyValue[]{VirtualValues.map(expectedChild)}));
        MatcherAssert.assertThat((Object)meta.get("plan"), (Matcher)CoreMatchers.equalTo((Object)VirtualValues.map(expectedPlan)));
    }

    @Test
    public void shouldIncludeProfileIfPresent() throws Throwable {
        QueryStatistics queryStatistics = (QueryStatistics)Mockito.mock(QueryStatistics.class);
        Mockito.when((Object)queryStatistics.containsUpdates()).thenReturn((Object)false);
        QueryResult result = (QueryResult)Mockito.mock(QueryResult.class);
        Mockito.when((Object)result.fieldNames()).thenReturn((Object)new String[0]);
        Mockito.when((Object)result.executionType()).thenReturn((Object)QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_ONLY));
        Mockito.when((Object)result.queryStatistics()).thenReturn((Object)queryStatistics);
        Mockito.when((Object)result.getNotifications()).thenReturn(Collections.emptyList());
        Mockito.when((Object)result.executionPlanDescription()).thenReturn((Object)CypherAdapterStreamTest.plan("Join", (Map<String, Object>)MapUtil.map((Object[])new Object[]{"arg1", 1}), 2L, 4L, 3L, 1L, Collections.singletonList("id1"), CypherAdapterStreamTest.plan("Scan", (Map<String, Object>)MapUtil.map((Object[])new Object[]{"arg2", 1}), 2L, 4L, 7L, 1L, Collections.singletonList("id2"), new ExecutionPlanDescription[0])));
        TransactionalContext tc = (TransactionalContext)Mockito.mock(TransactionalContext.class);
        CypherAdapterStream stream = new CypherAdapterStream(result, Clock.systemUTC());
        MapValue meta = this.metadataOf(stream);
        Map<String, AnyValue> expectedChild = this.mapValues("args", VirtualValues.map(this.mapValues("arg2", Values.intValue((int)1))), "identifiers", VirtualValues.list((AnyValue[])new AnyValue[]{Values.stringValue((String)"id2")}), "operatorType", Values.stringValue((String)"Scan"), "children", VirtualValues.EMPTY_LIST, "rows", Values.longValue((long)1L), "dbHits", Values.longValue((long)2L), "pageCacheHits", Values.longValue((long)4L), "pageCacheMisses", Values.longValue((long)7L), "pageCacheHitRatio", Values.doubleValue((double)0.36363636363636365));
        Map<String, AnyValue> expectedProfile = this.mapValues("args", VirtualValues.map(this.mapValues("arg1", Values.intValue((int)1))), "identifiers", VirtualValues.list((AnyValue[])new AnyValue[]{Values.stringValue((String)"id1")}), "operatorType", Values.stringValue((String)"Join"), "children", VirtualValues.list((AnyValue[])new AnyValue[]{VirtualValues.map(expectedChild)}), "rows", Values.longValue((long)1L), "dbHits", Values.longValue((long)2L), "pageCacheHits", Values.longValue((long)4L), "pageCacheMisses", Values.longValue((long)3L), "pageCacheHitRatio", Values.doubleValue((double)0.5714285714285714));
        CypherAdapterStreamTest.assertMapEqualsWithDelta((MapValue)meta.get("profile"), VirtualValues.map(expectedProfile), 1.0E-4);
    }

    private Map<String, AnyValue> mapValues(Object ... values) {
        return MapUtil.genericMap((Object[])values);
    }

    @Test
    public void shouldIncludeNotificationsIfPresent() throws Throwable {
        QueryResult result = (QueryResult)Mockito.mock(QueryResult.class);
        Mockito.when((Object)result.fieldNames()).thenReturn((Object)new String[0]);
        QueryStatistics queryStatistics = (QueryStatistics)Mockito.mock(QueryStatistics.class);
        Mockito.when((Object)queryStatistics.containsUpdates()).thenReturn((Object)false);
        Mockito.when((Object)result.queryStatistics()).thenReturn((Object)queryStatistics);
        Mockito.when((Object)result.executionType()).thenReturn((Object)QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE));
        Mockito.when((Object)result.getNotifications()).thenReturn(Arrays.asList(NotificationCode.INDEX_HINT_UNFULFILLABLE.notification(InputPosition.empty, new NotificationDetail[0]), NotificationCode.PLANNER_UNSUPPORTED.notification(new InputPosition(4, 5, 6), new NotificationDetail[0])));
        TransactionalContext tc = (TransactionalContext)Mockito.mock(TransactionalContext.class);
        CypherAdapterStream stream = new CypherAdapterStream(result, Clock.systemUTC());
        MapValue meta = this.metadataOf(stream);
        Map<String, AnyValue> msg1 = this.mapValues("severity", Values.stringValue((String)"WARNING"), "code", Values.stringValue((String)"Neo.ClientError.Schema.IndexNotFound"), "title", Values.stringValue((String)"The request (directly or indirectly) referred to an index that does not exist."), "description", Values.stringValue((String)"The hinted index does not exist, please check the schema"));
        Map<String, AnyValue> msg2 = this.mapValues("severity", Values.stringValue((String)"WARNING"), "code", Values.stringValue((String)"Neo.ClientNotification.Statement.PlannerUnsupportedWarning"), "title", Values.stringValue((String)"This query is not supported by the COST planner."), "description", Values.stringValue((String)"Using COST planner is unsupported for this query, please use RULE planner instead"), "position", VirtualValues.map(this.mapValues("offset", Values.intValue((int)4), "column", Values.intValue((int)6), "line", Values.intValue((int)5))));
        MatcherAssert.assertThat((Object)meta.get("notifications"), (Matcher)CoreMatchers.equalTo((Object)VirtualValues.list((AnyValue[])new AnyValue[]{VirtualValues.map(msg1), VirtualValues.map(msg2)})));
    }

    private MapValue metadataOf(CypherAdapterStream stream) throws Exception {
        final HashMap meta = new HashMap();
        stream.accept(new BoltResult.Visitor(){

            public void visit(QueryResult.Record record) {
            }

            public void addMetadata(String key, AnyValue value) {
                meta.put(key, value);
            }
        });
        return VirtualValues.map(meta);
    }

    private static void assertMapEqualsWithDelta(MapValue a, MapValue b, double delta) {
        MatcherAssert.assertThat((String)"Map should have same size", (Object)a.size(), (Matcher)CoreMatchers.equalTo((Object)b.size()));
        for (Map.Entry entry : a.entrySet()) {
            String key = (String)entry.getKey();
            AnyValue aValue = (AnyValue)entry.getValue();
            AnyValue bValue = b.get(key);
            if (aValue instanceof MapValue) {
                MatcherAssert.assertThat((String)"Value mismatch", (boolean)(bValue instanceof MapValue));
                CypherAdapterStreamTest.assertMapEqualsWithDelta((MapValue)aValue, (MapValue)bValue, delta);
                continue;
            }
            if (aValue instanceof DoubleValue) {
                MatcherAssert.assertThat((String)"Value mismatch", (Object)((DoubleValue)aValue).doubleValue(), (Matcher)Matchers.closeTo((double)((DoubleValue)bValue).doubleValue(), (double)delta));
                continue;
            }
            MatcherAssert.assertThat((String)"Value mismatch", (Object)aValue, (Matcher)CoreMatchers.equalTo((Object)bValue));
        }
    }

    private static ExecutionPlanDescription plan(String name, Map<String, Object> args, final long dbHits, final long pageCacheHits, final long pageCacheMisses, final long rows, List<String> identifiers, ExecutionPlanDescription ... children) {
        return CypherAdapterStreamTest.plan(name, args, identifiers, new ExecutionPlanDescription.ProfilerStatistics(){

            public long getRows() {
                return rows;
            }

            public long getDbHits() {
                return dbHits;
            }

            public long getPageCacheHits() {
                return pageCacheHits;
            }

            public long getPageCacheMisses() {
                return pageCacheMisses;
            }
        }, children);
    }

    private static ExecutionPlanDescription plan(String name, Map<String, Object> args, List<String> identifiers, ExecutionPlanDescription ... children) {
        return CypherAdapterStreamTest.plan(name, args, identifiers, null, children);
    }

    private static ExecutionPlanDescription plan(final String name, final Map<String, Object> args, final List<String> identifiers, final ExecutionPlanDescription.ProfilerStatistics profile, final ExecutionPlanDescription ... children) {
        return new ExecutionPlanDescription(){

            public String getName() {
                return name;
            }

            public List<ExecutionPlanDescription> getChildren() {
                return Arrays.asList(children);
            }

            public Map<String, Object> getArguments() {
                return args;
            }

            public Set<String> getIdentifiers() {
                return new HashSet<String>(identifiers);
            }

            public boolean hasProfilerStatistics() {
                return profile != null;
            }

            public ExecutionPlanDescription.ProfilerStatistics getProfilerStatistics() {
                return profile;
            }
        };
    }
}

