/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.MatcherAssert;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.testing.BoltMatchers;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.v1.runtime.BoltConnectionFatality;
import org.neo4j.bolt.v1.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.BoltStateMachineSPI;
import org.neo4j.bolt.v1.runtime.TransactionStateMachine;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public class MachineRoom {
    static final MapValue EMPTY_PARAMS = VirtualValues.EMPTY_MAP;
    static final String USER_AGENT = "BoltStateMachineTest/0.0";

    private MachineRoom() {
    }

    public static BoltStateMachine newMachine() {
        BoltChannel boltChannel = (BoltChannel)Mockito.mock(BoltChannel.class);
        return new BoltStateMachine((BoltStateMachine.SPI)Mockito.mock(BoltStateMachineSPI.class, (Answer)Mockito.RETURNS_MOCKS), boltChannel, Clock.systemUTC(), (LogService)NullLogService.getInstance());
    }

    public static BoltStateMachine newMachine(BoltStateMachine.State state) throws AuthenticationException, BoltConnectionFatality {
        BoltStateMachine machine = MachineRoom.newMachine();
        MachineRoom.init(machine);
        machine.state = state;
        return machine;
    }

    public static BoltStateMachine newMachineWithOwner(BoltStateMachine.State state, String owner) throws AuthenticationException, BoltConnectionFatality {
        BoltStateMachine machine = MachineRoom.newMachine();
        MachineRoom.init(machine, owner);
        machine.state = state;
        return machine;
    }

    public static BoltStateMachine newMachineWithTransaction(BoltStateMachine.State state) throws AuthenticationException, BoltConnectionFatality {
        BoltStateMachine machine = MachineRoom.newMachine();
        MachineRoom.init(machine);
        MachineRoom.runBegin(machine);
        machine.state = state;
        return machine;
    }

    public static BoltStateMachine newMachineWithTransactionSPI(TransactionStateMachine.SPI transactionSPI) throws AuthenticationException, BoltConnectionFatality {
        BoltStateMachine.SPI spi = (BoltStateMachine.SPI)Mockito.mock(BoltStateMachine.SPI.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)spi.transactionSpi()).thenReturn((Object)transactionSPI);
        BoltChannel boltChannel = (BoltChannel)Mockito.mock(BoltChannel.class);
        BoltStateMachine machine = new BoltStateMachine(spi, boltChannel, Clock.systemUTC(), (LogService)NullLogService.getInstance());
        MachineRoom.init(machine);
        return machine;
    }

    private static void init(BoltStateMachine machine) throws AuthenticationException, BoltConnectionFatality {
        MachineRoom.init(machine, null);
    }

    private static void init(BoltStateMachine machine, String owner) throws AuthenticationException, BoltConnectionFatality {
        AuthenticationResult authenticationResult = (AuthenticationResult)Mockito.mock(AuthenticationResult.class);
        Mockito.when((Object)machine.spi.authenticate((Map)ArgumentMatchers.any())).thenReturn((Object)authenticationResult);
        machine.init(USER_AGENT, owner == null ? Collections.emptyMap() : Collections.singletonMap("principal", owner), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
    }

    private static void runBegin(BoltStateMachine machine) throws BoltConnectionFatality {
        machine.run("BEGIN", EMPTY_PARAMS, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.hasTransaction());
    }
}

