/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.api.exceptions.Status;

public class Neo4jErrorTest {
    @Test
    public void shouldAssignUnknownStatusToUnpredictedException() {
        Throwable cause = new Throwable("This is not an error we know how to handle.");
        Neo4jError error = Neo4jError.from((Throwable)cause);
        MatcherAssert.assertThat((Object)error.status(), (Matcher)CoreMatchers.equalTo((Object)Status.General.UnknownError));
    }

    @Test
    public void shouldConvertDeadlockException() {
        Neo4jError error = Neo4jError.from((Throwable)new DeadlockDetectedException(null));
        Assert.assertEquals((Object)Status.Transaction.DeadlockDetected, (Object)error.status());
    }

    @Test
    public void shouldSetStatusToDatabaseUnavailableOnDatabaseShutdownException() {
        DatabaseShutdownException ex = new DatabaseShutdownException();
        Neo4jError error = Neo4jError.from((Throwable)ex);
        MatcherAssert.assertThat((Object)error.status(), (Matcher)CoreMatchers.equalTo((Object)Status.General.DatabaseUnavailable));
        MatcherAssert.assertThat((Object)error.cause(), (Matcher)CoreMatchers.equalTo((Object)ex));
    }

    @Test
    public void shouldCombineErrors() {
        Neo4jError error1 = Neo4jError.from((Throwable)new DeadlockDetectedException("In my life"));
        Neo4jError error2 = Neo4jError.from((Throwable)new DeadlockDetectedException("Why do I give valuable time"));
        Neo4jError error3 = Neo4jError.from((Throwable)new DeadlockDetectedException("To people who don't care if I live or die?"));
        Neo4jError combine = Neo4jError.combine(Arrays.asList(error1, error2, error3));
        MatcherAssert.assertThat((Object)combine.status(), (Matcher)CoreMatchers.equalTo((Object)Status.Transaction.DeadlockDetected));
        MatcherAssert.assertThat((Object)combine.message(), (Matcher)CoreMatchers.equalTo((Object)String.format("The following errors has occurred:%n%nIn my life%nWhy do I give valuable time%nTo people who don't care if I live or die?", new Object[0])));
    }

    @Test
    public void shouldCombineSingleErrorToItself() {
        Neo4jError error = Neo4jError.from((Status)Status.Request.Invalid, (String)"Really bad request");
        Neo4jError combinedError = Neo4jError.combine(Collections.singletonList(error));
        Assert.assertEquals((Object)error, (Object)combinedError);
    }

    @Test
    public void shouldCombineNoErrorsToNull() {
        Assert.assertNull((Object)Neo4jError.combine(Collections.emptyList()));
    }

    @Test
    public void shouldBeUnknownIfCombiningDifferentStatus() {
        Neo4jError error1 = Neo4jError.from((Status)Status.General.DatabaseUnavailable, (String)"foo");
        Neo4jError error2 = Neo4jError.from((Status)Status.Request.Invalid, (String)"bar");
        Neo4jError error3 = Neo4jError.from((Status)Status.Schema.ConstraintAlreadyExists, (String)"baz");
        Neo4jError combine = Neo4jError.combine(Arrays.asList(error1, error2, error3));
        MatcherAssert.assertThat((Object)combine.status(), (Matcher)CoreMatchers.equalTo((Object)Status.General.UnknownError));
    }
}

