/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.io.IOException;
import java.time.Clock;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.BoltConnectionDescriptor;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.bolt.logging.NullBoltMessageLogger;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.BoltSchedulerProvider;
import org.neo4j.bolt.runtime.CachedThreadPoolExecutorFactory;
import org.neo4j.bolt.runtime.DefaultBoltConnectionFactory;
import org.neo4j.bolt.runtime.ExecutorBoltSchedulerProvider;
import org.neo4j.bolt.runtime.ExecutorFactory;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.testing.RecordedBoltResponse;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.bolt.v1.messaging.BoltMessageRouter;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageHandler;
import org.neo4j.bolt.v1.messaging.BoltResponseMessage;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageHandler;
import org.neo4j.bolt.v1.messaging.message.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.message.PullAllMessage;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.bolt.v1.runtime.TransactionStateMachine;
import org.neo4j.cypher.result.QueryResult;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.scheduler.CentralJobScheduler;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.values.virtual.MapValue;

public class ResetFuzzTest {
    private static final String CONNECTOR = "bolt";
    private final int seed = new Random().nextInt();
    private final Random rand = new Random(this.seed);
    private final LifeSupport life = new LifeSupport();
    private final AtomicLong liveTransactions = new AtomicLong();
    private final Monitors monitors = new Monitors();
    private final CentralJobScheduler scheduler = (CentralJobScheduler)this.life.add((Lifecycle)new CentralJobScheduler());
    private final BoltSchedulerProvider boltSchedulerProvider = (BoltSchedulerProvider)this.life.add((Lifecycle)new ExecutorBoltSchedulerProvider(ResetFuzzTest.createConfig(), (ExecutorFactory)new CachedThreadPoolExecutorFactory((Log)NullLog.getInstance()), (JobScheduler)this.scheduler, (LogService)NullLogService.getInstance()));
    private final Clock clock = Clock.systemUTC();
    private final BoltStateMachine machine = new BoltStateMachine((BoltStateMachine.SPI)new FuzzStubSPI(), (BoltChannel)Mockito.mock(BoltChannel.class), this.clock, (LogService)NullLogService.getInstance());
    private final BoltConnectionFactory connectionFactory = new DefaultBoltConnectionFactory((boltChannel, clock) -> this.machine, this.boltSchedulerProvider, TransportThrottleGroup.NO_THROTTLE, (LogService)NullLogService.getInstance(), this.clock, null, this.monitors);
    private BoltChannel boltChannel;
    private final List<List<RequestMessage>> sequences = Arrays.asList(Arrays.asList(RunMessage.run("test", this.map(new Object[0])), DiscardAllMessage.discardAll()), Arrays.asList(RunMessage.run("test", this.map(new Object[0])), PullAllMessage.pullAll()), Collections.singletonList(RunMessage.run("test", this.map(new Object[0]))));
    private final List<RequestMessage> sent = new LinkedList<RequestMessage>();

    @Before
    public void setup() {
        this.boltChannel = (BoltChannel)Mockito.mock(BoltChannel.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)this.boltChannel.id()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)this.boltChannel.connector()).thenReturn((Object)CONNECTOR);
    }

    @Test
    public void shouldAlwaysReturnToReadyAfterReset() throws Throwable {
        this.life.start();
        BoltConnection boltConnection = this.connectionFactory.newConnection(this.boltChannel);
        boltConnection.enqueue(session -> session.init("ResetFuzzTest/0.0", Collections.emptyMap(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler()));
        NullBoltMessageLogger boltLogger = NullBoltMessageLogger.getInstance();
        BoltMessageRouter router = new BoltMessageRouter((Log)NullLog.getInstance(), (BoltMessageLogger)boltLogger, boltConnection, (BoltResponseMessageHandler)new BoltResponseMessageHandler<IOException>(){

            public void onRecord(QueryResult.Record item) {
            }

            public void onIgnored() {
            }

            public void onFailure(Status status, String errorMessage) {
            }

            public void onSuccess(MapValue metadata) {
            }
        });
        long deadline = System.currentTimeMillis() + 2000L;
        while (System.currentTimeMillis() < deadline) {
            this.dispatchRandomSequenceOfMessages(router);
            this.assertSchedulerWorks(boltConnection);
        }
    }

    private void assertSchedulerWorks(BoltConnection connection) throws InterruptedException {
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        connection.enqueue(machine -> machine.reset((BoltResponseHandler)recorder));
        try {
            RecordedBoltResponse response = recorder.nextResponse();
            MatcherAssert.assertThat((Object)response.message(), (Matcher)CoreMatchers.equalTo((Object)BoltResponseMessage.SUCCESS));
            MatcherAssert.assertThat((Object)this.machine.state(), (Matcher)CoreMatchers.equalTo((Object)BoltStateMachine.State.READY));
            MatcherAssert.assertThat((Object)this.liveTransactions.get(), (Matcher)CoreMatchers.equalTo((Object)0L));
        }
        catch (AssertionError e) {
            throw new AssertionError(String.format("Expected session to return to good state after RESET, but assertion failed: %s.%nSeed: %s%nMessages sent:%n%s", ((Throwable)((Object)e)).getMessage(), this.seed, Iterables.toString(this.sent, (String)"\n")), (Throwable)((Object)e));
        }
    }

    private void dispatchRandomSequenceOfMessages(BoltMessageRouter messageHandler) {
        List<RequestMessage> sequence = this.sequences.get(this.rand.nextInt(this.sequences.size()));
        for (RequestMessage message : sequence) {
            this.sent.add(message);
            message.dispatch((BoltRequestMessageHandler)messageHandler);
        }
    }

    private MapValue map(Object ... keyValues) {
        return ValueUtils.asMapValue((Map)MapUtil.map((Object[])keyValues));
    }

    @After
    public void cleanup() {
        this.life.shutdown();
    }

    private static Config createConfig() {
        HashMap<String, String> configProps = new HashMap<String, String>();
        configProps.put(new BoltConnector((String)CONNECTOR).enabled.name(), "TRUE");
        configProps.put(new BoltConnector((String)CONNECTOR).listen_address.name(), "localhost:0");
        configProps.put(new BoltConnector((String)CONNECTOR).type.name(), Connector.ConnectorType.BOLT.name());
        configProps.put(new BoltConnector((String)CONNECTOR).thread_pool_min_size.name(), "5");
        configProps.put(new BoltConnector((String)CONNECTOR).thread_pool_max_size.name(), "10");
        return Config.fromSettings(configProps).build();
    }

    private class FuzzStubSPI
    implements BoltStateMachine.SPI {
        private FuzzStubSPI() {
        }

        public BoltConnectionDescriptor connectionDescriptor() {
            return ResetFuzzTest.this.boltChannel;
        }

        public void register(BoltStateMachine machine, String owner) {
        }

        public TransactionStateMachine.SPI transactionSpi() {
            return null;
        }

        public void onTerminate(BoltStateMachine machine) {
        }

        public void reportError(Neo4jError err) {
        }

        public AuthenticationResult authenticate(Map<String, Object> authToken) {
            return AuthenticationResult.AUTH_DISABLED;
        }

        public void udcRegisterClient(String clientName) {
        }

        public String version() {
            return "<test-version>";
        }
    }
}

