/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.v1.runtime.TransactionStateMachineSPI;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.test.rule.concurrent.OtherThreadRule;
import org.neo4j.time.FakeClock;

public class TransactionStateMachineSPITest {
    @Rule
    public final OtherThreadRule<Void> otherThread = new OtherThreadRule();

    @Test
    public void throwsWhenTxAwaitDurationExpires() {
        long lastClosedTransactionId = 100L;
        Supplier<TransactionIdStore> txIdStore = () -> TransactionStateMachineSPITest.fixedTxIdStore(lastClosedTransactionId);
        Duration txAwaitDuration = Duration.ofSeconds(42L);
        FakeClock clock = new FakeClock();
        AvailabilityGuard availabilityGuard = (AvailabilityGuard)Mockito.spy((Object)new AvailabilityGuard((Clock)clock, (Log)NullLog.getInstance()));
        Mockito.when((Object)availabilityGuard.isAvailable()).then(invocation -> {
            boolean available = (Boolean)invocation.callRealMethod();
            clock.forward(txAwaitDuration.getSeconds() + 1L, TimeUnit.SECONDS);
            return available;
        });
        TransactionStateMachineSPI txSpi = TransactionStateMachineSPITest.createTxSpi(txIdStore, txAwaitDuration, availabilityGuard, (Clock)clock);
        Future result = this.otherThread.execute(state -> {
            txSpi.awaitUpToDate(lastClosedTransactionId + 42L);
            return null;
        });
        try {
            result.get(20L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(ExecutionException.class));
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(TransactionFailureException.class));
        }
    }

    @Test
    public void doesNotWaitWhenTxIdUpToDate() throws Exception {
        long lastClosedTransactionId = 100L;
        Supplier<TransactionIdStore> txIdStore = () -> TransactionStateMachineSPITest.fixedTxIdStore(lastClosedTransactionId);
        TransactionStateMachineSPI txSpi = TransactionStateMachineSPITest.createTxSpi(txIdStore, Duration.ZERO, Clock.systemUTC());
        Future result = this.otherThread.execute(state -> {
            txSpi.awaitUpToDate(lastClosedTransactionId - 42L);
            return null;
        });
        Assert.assertNull(result.get(20L, TimeUnit.SECONDS));
    }

    private static TransactionIdStore fixedTxIdStore(long lastClosedTransactionId) {
        TransactionIdStore txIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)txIdStore.getLastClosedTransactionId()).thenReturn((Object)lastClosedTransactionId);
        return txIdStore;
    }

    private static TransactionStateMachineSPI createTxSpi(Supplier<TransactionIdStore> txIdStore, Duration txAwaitDuration, Clock clock) {
        AvailabilityGuard availabilityGuard = new AvailabilityGuard(clock, (Log)NullLog.getInstance());
        return TransactionStateMachineSPITest.createTxSpi(txIdStore, txAwaitDuration, availabilityGuard, clock);
    }

    private static TransactionStateMachineSPI createTxSpi(Supplier<TransactionIdStore> txIdStore, Duration txAwaitDuration, AvailabilityGuard availabilityGuard, Clock clock) {
        GraphDatabaseQueryService queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        DependencyResolver dependencyResolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        GraphDatabaseAPI db = (GraphDatabaseAPI)Mockito.mock(GraphDatabaseAPI.class);
        Mockito.when((Object)queryService.getDependencyResolver()).thenReturn((Object)dependencyResolver);
        Mockito.when((Object)db.getDependencyResolver()).thenReturn((Object)dependencyResolver);
        Mockito.when((Object)dependencyResolver.provideDependency(TransactionIdStore.class)).thenReturn(txIdStore);
        return new TransactionStateMachineSPI(db, new ThreadToStatementContextBridge(), (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class), availabilityGuard, queryService, txAwaitDuration, clock);
    }
}

