/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.v1.runtime.BoltQuerySource;
import org.neo4j.bolt.v1.runtime.TransactionStateMachine;
import org.neo4j.bolt.v1.runtime.TransactionStateMachineSPI;
import org.neo4j.bolt.v1.runtime.spi.BoltResult;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.time.FakeClock;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public class TransactionStateMachineTest {
    private TransactionStateMachineSPI stateMachineSPI;
    private TransactionStateMachine.MutableTransactionState mutableState;
    private TransactionStateMachine stateMachine;

    @Before
    public void createMocks() {
        this.stateMachineSPI = (TransactionStateMachineSPI)Mockito.mock(TransactionStateMachineSPI.class);
        this.mutableState = (TransactionStateMachine.MutableTransactionState)Mockito.mock(TransactionStateMachine.MutableTransactionState.class);
        this.stateMachine = new TransactionStateMachine((TransactionStateMachine.SPI)this.stateMachineSPI, AuthenticationResult.AUTH_DISABLED, (Clock)new FakeClock());
    }

    @Test
    public void shouldTransitionToExplicitTransactionOnBegin() throws Exception {
        Assert.assertEquals((Object)TransactionStateMachine.State.AUTO_COMMIT.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "begin", VirtualValues.EMPTY_MAP), (Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION);
        Assert.assertEquals((Object)TransactionStateMachine.State.AUTO_COMMIT.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "BEGIN", VirtualValues.EMPTY_MAP), (Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION);
        Assert.assertEquals((Object)TransactionStateMachine.State.AUTO_COMMIT.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "   begin   ", VirtualValues.EMPTY_MAP), (Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION);
        Assert.assertEquals((Object)TransactionStateMachine.State.AUTO_COMMIT.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "   BeGiN ;   ", VirtualValues.EMPTY_MAP), (Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION);
    }

    @Test
    public void shouldTransitionToAutoCommitOnCommit() throws Exception {
        Assert.assertEquals((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "commit", VirtualValues.EMPTY_MAP), (Object)TransactionStateMachine.State.AUTO_COMMIT);
        Assert.assertEquals((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "COMMIT", VirtualValues.EMPTY_MAP), (Object)TransactionStateMachine.State.AUTO_COMMIT);
        Assert.assertEquals((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "   commit   ", VirtualValues.EMPTY_MAP), (Object)TransactionStateMachine.State.AUTO_COMMIT);
        Assert.assertEquals((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "   CoMmIt ;   ", VirtualValues.EMPTY_MAP), (Object)TransactionStateMachine.State.AUTO_COMMIT);
    }

    @Test
    public void shouldTransitionToAutoCommitOnRollback() throws Exception {
        Assert.assertEquals((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "rollback", VirtualValues.EMPTY_MAP), (Object)TransactionStateMachine.State.AUTO_COMMIT);
        Assert.assertEquals((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "ROLLBACK", VirtualValues.EMPTY_MAP), (Object)TransactionStateMachine.State.AUTO_COMMIT);
        Assert.assertEquals((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "   rollback   ", VirtualValues.EMPTY_MAP), (Object)TransactionStateMachine.State.AUTO_COMMIT);
        Assert.assertEquals((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "   RoLlBaCk ;   ", VirtualValues.EMPTY_MAP), (Object)TransactionStateMachine.State.AUTO_COMMIT);
    }

    @Test
    public void shouldThrowOnBeginInExplicitTransaction() throws Exception {
        try {
            TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "begin", VirtualValues.EMPTY_MAP);
        }
        catch (QueryExecutionKernelException ex) {
            Assert.assertEquals((Object)"Nested transactions are not supported.", (Object)ex.getMessage());
        }
        try {
            TransactionStateMachine.State.EXPLICIT_TRANSACTION.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, " BEGIN ", VirtualValues.EMPTY_MAP);
        }
        catch (QueryExecutionKernelException ex) {
            Assert.assertEquals((Object)"Nested transactions are not supported.", (Object)ex.getMessage());
        }
    }

    @Test
    public void shouldThrowOnRollbackInAutoCommit() throws Exception {
        try {
            TransactionStateMachine.State.AUTO_COMMIT.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "rollback", VirtualValues.EMPTY_MAP);
        }
        catch (QueryExecutionKernelException ex) {
            Assert.assertEquals((Object)"No current transaction to rollback.", (Object)ex.getMessage());
        }
        try {
            TransactionStateMachine.State.AUTO_COMMIT.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, " ROLLBACK ", VirtualValues.EMPTY_MAP);
        }
        catch (QueryExecutionKernelException ex) {
            Assert.assertEquals((Object)"No current transaction to rollback.", (Object)ex.getMessage());
        }
    }

    @Test
    public void shouldThrowOnCommitInAutoCommit() throws Exception {
        try {
            TransactionStateMachine.State.AUTO_COMMIT.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, "commit", VirtualValues.EMPTY_MAP);
        }
        catch (QueryExecutionKernelException ex) {
            Assert.assertEquals((Object)"No current transaction to commit.", (Object)ex.getMessage());
        }
        try {
            TransactionStateMachine.State.AUTO_COMMIT.run(this.mutableState, (TransactionStateMachine.SPI)this.stateMachineSPI, " COMMIT ", VirtualValues.EMPTY_MAP);
        }
        catch (QueryExecutionKernelException ex) {
            Assert.assertEquals((Object)"No current transaction to commit.", (Object)ex.getMessage());
        }
    }

    @Test
    public void shouldNotWaitWhenNoBookmarkSupplied() throws Exception {
        this.stateMachine.run("BEGIN", VirtualValues.EMPTY_MAP);
        ((TransactionStateMachineSPI)Mockito.verify((Object)this.stateMachineSPI, (VerificationMode)Mockito.never())).awaitUpToDate(ArgumentMatchers.anyLong());
    }

    @Test
    public void shouldAwaitSingleBookmark() throws Exception {
        this.stateMachine.run("BEGIN", this.map("bookmark", "neo4j:bookmark:v1:tx15"));
        ((TransactionStateMachineSPI)Mockito.verify((Object)this.stateMachineSPI)).awaitUpToDate(15L);
    }

    @Test
    public void shouldAwaitMultipleBookmarks() throws Exception {
        MapValue params = this.map("bookmarks", Arrays.asList("neo4j:bookmark:v1:tx15", "neo4j:bookmark:v1:tx5", "neo4j:bookmark:v1:tx92", "neo4j:bookmark:v1:tx9"));
        this.stateMachine.run("BEGIN", params);
        ((TransactionStateMachineSPI)Mockito.verify((Object)this.stateMachineSPI)).awaitUpToDate(92L);
    }

    @Test
    public void shouldAwaitMultipleBookmarksWhenBothSingleAndMultipleSupplied() throws Exception {
        MapValue params = this.map("bookmark", "neo4j:bookmark:v1:tx42", "bookmarks", Arrays.asList("neo4j:bookmark:v1:tx47", "neo4j:bookmark:v1:tx67", "neo4j:bookmark:v1:tx45"));
        this.stateMachine.run("BEGIN", params);
        ((TransactionStateMachineSPI)Mockito.verify((Object)this.stateMachineSPI)).awaitUpToDate(67L);
    }

    @Test
    public void shouldStartWithAutoCommitState() {
        TransactionStateMachineSPI stateMachineSPI = (TransactionStateMachineSPI)Mockito.mock(TransactionStateMachineSPI.class);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.AUTO_COMMIT));
        Assert.assertNull((Object)stateMachine.ctx.currentTransaction);
        Assert.assertNull((Object)stateMachine.ctx.currentResultHandle);
        Assert.assertNull((Object)stateMachine.ctx.currentResult);
    }

    @Test
    public void shouldDoNothingInAutoCommitTransactionUponInitialisationWhenValidated() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTimedOutTransaction();
        TransactionStateMachineSPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.AUTO_COMMIT));
        Assert.assertNull((Object)stateMachine.ctx.currentTransaction);
        stateMachine.validateTransaction();
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.AUTO_COMMIT));
        Assert.assertNull((Object)stateMachine.ctx.currentTransaction);
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.never())).getReasonIfTerminated();
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.never())).failure();
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void shouldResetInAutoCommitTransactionWhileStatementIsRunningWhenValidated() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTimedOutTransaction();
        TransactionStateMachineSPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.AUTO_COMMIT));
        Assert.assertNull((Object)stateMachine.ctx.currentTransaction);
        stateMachine.run("RETURN 1", null);
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.AUTO_COMMIT));
        Assert.assertNotNull((Object)stateMachine.ctx.currentTransaction);
        stateMachine.validateTransaction();
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.AUTO_COMMIT));
        Assert.assertNull((Object)stateMachine.ctx.currentTransaction);
        Assert.assertNull((Object)stateMachine.ctx.currentResult);
        Assert.assertNull((Object)stateMachine.ctx.currentResultHandle);
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).getReasonIfTerminated();
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).failure();
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void shouldResetInExplicitTransactionUponTxBeginWhenValidated() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTimedOutTransaction();
        TransactionStateMachineSPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        stateMachine.run("BEGIN", this.map(new Object[0]));
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION));
        Assert.assertNotNull((Object)stateMachine.ctx.currentTransaction);
        stateMachine.validateTransaction();
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.AUTO_COMMIT));
        Assert.assertNull((Object)stateMachine.ctx.currentTransaction);
        Assert.assertNull((Object)stateMachine.ctx.currentResult);
        Assert.assertNull((Object)stateMachine.ctx.currentResultHandle);
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).getReasonIfTerminated();
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).failure();
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void shouldResetInExplicitTransactionWhileStatementIsRunningWhenValidated() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTimedOutTransaction();
        TransactionStateMachineSPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        stateMachine.run("BEGIN", this.map(new Object[0]));
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION));
        Assert.assertNotNull((Object)stateMachine.ctx.currentTransaction);
        stateMachine.run("RETURN 1", null);
        stateMachine.validateTransaction();
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.AUTO_COMMIT));
        Assert.assertNull((Object)stateMachine.ctx.currentTransaction);
        Assert.assertNull((Object)stateMachine.ctx.currentResult);
        Assert.assertNull((Object)stateMachine.ctx.currentResultHandle);
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).getReasonIfTerminated();
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).failure();
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void shouldUnbindTxAfterRun() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTimedOutTransaction();
        TransactionStateMachineSPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        stateMachine.run("SOME STATEMENT", null);
        ((TransactionStateMachineSPI)Mockito.verify((Object)stateMachineSPI, (VerificationMode)Mockito.times((int)1))).unbindTransactionFromCurrentThread();
    }

    @Test
    public void shouldUnbindTxAfterStreamResult() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTimedOutTransaction();
        TransactionStateMachineSPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        stateMachine.run("SOME STATEMENT", null);
        stateMachine.streamResult(boltResult -> {});
        ((TransactionStateMachineSPI)Mockito.verify((Object)stateMachineSPI, (VerificationMode)Mockito.times((int)2))).unbindTransactionFromCurrentThread();
    }

    @Test
    public void shouldThrowDuringRunIfPendingTerminationNoticeExists() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTimedOutTransaction();
        TransactionStateMachineSPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        stateMachine.ctx.pendingTerminationNotice = Status.Transaction.TransactionTimedOut;
        try {
            stateMachine.run("SOME STATEMENT", null);
            Assert.fail((String)"exception expected");
        }
        catch (TransactionTerminatedException t) {
            Assert.assertThat((Object)t.status(), (Matcher)CoreMatchers.is((Object)Status.Transaction.TransactionTimedOut));
        }
        catch (Throwable t) {
            Assert.fail((String)("expected TransactionTerminated but got " + t.getMessage()));
        }
    }

    @Test
    public void shouldThrowDuringStreamResultIfPendingTerminationNoticeExists() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTimedOutTransaction();
        TransactionStateMachineSPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        stateMachine.run("SOME STATEMENT", null);
        stateMachine.ctx.pendingTerminationNotice = Status.Transaction.TransactionTimedOut;
        try {
            stateMachine.streamResult(boltResult -> {});
            Assert.fail((String)"exception expected");
        }
        catch (TransactionTerminatedException t) {
            Assert.assertThat((Object)t.status(), (Matcher)CoreMatchers.is((Object)Status.Transaction.TransactionTimedOut));
        }
        catch (Throwable t) {
            Assert.fail((String)("expected TransactionTerminated but got " + t.getMessage()));
        }
    }

    @Test
    public void shouldCloseResultAndTransactionHandlesWhenExecutionFails() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTransaction();
        TransactionStateMachine.BoltResultHandle resultHandle = TransactionStateMachineTest.newResultHandle(new RuntimeException("some error"));
        TransactionStateMachineSPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction, resultHandle);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        try {
            stateMachine.run("SOME STATEMENT", null);
            Assert.fail((String)"exception expected");
        }
        catch (RuntimeException t) {
            Assert.assertEquals((Object)t.getMessage(), (Object)"some error");
        }
        Assert.assertNull((Object)stateMachine.ctx.currentResultHandle);
        Assert.assertNull((Object)stateMachine.ctx.currentResult);
        Assert.assertNull((Object)stateMachine.ctx.currentTransaction);
    }

    @Test
    public void shouldCloseResultAndTransactionHandlesWhenConsumeFails() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTransaction();
        TransactionStateMachineSPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        stateMachine.run("SOME STATEMENT", null);
        Assert.assertNotNull((Object)stateMachine.ctx.currentResultHandle);
        Assert.assertNotNull((Object)stateMachine.ctx.currentResult);
        try {
            stateMachine.streamResult(boltResult -> {
                throw new RuntimeException("some error");
            });
            Assert.fail((String)"exception expected");
        }
        catch (RuntimeException t) {
            Assert.assertEquals((Object)t.getMessage(), (Object)"some error");
        }
        Assert.assertNull((Object)stateMachine.ctx.currentResultHandle);
        Assert.assertNull((Object)stateMachine.ctx.currentResult);
        Assert.assertNull((Object)stateMachine.ctx.currentTransaction);
    }

    @Test
    public void shouldCloseResultHandlesWhenExecutionFailsInExplicitTransaction() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTransaction();
        TransactionStateMachine.BoltResultHandle resultHandle = TransactionStateMachineTest.newResultHandle(new RuntimeException("some error"));
        TransactionStateMachineSPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction, resultHandle);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        try {
            stateMachine.run("BEGIN", ValueUtils.asMapValue(Collections.emptyMap()));
            stateMachine.streamResult(boltResult -> {});
            stateMachine.run("SOME STATEMENT", null);
            Assert.fail((String)"exception expected");
        }
        catch (RuntimeException t) {
            Assert.assertEquals((Object)t.getMessage(), (Object)"some error");
        }
        Assert.assertNull((Object)stateMachine.ctx.currentResultHandle);
        Assert.assertNull((Object)stateMachine.ctx.currentResult);
        Assert.assertNotNull((Object)stateMachine.ctx.currentTransaction);
    }

    @Test
    public void shouldCloseResultHandlesWhenConsumeFailsInExplicitTransaction() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTransaction();
        TransactionStateMachineSPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        stateMachine.run("BEGIN", ValueUtils.asMapValue(Collections.emptyMap()));
        stateMachine.streamResult(boltResult -> {});
        stateMachine.run("SOME STATEMENT", null);
        Assert.assertNotNull((Object)stateMachine.ctx.currentResultHandle);
        Assert.assertNotNull((Object)stateMachine.ctx.currentResult);
        try {
            stateMachine.streamResult(boltResult -> {
                throw new RuntimeException("some error");
            });
            Assert.fail((String)"exception expected");
        }
        catch (RuntimeException t) {
            Assert.assertEquals((Object)t.getMessage(), (Object)"some error");
        }
        Assert.assertNull((Object)stateMachine.ctx.currentResultHandle);
        Assert.assertNull((Object)stateMachine.ctx.currentResult);
        Assert.assertNotNull((Object)stateMachine.ctx.currentTransaction);
    }

    private static KernelTransaction newTransaction() {
        KernelTransaction transaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)transaction.isOpen()).thenReturn((Object)true);
        return transaction;
    }

    private static KernelTransaction newTimedOutTransaction() {
        KernelTransaction transaction = TransactionStateMachineTest.newTransaction();
        Mockito.when((Object)transaction.getReasonIfTerminated()).thenReturn(Optional.of(Status.Transaction.TransactionTimedOut));
        return transaction;
    }

    private static TransactionStateMachine newTransactionStateMachine(TransactionStateMachineSPI stateMachineSPI) {
        return new TransactionStateMachine((TransactionStateMachine.SPI)stateMachineSPI, AuthenticationResult.AUTH_DISABLED, (Clock)new FakeClock());
    }

    private MapValue map(Object ... keyValues) {
        return ValueUtils.asMapValue((Map)MapUtil.map((Object[])keyValues));
    }

    private static TransactionStateMachineSPI newFailingTransactionStateMachineSPI(Status failureStatus) throws KernelException {
        TransactionStateMachine.BoltResultHandle resultHandle = TransactionStateMachineTest.newResultHandle();
        TransactionStateMachineSPI stateMachineSPI = (TransactionStateMachineSPI)Mockito.mock(TransactionStateMachineSPI.class);
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)stateMachineSPI.beginTransaction((LoginContext)ArgumentMatchers.any())).thenReturn((Object)kernelTransaction);
        Mockito.when((Object)stateMachineSPI.executeQuery((BoltQuerySource)ArgumentMatchers.any(), (LoginContext)ArgumentMatchers.any(), ArgumentMatchers.anyString(), (MapValue)ArgumentMatchers.any())).thenReturn((Object)resultHandle);
        Mockito.when((Object)stateMachineSPI.executeQuery((BoltQuerySource)ArgumentMatchers.any(), (LoginContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"FAIL"), (MapValue)ArgumentMatchers.any())).thenThrow(new Throwable[]{new TransactionTerminatedException(failureStatus)});
        return stateMachineSPI;
    }

    private static TransactionStateMachineSPI newTransactionStateMachineSPI(KernelTransaction transaction) throws KernelException {
        TransactionStateMachine.BoltResultHandle resultHandle = TransactionStateMachineTest.newResultHandle();
        TransactionStateMachineSPI stateMachineSPI = (TransactionStateMachineSPI)Mockito.mock(TransactionStateMachineSPI.class);
        Mockito.when((Object)stateMachineSPI.beginTransaction((LoginContext)ArgumentMatchers.any())).thenReturn((Object)transaction);
        Mockito.when((Object)stateMachineSPI.executeQuery((BoltQuerySource)ArgumentMatchers.any(), (LoginContext)ArgumentMatchers.any(), ArgumentMatchers.anyString(), (MapValue)ArgumentMatchers.any())).thenReturn((Object)resultHandle);
        return stateMachineSPI;
    }

    private static TransactionStateMachineSPI newTransactionStateMachineSPI(KernelTransaction transaction, TransactionStateMachine.BoltResultHandle resultHandle) throws KernelException {
        TransactionStateMachineSPI stateMachineSPI = (TransactionStateMachineSPI)Mockito.mock(TransactionStateMachineSPI.class);
        Mockito.when((Object)stateMachineSPI.beginTransaction((LoginContext)ArgumentMatchers.any())).thenReturn((Object)transaction);
        Mockito.when((Object)stateMachineSPI.executeQuery((BoltQuerySource)ArgumentMatchers.any(), (LoginContext)ArgumentMatchers.any(), ArgumentMatchers.anyString(), (MapValue)ArgumentMatchers.any())).thenReturn((Object)resultHandle);
        return stateMachineSPI;
    }

    private static TransactionStateMachine.BoltResultHandle newResultHandle() throws KernelException {
        TransactionStateMachine.BoltResultHandle resultHandle = (TransactionStateMachine.BoltResultHandle)Mockito.mock(TransactionStateMachine.BoltResultHandle.class);
        Mockito.when((Object)resultHandle.start()).thenReturn((Object)BoltResult.EMPTY);
        return resultHandle;
    }

    private static TransactionStateMachine.BoltResultHandle newResultHandle(Throwable t) throws KernelException {
        TransactionStateMachine.BoltResultHandle resultHandle = (TransactionStateMachine.BoltResultHandle)Mockito.mock(TransactionStateMachine.BoltResultHandle.class);
        Mockito.when((Object)resultHandle.start()).thenThrow(new Throwable[]{t});
        return resultHandle;
    }
}

