/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.integration;

import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.testing.BoltMatchers;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.v1.runtime.BoltConnectionFatality;
import org.neo4j.bolt.v1.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.integration.SessionRule;
import org.neo4j.function.ThrowingAction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.internal.Version;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualValues;

public class BoltConnectionAuthIT {
    private static final String USER_AGENT = "BoltConnectionAuthIT/0.0";
    private static final BoltChannel boltChannel = (BoltChannel)Mockito.mock(BoltChannel.class);
    @Rule
    public SessionRule env = new SessionRule().withAuthEnabled(true);

    @Test
    public void shouldGiveCredentialsExpiredStatusOnExpiredCredentials() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(boltChannel);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.init(USER_AGENT, MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "neo4j", "credentials", "neo4j"}), (BoltResponseHandler)recorder);
        machine.run("CREATE ()", VirtualValues.EMPTY_MAP, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeededWithMetadata("credentials_expired", (AnyValue)Values.TRUE));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.Security.CredentialsExpired));
    }

    @Test
    public void shouldGiveKernelVersionOnInit() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(boltChannel);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        String version = "Neo4j/" + Version.getNeo4jVersion();
        machine.init(USER_AGENT, MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "neo4j", "credentials", "neo4j"}), (BoltResponseHandler)recorder);
        machine.run("CREATE ()", VirtualValues.EMPTY_MAP, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeededWithMetadata("server", (AnyValue)Values.stringValue((String)version)));
    }

    @Test
    public void shouldCloseConnectionAfterAuthenticationFailure() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(boltChannel);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltMatchers.verifyKillsConnection((ThrowingAction<BoltConnectionFatality>)((ThrowingAction)() -> machine.init(USER_AGENT, MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "neo4j", "credentials", "j4oen"}), (BoltResponseHandler)recorder)));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.Security.Unauthorized));
    }

    @Test
    public void shouldBeAbleToActOnSessionWhenUpdatingCredentials() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(boltChannel);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.init(USER_AGENT, MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "neo4j", "credentials", "neo4j", "new_credentials", "secret"}), (BoltResponseHandler)recorder);
        machine.run("CREATE ()", VirtualValues.EMPTY_MAP, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
    }
}

