/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.integration;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.AllOf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.testing.BoltMatchers;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.v1.runtime.BoltConnectionFatality;
import org.neo4j.bolt.v1.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.integration.SessionRule;
import org.neo4j.concurrent.BinaryLatch;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.test.Barrier;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.values.virtual.VirtualValues;

public class TransactionIT {
    private static final String USER_AGENT = "TransactionIT/0.0";
    private static final Pattern BOOKMARK_PATTERN = Pattern.compile("neo4j:bookmark:v1:tx[0-9]+");
    private static final BoltChannel boltChannel = (BoltChannel)Mockito.mock(BoltChannel.class);
    @Rule
    public SessionRule env = new SessionRule();
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    @Test
    public void shouldHandleBeginCommit() throws Throwable {
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltStateMachine machine = this.env.newMachine(boltChannel);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        machine.run("BEGIN", VirtualValues.EMPTY_MAP, (BoltResponseHandler)recorder);
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.run("CREATE (n:InTx)", VirtualValues.EMPTY_MAP, (BoltResponseHandler)recorder);
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.run("COMMIT", VirtualValues.EMPTY_MAP, (BoltResponseHandler)recorder);
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
    }

    @Test
    public void shouldHandleBeginRollback() throws Throwable {
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltStateMachine machine = this.env.newMachine(boltChannel);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        machine.run("BEGIN", VirtualValues.EMPTY_MAP, (BoltResponseHandler)recorder);
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.run("CREATE (n:InTx)", VirtualValues.EMPTY_MAP, (BoltResponseHandler)recorder);
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.run("ROLLBACK", VirtualValues.EMPTY_MAP, (BoltResponseHandler)recorder);
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
    }

    @Test
    public void shouldNotFailWhenOutOfOrderRollbackInAutoCommitMode() throws Throwable {
        BoltResponseRecorder runRecorder = new BoltResponseRecorder();
        BoltResponseRecorder pullAllRecorder = new BoltResponseRecorder();
        BoltStateMachine machine = this.env.newMachine(boltChannel);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        machine.run("ROLLBACK", VirtualValues.EMPTY_MAP, (BoltResponseHandler)runRecorder);
        machine.pullAll((BoltResponseHandler)pullAllRecorder);
        MatcherAssert.assertThat((Object)runRecorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)pullAllRecorder.nextResponse(), BoltMatchers.succeeded());
    }

    @Test
    public void shouldReceiveBookmarkOnCommitAndDiscardAll() throws Throwable {
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltStateMachine machine = this.env.newMachine(boltChannel);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        machine.run("BEGIN", VirtualValues.EMPTY_MAP, (BoltResponseHandler)recorder);
        machine.discardAll((BoltResponseHandler)recorder);
        machine.run("CREATE (a:Person)", VirtualValues.EMPTY_MAP, (BoltResponseHandler)recorder);
        machine.discardAll((BoltResponseHandler)recorder);
        machine.run("COMMIT", VirtualValues.EMPTY_MAP, (BoltResponseHandler)recorder);
        machine.discardAll((BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeededWithMetadata("bookmark", BOOKMARK_PATTERN));
    }

    @Test
    public void shouldReceiveBookmarkOnCommitAndPullAll() throws Throwable {
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltStateMachine machine = this.env.newMachine(boltChannel);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        machine.run("BEGIN", VirtualValues.EMPTY_MAP, (BoltResponseHandler)recorder);
        machine.discardAll((BoltResponseHandler)recorder);
        machine.run("CREATE (a:Person)", VirtualValues.EMPTY_MAP, (BoltResponseHandler)recorder);
        machine.discardAll((BoltResponseHandler)recorder);
        machine.run("COMMIT", VirtualValues.EMPTY_MAP, (BoltResponseHandler)recorder);
        machine.pullAll((BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeededWithMetadata("bookmark", BOOKMARK_PATTERN));
    }

    @Test
    public void shouldReadYourOwnWrites() throws Exception {
        try (Transaction tx = this.env.graph().beginTx();){
            Node node = this.env.graph().createNode(new Label[]{Label.label((String)"A")});
            node.setProperty("prop", (Object)"one");
            tx.success();
        }
        BinaryLatch latch = new BinaryLatch();
        long dbVersion = this.env.lastClosedTxId();
        Thread thread = new Thread(() -> {
            try (BoltStateMachine machine = this.env.newMachine(boltChannel);){
                machine.init(USER_AGENT, Collections.emptyMap(), null);
                latch.await();
                machine.run("MATCH (n:A) SET n.prop = 'two'", VirtualValues.EMPTY_MAP, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
                machine.pullAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
            }
            catch (BoltConnectionFatality connectionFatality) {
                throw new RuntimeException(connectionFatality);
            }
        });
        thread.start();
        long dbVersionAfterWrite = dbVersion + 1L;
        try (BoltStateMachine machine = this.env.newMachine(boltChannel);){
            BoltResponseRecorder recorder = new BoltResponseRecorder();
            machine.init(USER_AGENT, Collections.emptyMap(), null);
            latch.release();
            String bookmark = "neo4j:bookmark:v1:tx" + Long.toString(dbVersionAfterWrite);
            machine.run("BEGIN", ValueUtils.asMapValue(Collections.singletonMap("bookmark", bookmark)), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
            machine.pullAll((BoltResponseHandler)recorder);
            machine.run("MATCH (n:A) RETURN n.prop", VirtualValues.EMPTY_MAP, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
            machine.pullAll((BoltResponseHandler)recorder);
            machine.run("COMMIT", VirtualValues.EMPTY_MAP, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
            machine.pullAll((BoltResponseHandler)recorder);
            MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeededWithMetadata("bookmark", BOOKMARK_PATTERN));
            MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeededWithRecord("two"));
            MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeededWithMetadata("bookmark", BOOKMARK_PATTERN));
        }
        thread.join();
    }

    @Test
    public void shouldTerminateQueriesEvenIfUsingPeriodicCommit() throws Exception {
        DoubleLatch latch = new DoubleLatch(3, true);
        Barrier.Control barrier = new Barrier.Control();
        Server server = TransactionIT.createHttpServer(latch, barrier, 20, 30);
        server.start();
        int localPort = this.getLocalPort(server);
        BoltStateMachine[] machine = new BoltStateMachine[]{null};
        Thread thread = new Thread(() -> {
            try (BoltStateMachine stateMachine = this.env.newMachine((BoltChannel)Mockito.mock(BoltChannel.class));){
                machine[0] = stateMachine;
                stateMachine.init(USER_AGENT, Collections.emptyMap(), null);
                String query = String.format("USING PERIODIC COMMIT 10 LOAD CSV FROM 'http://localhost:%d' AS line CREATE (n:A {id: line[0], square: line[1]}) WITH count(*) as number CREATE (n:ShouldNotExist)", localPort);
                try {
                    latch.start();
                    stateMachine.run(query, VirtualValues.EMPTY_MAP, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
                    stateMachine.pullAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
                }
                finally {
                    latch.finish();
                }
            }
            catch (BoltConnectionFatality connectionFatality) {
                throw new RuntimeException(connectionFatality);
            }
        });
        thread.setName("query runner");
        thread.start();
        latch.startAndWaitForAllToStart();
        Thread.sleep(1000L);
        machine[0].reset((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        barrier.release();
        latch.finishAndWaitForAllToFinish();
        try (Transaction ignored = this.env.graph().beginTx();){
            Assert.assertFalse((String)"Query was not terminated in time - nodes were created!", (boolean)this.env.graph().findNodes(Label.label((String)"ShouldNotExist")).hasNext());
        }
    }

    @Test
    public void shouldInterpretEmptyStatementAsReuseLastStatementInAutocommitTransaction() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(boltChannel);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.run("RETURN 1", VirtualValues.EMPTY_MAP, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.pullAll((BoltResponseHandler)recorder);
        machine.run("", VirtualValues.EMPTY_MAP, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.pullAll((BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeededWithRecord(1L));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeededWithRecord(1L));
    }

    @Test
    public void shouldInterpretEmptyStatementAsReuseLastStatementInExplicitTransaction() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(boltChannel);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.run("BEGIN", VirtualValues.EMPTY_MAP, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.run("RETURN 1", VirtualValues.EMPTY_MAP, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.pullAll((BoltResponseHandler)recorder);
        machine.run("", VirtualValues.EMPTY_MAP, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.pullAll((BoltResponseHandler)recorder);
        machine.run("COMMIT", VirtualValues.EMPTY_MAP, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeededWithRecord(1L));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeededWithRecord(1L));
    }

    @Test
    public void beginShouldNotOverwriteLastStatement() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(boltChannel);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.run("RETURN 1", VirtualValues.EMPTY_MAP, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.pullAll((BoltResponseHandler)recorder);
        machine.run("BEGIN", VirtualValues.EMPTY_MAP, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.run("", VirtualValues.EMPTY_MAP, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.pullAll((BoltResponseHandler)recorder);
        machine.run("COMMIT", VirtualValues.EMPTY_MAP, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.discardAll((BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeededWithRecord(1L));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeededWithRecord(1L));
    }

    @Test
    public void shouldCloseAutoCommitTransactionAndRespondToNextStatementWhenRunFails() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(boltChannel);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.run("INVALID QUERY", VirtualValues.EMPTY_MAP, (BoltResponseHandler)recorder);
        machine.pullAll((BoltResponseHandler)recorder);
        machine.ackFailure((BoltResponseHandler)recorder);
        machine.run("RETURN 2", VirtualValues.EMPTY_MAP, (BoltResponseHandler)recorder);
        machine.pullAll((BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.Statement.SyntaxError));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.wasIgnored());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeededWithRecord(2L));
        Assert.assertEquals((long)recorder.responseCount(), (long)0L);
    }

    @Test
    public void shouldCloseAutoCommitTransactionAndRespondToNextStatementWhenStreamingFails() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(boltChannel);
        machine.init(USER_AGENT, Collections.emptyMap(), null);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.run("UNWIND [1, 0] AS x RETURN 1 / x", VirtualValues.EMPTY_MAP, (BoltResponseHandler)recorder);
        machine.pullAll((BoltResponseHandler)recorder);
        machine.ackFailure((BoltResponseHandler)recorder);
        machine.run("RETURN 2", VirtualValues.EMPTY_MAP, (BoltResponseHandler)recorder);
        machine.pullAll((BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)AllOf.allOf(BoltMatchers.containsRecord(1L), BoltMatchers.failedWithStatus((Status)Status.Statement.ArithmeticError)));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeededWithRecord(2L));
        Assert.assertEquals((long)recorder.responseCount(), (long)0L);
    }

    public static Server createHttpServer(final DoubleLatch latch, final Barrier.Control innerBarrier, final int firstBatchSize, final int otherBatchSize) {
        Server server = new Server(0);
        server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                response.setContentType("text/plain; charset=utf-8");
                response.setStatus(200);
                PrintWriter out = response.getWriter();
                this.writeBatch(out, firstBatchSize);
                out.flush();
                latch.start();
                innerBarrier.reached();
                latch.finish();
                this.writeBatch(out, otherBatchSize);
                baseRequest.setHandled(true);
            }

            private void writeBatch(PrintWriter out, int batchSize) {
                for (int i = 0; i < batchSize; ++i) {
                    out.write(String.format("%d %d\n", i, i * i));
                    ++i;
                }
            }
        });
        return server;
    }

    private int getLocalPort(Server server) {
        return ((ServerConnector)server.getConnectors()[0]).getLocalPort();
    }
}

