/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.spi;

import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.neo4j.bolt.v1.runtime.spi.BoltResult;
import org.neo4j.cypher.result.QueryResult;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.NumberValue;

public class StreamMatchers {
    private StreamMatchers() {
    }

    public static Matcher<AnyValue> greaterThanOrEqualTo(final long input) {
        return new TypeSafeMatcher<AnyValue>(){

            public void describeTo(Description description) {
                description.appendText("Value = " + input);
            }

            protected boolean matchesSafely(AnyValue value) {
                return value instanceof NumberValue && ((NumberValue)value).longValue() >= input;
            }
        };
    }

    public static Matcher<QueryResult.Record> eqRecord(final Matcher<?> ... expectedFieldValues) {
        return new TypeSafeMatcher<QueryResult.Record>(){

            protected boolean matchesSafely(QueryResult.Record item) {
                if (expectedFieldValues.length != item.fields().length) {
                    return false;
                }
                for (int i = 0; i < item.fields().length; ++i) {
                    if (expectedFieldValues[i].matches((Object)item.fields()[i])) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("Record[").appendList(", fields=[", ",", "]", Arrays.asList(expectedFieldValues));
            }
        };
    }

    public static Matcher<BoltResult> equalsStream(final String[] fieldNames, final Matcher ... records) {
        return new TypeSafeMatcher<BoltResult>(){

            protected boolean matchesSafely(BoltResult item) {
                if (!Arrays.equals(fieldNames, item.fieldNames())) {
                    return false;
                }
                final Iterator<Matcher> expected = Arrays.asList(records).iterator();
                final AtomicBoolean matched = new AtomicBoolean(true);
                try {
                    item.accept(new BoltResult.Visitor(){

                        public void visit(QueryResult.Record record) {
                            if (!expected.hasNext() || !((Matcher)expected.next()).matches((Object)record)) {
                                matched.set(false);
                            }
                        }

                        public void addMetadata(String key, AnyValue value) {
                        }
                    });
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return matched.get() && !expected.hasNext();
            }

            public void describeTo(Description description) {
                description.appendText("Stream[").appendValueList(" fieldNames=[", ",", "]", (Object[])fieldNames).appendList(", records=[", ",", "]", Arrays.asList(records));
            }
        };
    }
}

