/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.integration;

import java.util.Arrays;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.bolt.AbstractBoltTransportsTest;
import org.neo4j.bolt.v1.messaging.BoltRequestMessage;
import org.neo4j.bolt.v1.messaging.RecordingByteChannel;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.packstream.BufferedChannelOutput;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.packstream.PackStream;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;

public class TransportErrorIT
extends AbstractBoltTransportsTest {
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass());

    @Before
    public void setup() {
        this.address = this.server.lookupDefaultConnector();
    }

    @Test
    public void shouldHandleIncorrectFraming() throws Throwable {
        byte[] truncated = MessageMatchers.serialize(this.util.getNeo4jPack(), RunMessage.run("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared"));
        truncated = Arrays.copyOf(truncated, truncated.length - 12);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(32, new byte[][]{truncated}));
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldHandleMessagesWithIncorrectFields() throws Throwable {
        RecordingByteChannel rawData = new RecordingByteChannel();
        PackStream.Packer packer = new PackStream.Packer((PackOutput)new BufferedChannelOutput(rawData));
        packer.packStructHeader(2, BoltRequestMessage.RUN.signature());
        packer.pack("RETURN 1");
        packer.pack(1234L);
        packer.flush();
        byte[] invalidMessage = rawData.getBytes();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(32, new byte[][]{invalidMessage}));
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldHandleUnknownMessages() throws Throwable {
        RecordingByteChannel rawData = new RecordingByteChannel();
        PackStream.Packer packer = new PackStream.Packer((PackOutput)new BufferedChannelOutput(rawData));
        packer.packStructHeader(1, (byte)102);
        packer.pack(1234L);
        packer.flush();
        byte[] invalidMessage = rawData.getBytes();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(32, new byte[][]{invalidMessage}));
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldHandleUnknownMarkerBytes() throws Throwable {
        RecordingByteChannel rawData = new RecordingByteChannel();
        BufferedChannelOutput out = new BufferedChannelOutput(rawData);
        PackStream.Packer packer = new PackStream.Packer((PackOutput)out);
        packer.packStructHeader(2, BoltRequestMessage.RUN.signature());
        out.writeByte((byte)-57);
        out.flush();
        byte[] invalidMessage = rawData.getBytes();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(32, new byte[][]{invalidMessage}));
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, TransportTestUtil.eventuallyDisconnects());
    }
}

